/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes;

import java.math.BigInteger;

public class FloatingPointUtils {
    private static final long DOUBLE_MAGNITUDE_MASK = Long.MAX_VALUE;
    private static final long DOUBLE_NEGATIVE_ZERO_BITS = Long.MIN_VALUE;
    private static final long DOUBLE_POSITIVE_ZERO_BITS = 0L;
    private static final long DOUBLE_SIGN_MASK = Long.MIN_VALUE;
    private static final int FLOAT_MAGNITUDE_MASK = Integer.MAX_VALUE;
    private static final int FLOAT_NEGATIVE_ZERO_BITS = Integer.MIN_VALUE;
    private static final int FLOAT_POSITIVE_ZERO_BITS = 0;
    private static final int FLOAT_SIGN_MASK = Integer.MIN_VALUE;

    public static Double decrement(Double n) {
        if (n.isNaN() || n.isInfinite()) {
            return n;
        }
        long i = Double.doubleToRawLongBits(n);
        if (i == 0L) {
            return Double.longBitsToDouble(Long.MIN_VALUE);
        }
        if ((i & Long.MIN_VALUE) == 0L) {
            return Double.longBitsToDouble(i - 1L);
        }
        return Double.longBitsToDouble(i + 1L);
    }

    public static Float decrement(Float n) {
        if (n.isNaN() || n.isInfinite()) {
            return n;
        }
        int i = Float.floatToRawIntBits(n.floatValue());
        if (i == 0) {
            return Float.valueOf(Float.intBitsToFloat(Integer.MIN_VALUE));
        }
        if ((i & Integer.MIN_VALUE) == 0) {
            return Float.valueOf(Float.intBitsToFloat(i - 1));
        }
        return Float.valueOf(Float.intBitsToFloat(i + 1));
    }

    public static Double increment(Double n) {
        if (n.isNaN() || n.isInfinite()) {
            return n;
        }
        long i = Double.doubleToRawLongBits(n);
        if (i == Long.MIN_VALUE) {
            return Double.longBitsToDouble(0L);
        }
        if ((i & Long.MIN_VALUE) == 0L) {
            return Double.longBitsToDouble(i + 1L);
        }
        return Double.longBitsToDouble(i - 1L);
    }

    public static Float increment(Float n) {
        if (n.isNaN() || n.isInfinite()) {
            return n;
        }
        int i = Float.floatToRawIntBits(n.floatValue());
        if (i == Integer.MIN_VALUE) {
            return Float.valueOf(Float.intBitsToFloat(0));
        }
        if ((i & Integer.MIN_VALUE) == 0) {
            return Float.valueOf(Float.intBitsToFloat(i + 1));
        }
        return Float.valueOf(Float.intBitsToFloat(i - 1));
    }

    public static BigInteger intervalSize(Double lower, Double upper) {
        if (lower.isNaN()) {
            throw new IllegalArgumentException();
        }
        if (upper.isNaN()) {
            throw new IllegalArgumentException();
        }
        long lowerBits = Double.doubleToRawLongBits(lower);
        long upperBits = Double.doubleToRawLongBits(upper);
        if ((Long.MIN_VALUE & lowerBits) == Long.MIN_VALUE) {
            if ((Long.MIN_VALUE & upperBits) == Long.MIN_VALUE) {
                return BigInteger.valueOf((Long.MAX_VALUE & lowerBits) - (Long.MAX_VALUE & upperBits) + 1L);
            }
            return BigInteger.valueOf(Long.MAX_VALUE & lowerBits).add(BigInteger.valueOf(Long.MAX_VALUE & upperBits)).add(BigInteger.valueOf(2L));
        }
        return BigInteger.valueOf((Long.MAX_VALUE & upperBits) - (Long.MAX_VALUE & lowerBits) + 1L);
    }

    public static long intervalSize(Float lower, Float upper) {
        if (lower.isNaN()) {
            throw new IllegalArgumentException();
        }
        if (upper.isNaN()) {
            throw new IllegalArgumentException();
        }
        int lowerBits = Float.floatToRawIntBits(lower.floatValue());
        int upperBits = Float.floatToRawIntBits(upper.floatValue());
        if ((Integer.MIN_VALUE & lowerBits) == Integer.MIN_VALUE) {
            if ((Integer.MIN_VALUE & upperBits) == Integer.MIN_VALUE) {
                return (Integer.MAX_VALUE & lowerBits) - (Integer.MAX_VALUE & upperBits) + 1;
            }
            return (long)(Integer.MAX_VALUE & lowerBits) + (long)(Integer.MAX_VALUE & upperBits) + 2L;
        }
        return (Integer.MAX_VALUE & upperBits) - (Integer.MAX_VALUE & lowerBits) + 1;
    }
}

