/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.model;

import aterm.ATermAppl;
import com.clarkparsia.pellet.rules.RulesToATermTranslator;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.mindswap.pellet.utils.ATermUtils;

public class Rule {
    private ATermAppl name;
    private Collection<? extends RuleAtom> body;
    private Collection<? extends RuleAtom> head;
    private Set<ATermAppl> explanation;

    public Rule(Collection<? extends RuleAtom> head, Collection<? extends RuleAtom> body) {
        this(head, body, null);
    }

    public Rule(Collection<? extends RuleAtom> head, Collection<? extends RuleAtom> body, Set<ATermAppl> explanation) {
        this(null, head, body, explanation);
    }

    public Rule(ATermAppl name, Collection<? extends RuleAtom> head, Collection<? extends RuleAtom> body) {
        this(name, head, body, null);
    }

    public Rule(ATermAppl name, Collection<? extends RuleAtom> head, Collection<? extends RuleAtom> body, Set<ATermAppl> explanation) {
        this.name = name;
        this.body = body;
        this.head = head;
        this.explanation = explanation;
    }

    public Set<ATermAppl> getExplanation(RulesToATermTranslator translator) {
        if (this.explanation == null) {
            this.explanation = Collections.singleton(translator.translate(this));
        }
        return this.explanation;
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass().equals(other.getClass())) {
            Rule rule = (Rule)other;
            return this.getHead().equals(rule.getHead()) && this.getBody().equals(rule.getBody());
        }
        return false;
    }

    public Collection<? extends RuleAtom> getBody() {
        return this.body;
    }

    public Collection<? extends RuleAtom> getHead() {
        return this.head;
    }

    public ATermAppl getName() {
        return this.name;
    }

    public int hashCode() {
        return this.getBody().hashCode() + this.getHead().hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Rule(");
        if (this.name != null) {
            sb.append(ATermUtils.toString(this.name));
            sb.append(" ");
        }
        sb.append(this.getBody());
        sb.append(" => ");
        sb.append(this.getHead());
        sb.append(")");
        return sb.toString();
    }
}

