/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.rules.BindingHelper;
import com.clarkparsia.pellet.rules.ContinuousRulesStrategy;
import com.clarkparsia.pellet.rules.VariableUtils;
import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.builtins.BuiltInRegistry;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.AtomObject;
import com.clarkparsia.pellet.rules.model.AtomObjectVisitor;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.DifferentIndividualsAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.RuleAtomVisitor;
import com.clarkparsia.pellet.rules.model.SameIndividualAtom;
import com.clarkparsia.pellet.rules.rete.AlphaNetwork;
import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.BetaBuiltinNode;
import com.clarkparsia.pellet.rules.rete.BetaMemoryNode;
import com.clarkparsia.pellet.rules.rete.BetaNode;
import com.clarkparsia.pellet.rules.rete.BetaTopNode;
import com.clarkparsia.pellet.rules.rete.BuiltInCondition;
import com.clarkparsia.pellet.rules.rete.FilterCondition;
import com.clarkparsia.pellet.rules.rete.JoinCondition;
import com.clarkparsia.pellet.rules.rete.NodeProvider;
import com.clarkparsia.pellet.rules.rete.ProductionNode;
import com.clarkparsia.pellet.rules.rete.ReteNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.utils.SetUtils;

public class Compiler {
    protected ContinuousRulesStrategy strategy;
    private ABox abox;
    private AlphaNetwork alphaNet;
    private SafetyChecker safetyChecker = new SafetyChecker();

    public Compiler(ContinuousRulesStrategy strategy) {
        this.strategy = strategy;
        this.abox = strategy.getABox();
        this.alphaNet = new AlphaNetwork(this.abox);
    }

    public AlphaNetwork getAlphaNet() {
        return this.alphaNet;
    }

    private RuleAtom pickNextAtom(List<RuleAtom> atoms, Set<AtomVariable> bound) {
        int index = 0;
        if (bound.isEmpty()) {
            for (int i = 0; i < atoms.size(); ++i) {
                RuleAtom atom = atoms.get(i);
                if (!this.safetyChecker.isSafe(atom)) continue;
                return atoms.remove(i);
            }
        } else {
            for (int i = 0; i < atoms.size(); ++i) {
                RuleAtom atom = atoms.get(i);
                if (!SetUtils.intersects(bound, atom.getAllArguments())) continue;
                index = i;
                if (!this.safetyChecker.isSafe(atom)) {
                    continue;
                }
                break;
            }
        }
        return atoms.remove(index);
    }

    /*
     * WARNING - void declaration
     */
    public void compile(Rule rule, Set<ATermAppl> explain) {
        ArrayList<RuleAtom> atoms = new ArrayList<RuleAtom>();
        ArrayList<BuiltInCall> builtins = new ArrayList<BuiltInCall>();
        for (RuleAtom ruleAtom : rule.getBody()) {
            if (ruleAtom instanceof BuiltInAtom) {
                builtins.add(new BuiltInCall(this.abox, (BuiltInAtom)ruleAtom));
                continue;
            }
            if (ruleAtom instanceof DataRangeAtom) continue;
            atoms.add(ruleAtom);
        }
        HashSet<AtomVariable> bound = new HashSet<AtomVariable>();
        ArrayList<RuleAtom> arrayList = new ArrayList<RuleAtom>();
        int lastSafe = -1;
        ReteNode lastSafeBeta = null;
        boolean canReuseBeta = false;
        RuleAtom atom = null;
        Object node = null;
        while (!atoms.isEmpty()) {
            Object bindableVars;
            atom = this.pickNextAtom(atoms, bound);
            if (!this.safetyChecker.isSafe(atom)) {
                lastSafe = arrayList.size();
                lastSafeBeta = node;
            }
            AlphaNode alpha = this.alphaNet.addNode(atom);
            List<? extends AtomObject> args = atom.getAllArguments();
            ArrayList<FilterCondition> arrayList2 = new ArrayList<FilterCondition>();
            if (!arrayList.isEmpty()) {
                void var15_24;
                boolean bl = false;
                int n = args.size();
                while (var15_24 < n) {
                    NodeProvider.TokenNodeProvider provider;
                    AtomObject arg = args.get((int)var15_24);
                    if (arg instanceof AtomVariable && (provider = Compiler.createNodeProvider((AtomVariable)arg, arrayList)) != null) {
                        arrayList2.add(new JoinCondition(new NodeProvider.WMENodeProvider((int)var15_24), provider));
                    }
                    ++var15_24;
                }
            }
            arrayList.add(atom);
            bound.addAll(VariableUtils.getVars(atom));
            Iterator iterator = builtins.iterator();
            while (iterator.hasNext()) {
                BuiltInCall call = (BuiltInCall)iterator.next();
                if (!bound.containsAll(call.getPrerequisitesVars(bound)) || !(bindableVars = call.getBindableVars(bound)).isEmpty() && !bound.containsAll((Collection<?>)bindableVars)) continue;
                arrayList2.add(call.createCondition(arrayList));
                iterator.remove();
            }
            boolean bl = node == null;
            Object newBeta = null;
            if (canReuseBeta) {
                if (bl) {
                    bindableVars = alpha.getBetas().iterator();
                    while (bindableVars.hasNext()) {
                        BetaNode existingBeta = (BetaNode)bindableVars.next();
                        if (!existingBeta.isTop()) continue;
                        newBeta = existingBeta;
                        break;
                    }
                } else {
                    Set<BetaNode> sharedBetas = SetUtils.intersection(alpha.getBetas(), ((ReteNode)node).getBetas());
                    for (BetaNode existingBeta : sharedBetas) {
                        BetaMemoryNode existingBetaMem;
                        if (!(existingBeta instanceof BetaMemoryNode) || !(existingBetaMem = (BetaMemoryNode)existingBeta).getConditions().equals(arrayList2)) continue;
                        newBeta = existingBeta;
                        break;
                    }
                }
            }
            if (newBeta == null) {
                newBeta = bl ? new BetaTopNode(alpha) : new BetaMemoryNode(alpha, arrayList2);
                canReuseBeta = false;
            }
            alpha.addChild((BetaNode)newBeta);
            if (!bl) {
                ((ReteNode)node).addChild((BetaNode)newBeta);
            }
            node = newBeta;
            int bindingCount = -1;
            while (!builtins.isEmpty() && bindingCount != bound.size()) {
                bindingCount = bound.size();
                Iterator i2 = builtins.iterator();
                while (i2.hasNext()) {
                    BuiltInCall call = (BuiltInCall)i2.next();
                    if (!bound.containsAll(call.getPrerequisitesVars(bound))) continue;
                    newBeta = call.createBeta(arrayList);
                    ((ReteNode)node).addChild((BetaNode)newBeta);
                    node = newBeta;
                    arrayList.add(call.atom);
                    bound.addAll(call.getBindableVars(bound));
                    canReuseBeta = false;
                    i2.remove();
                }
            }
        }
        if (!builtins.isEmpty()) {
            throw new UnsupportedOperationException("Builtin using unsafe variables: " + builtins);
        }
        if (lastSafe == 0) {
            this.strategy.addUnsafeRule(rule, explain);
        } else if (lastSafe > 0) {
            HashMap<AtomVariable, NodeProvider> args = new HashMap<AtomVariable, NodeProvider>();
            for (int i = 0; i < lastSafe; ++i) {
                for (AtomObject atomObject : ((RuleAtom)arrayList.get(i)).getAllArguments()) {
                    if (!(atomObject instanceof AtomVariable) || args.containsKey(atomObject)) continue;
                    args.put((AtomVariable)atomObject, Compiler.createNodeProvider((AtomVariable)atomObject, arrayList));
                }
            }
            lastSafeBeta.addChild(new ProductionNode.ProduceBinding(this.strategy, explain, rule, args));
        }
        if (rule.getHead().isEmpty()) {
            ((ReteNode)node).addChild(new ProductionNode.Inconsistency(this.strategy, explain));
        } else {
            ProductionNodeCreator creator = new ProductionNodeCreator(arrayList, explain);
            for (RuleAtom ruleAtom : rule.getHead()) {
                ((ReteNode)node).addChild(creator.create(ruleAtom));
            }
        }
    }

    private static NodeProvider.TokenNodeProvider createNodeProvider(AtomVariable arg, List<RuleAtom> processed) {
        return (NodeProvider.TokenNodeProvider)Compiler.createNodeProvider(arg, processed, false);
    }

    private static NodeProvider createNodeProvider(AtomVariable arg, List<RuleAtom> processed, boolean lastWME) {
        int n = processed.size();
        for (int index = 0; index < n; ++index) {
            RuleAtom sharedAtom = processed.get(index);
            int indexArg = sharedAtom.getAllArguments().indexOf(arg);
            if (indexArg == -1) continue;
            if (lastWME && index == n - 1) {
                return new NodeProvider.WMENodeProvider(indexArg);
            }
            return new NodeProvider.TokenNodeProvider(index, indexArg);
        }
        return null;
    }

    private static class BuiltInCall {
        private ABox abox;
        private BuiltInAtom atom;
        private BuiltIn builtin;
        private BindingHelper helper;

        public BuiltInCall(ABox abox, BuiltInAtom atom) {
            this.abox = abox;
            this.atom = atom;
            this.builtin = BuiltInRegistry.instance.getBuiltIn((String)atom.getPredicate());
            this.helper = this.builtin.createHelper(atom);
        }

        public BetaBuiltinNode createBeta(List<RuleAtom> processed) {
            return new BetaBuiltinNode(this.abox, (String)this.atom.getPredicate(), this.builtin, this.createProviders(processed, false));
        }

        public FilterCondition createCondition(List<RuleAtom> processed) {
            return new BuiltInCondition(this.abox, (String)this.atom.getPredicate(), this.builtin, this.createProviders(processed, true));
        }

        private NodeProvider[] createProviders(List<RuleAtom> processed, boolean lastWME) {
            List<AtomDObject> args = this.atom.getAllArguments();
            NodeProvider[] providers = new NodeProvider[args.size()];
            AtomObjectTranslator translator = new AtomObjectTranslator(this.abox, processed, lastWME);
            for (int i = 0; i < providers.length; ++i) {
                providers[i] = translator.translateObject(args.get(i), true);
            }
            return providers;
        }

        public Collection<? extends AtomVariable> getPrerequisitesVars(Collection<AtomVariable> bound) {
            return this.helper.getPrerequisiteVars(bound);
        }

        public Collection<? extends AtomVariable> getBindableVars(Collection<AtomVariable> bound) {
            return this.helper.getBindableVars(bound);
        }

        public String toString() {
            return this.atom.toString();
        }
    }

    private static class AtomObjectTranslator
    implements AtomObjectVisitor {
        private DependencySet dependency = DependencySet.INDEPENDENT;
        private NodeProvider result = null;
        private final ABox abox;
        private final List<RuleAtom> processed;
        private final boolean lastWME;

        public AtomObjectTranslator(ABox abox, List<RuleAtom> processed, boolean lastWME) {
            this.abox = abox;
            this.processed = processed;
            this.lastWME = lastWME;
        }

        public DependencySet getDependency() {
            return this.dependency;
        }

        public NodeProvider translateObject(AtomObject obj) {
            return this.translateObject(obj, false);
        }

        public NodeProvider translateObject(AtomObject obj, boolean allowNull) {
            this.dependency = DependencySet.INDEPENDENT;
            obj.accept(this);
            if (this.result == null && !allowNull) {
                throw new UnsupportedOperationException();
            }
            return this.result;
        }

        @Override
        public void visit(AtomDConstant constant) {
            ATermAppl canonical;
            ATermAppl literal = constant.getValue();
            try {
                canonical = this.abox.getKB().getDatatypeReasoner().getCanonicalRepresentation(literal);
            }
            catch (InvalidLiteralException e) {
                String msg = String.format("Invalid literal (%s) in SWRL data constant: %s", literal, e.getMessage());
                if (PelletOptions.INVALID_LITERAL_AS_INCONSISTENCY) {
                    canonical = literal;
                }
                throw new InternalReasonerException(msg, e);
            }
            catch (UnrecognizedDatatypeException e) {
                String msg = String.format("Unrecognized datatype in literal appearing (%s) in SWRL data constant: %s", literal, e.getMessage());
                throw new InternalReasonerException(msg, e);
            }
            this.result = new NodeProvider.ConstantNodeProvider(this.abox.addLiteral(canonical));
        }

        @Override
        public void visit(AtomDVariable variable) {
            this.result = Compiler.createNodeProvider(variable, this.processed, this.lastWME);
        }

        @Override
        public void visit(AtomIConstant constant) {
            this.abox.copyOnWrite();
            Individual individual = this.abox.getIndividual((ATerm)constant.getValue());
            this.result = new NodeProvider.ConstantNodeProvider(individual);
        }

        @Override
        public void visit(AtomIVariable variable) {
            this.result = Compiler.createNodeProvider(variable, this.processed, this.lastWME);
        }
    }

    private class ProductionNodeCreator
    implements RuleAtomVisitor {
        private final AtomObjectTranslator translator;
        private Set<ATermAppl> explain;
        private ProductionNode node;

        public ProductionNodeCreator(List<RuleAtom> processed, Set<ATermAppl> explain) {
            this.translator = new AtomObjectTranslator(Compiler.this.abox, processed, false);
            this.explain = explain;
        }

        private ProductionNode create(RuleAtom atom) {
            this.node = null;
            atom.accept(this);
            if (this.node == null) {
                throw new UnsupportedOperationException("Not supported " + atom);
            }
            return this.node;
        }

        @Override
        public void visit(SameIndividualAtom atom) {
            NodeProvider s = this.translator.translateObject((AtomObject)atom.getArgument1());
            NodeProvider o = this.translator.translateObject((AtomObject)atom.getArgument2());
            this.node = new ProductionNode.SameAs(Compiler.this.strategy, this.explain, s, o);
        }

        @Override
        public void visit(IndividualPropertyAtom atom) {
            NodeProvider s = this.translator.translateObject((AtomObject)atom.getArgument1());
            NodeProvider o = this.translator.translateObject((AtomObject)atom.getArgument2());
            Role r = Compiler.this.abox.getRole((ATerm)atom.getPredicate());
            this.node = new ProductionNode.Edge(Compiler.this.strategy, this.explain, s, r, o);
        }

        @Override
        public void visit(DifferentIndividualsAtom atom) {
            NodeProvider s = this.translator.translateObject((AtomObject)atom.getArgument1());
            NodeProvider o = this.translator.translateObject((AtomObject)atom.getArgument2());
            this.node = new ProductionNode.DiffFrom(Compiler.this.strategy, this.explain, s, o);
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            NodeProvider s = this.translator.translateObject((AtomObject)atom.getArgument1());
            NodeProvider o = this.translator.translateObject((AtomObject)atom.getArgument2());
            Role r = Compiler.this.abox.getRole((ATerm)atom.getPredicate());
            this.node = new ProductionNode.Edge(Compiler.this.strategy, this.explain, s, r, o);
        }

        @Override
        public void visit(DataRangeAtom atom) {
        }

        @Override
        public void visit(ClassAtom atom) {
            NodeProvider s = this.translator.translateObject((AtomObject)atom.getArgument());
            ATermAppl type = (ATermAppl)atom.getPredicate();
            this.node = new ProductionNode.Type(Compiler.this.strategy, this.explain, s, type);
        }

        @Override
        public void visit(BuiltInAtom atom) {
        }
    }

    private class SafetyChecker
    implements RuleAtomVisitor {
        private boolean result = false;

        private SafetyChecker() {
        }

        public boolean isSafe(RuleAtom atom) {
            atom.accept(this);
            return this.result;
        }

        @Override
        public void visit(BuiltInAtom atom) {
            this.result = true;
        }

        @Override
        public void visit(ClassAtom atom) {
            ATermAppl c = (ATermAppl)atom.getPredicate();
            this.result = Compiler.this.abox.getKB().getTBox().isPrimitive(c);
        }

        @Override
        public void visit(DataRangeAtom atom) {
            this.result = true;
        }

        @Override
        public void visit(DatavaluedPropertyAtom atom) {
            this.result = true;
        }

        @Override
        public void visit(DifferentIndividualsAtom atom) {
            this.result = false;
        }

        @Override
        public void visit(IndividualPropertyAtom atom) {
            this.result = Compiler.this.abox.getRole((ATerm)atom.getPredicate()).isSimple();
        }

        @Override
        public void visit(SameIndividualAtom atom) {
            this.result = true;
        }
    }
}

