/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.completion.rule;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;
import org.mindswap.pellet.tableau.completion.queue.NodeSelector;
import org.mindswap.pellet.tableau.completion.rule.AbstractTableauRule;
import org.mindswap.pellet.utils.ATermUtils;

public class AllValuesRule
extends AbstractTableauRule {
    public AllValuesRule(CompletionStrategy strategy) {
        super(strategy, NodeSelector.UNIVERSAL, AbstractTableauRule.BlockingType.NONE);
    }

    @Override
    public void apply(Individual x) {
        List<ATermAppl> allValues = x.getTypes(3);
        int size = allValues.size();
        Iterator<ATermAppl> i = allValues.iterator();
        while (i.hasNext()) {
            ATermAppl av = i.next();
            DependencySet avDepends = x.getDepends((ATerm)av);
            if (!PelletOptions.MAINTAIN_COMPLETION_QUEUE && avDepends == null) continue;
            this.applyAllValues(x, av, avDepends);
            if (x.isMerged() || this.strategy.getABox().isClosed()) {
                return;
            }
            if (size == allValues.size()) continue;
            i = allValues.iterator();
            size = allValues.size();
        }
    }

    public void applyAllValues(Individual x, ATermAppl av, DependencySet ds) {
        if (av.getArity() == 0) {
            throw new InternalReasonerException();
        }
        ATerm p = av.getArgument(0);
        ATermAppl c = (ATermAppl)av.getArgument(1);
        ATermList roleChain = ATermUtils.EMPTY_LIST;
        Role s = null;
        if (p.getType() == 4) {
            roleChain = (ATermList)p;
            s = this.strategy.getABox().getRole(roleChain.getFirst());
            roleChain = roleChain.getNext();
        } else {
            s = this.strategy.getABox().getRole(p);
        }
        if (s.isTop() && s.isObjectRole()) {
            this.applyAllValuesTop(av, c, ds);
            return;
        }
        EdgeList edges = x.getRNeighborEdges(s);
        for (int e = 0; e < edges.size(); ++e) {
            Edge edgeToY = edges.edgeAt(e);
            Node y = edgeToY.getNeighbor(x);
            DependencySet finalDS = ds.union(edgeToY.getDepends(), this.strategy.getABox().doExplanation());
            if (roleChain.isEmpty()) {
                this.applyAllValues(x, s, y, c, finalDS);
            } else if (y.isIndividual()) {
                ATermAppl allRC = ATermUtils.makeAllValues((ATerm)roleChain, (ATerm)c);
                this.strategy.addType(y, allRC, finalDS);
            }
            if (!x.isMerged() && !this.strategy.getABox().isClosed()) continue;
            return;
        }
        if (!s.isSimple()) {
            Set<ATermList> subRoleChains = s.getSubRoleChains();
            for (ATermList chain : subRoleChains) {
                DependencySet subChainDS;
                if (this.applyAllValuesPropertyChain(x, chain, c, subChainDS = ds.union(s.getExplainSub((ATerm)chain), this.strategy.getABox().doExplanation()))) continue;
                return;
            }
        }
        if (!roleChain.isEmpty()) {
            this.applyAllValuesPropertyChain(x, (ATermList)p, c, ds);
        }
    }

    protected boolean applyAllValuesPropertyChain(Individual x, ATermList chain, ATermAppl c, DependencySet ds) {
        Role r = this.strategy.getABox().getRole(chain.getFirst());
        EdgeList edges = x.getRNeighborEdges(r);
        if (!edges.isEmpty()) {
            ATermAppl allRC = ATermUtils.makeAllValues((ATerm)chain.getNext(), (ATerm)c);
            for (int e = 0; e < edges.size(); ++e) {
                Edge edgeToY = edges.edgeAt(e);
                Node y = edgeToY.getNeighbor(x);
                DependencySet finalDS = ds.union(edgeToY.getDepends(), this.strategy.getABox().doExplanation());
                this.applyAllValues(x, r, y, allRC, finalDS);
                if (!x.isMerged() && !this.strategy.getABox().isClosed()) continue;
                return false;
            }
        }
        return true;
    }

    protected void applyAllValues(Individual subj, Role pred, Node obj, ATermAppl c, DependencySet ds) {
        if (!obj.hasType((ATerm)c)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("ALL : " + subj + " -> " + pred + " -> " + obj + " : " + ATermUtils.toString(c) + " - " + ds);
            }
            if (PelletOptions.USE_COMPLETION_QUEUE && !PelletOptions.MAINTAIN_COMPLETION_QUEUE && obj.isPruned()) {
                return;
            }
            this.strategy.addType(obj, c, ds);
        }
    }

    public void applyAllValues(Individual subj, Role pred, Node obj, DependencySet ds) {
        List<ATermAppl> allValues = subj.getTypes(3);
        int allValuesSize = allValues.size();
        Iterator<ATermAppl> i = allValues.iterator();
        while (i.hasNext()) {
            DependencySet finalDS;
            ATermAppl av = i.next();
            ATerm p = av.getArgument(0);
            ATermAppl c = (ATermAppl)av.getArgument(1);
            ATermList roleChain = ATermUtils.EMPTY_LIST;
            Role s = null;
            if (p.getType() == 4) {
                roleChain = (ATermList)p;
                s = this.strategy.getABox().getRole(roleChain.getFirst());
                roleChain = roleChain.getNext();
            } else {
                s = this.strategy.getABox().getRole(p);
            }
            if (s.isTop() && s.isObjectRole()) {
                this.applyAllValuesTop(av, c, ds);
                if (!this.strategy.getABox().isClosed()) continue;
                return;
            }
            if (pred.isSubRoleOf(s)) {
                finalDS = subj.getDepends((ATerm)av);
                finalDS = finalDS.union(ds, this.strategy.getABox().doExplanation());
                finalDS = finalDS.union(s.getExplainSubOrInv(pred), this.strategy.getABox().doExplanation());
                if (roleChain.isEmpty()) {
                    this.applyAllValues(subj, s, obj, c, finalDS);
                } else if (obj.isIndividual()) {
                    ATermAppl allRC = ATermUtils.makeAllValues((ATerm)roleChain, (ATerm)c);
                    this.strategy.addType(obj, allRC, finalDS);
                }
                if (this.strategy.getABox().isClosed()) {
                    return;
                }
            }
            if (!s.isSimple()) {
                finalDS = subj.getDepends((ATerm)av).union(ds, this.strategy.getABox().doExplanation());
                Set<ATermList> subRoleChains = s.getSubRoleChains();
                for (ATermList chain : subRoleChains) {
                    Role firstRole = this.strategy.getABox().getRole(chain.getFirst());
                    if (!pred.isSubRoleOf(firstRole)) continue;
                    ATermAppl allRC = ATermUtils.makeAllValues((ATerm)chain.getNext(), (ATerm)c);
                    this.applyAllValues(subj, pred, obj, allRC, finalDS.union(firstRole.getExplainSub((ATerm)pred.getName()), this.strategy.getABox().doExplanation()).union(s.getExplainSub((ATerm)chain), this.strategy.getABox().doExplanation()));
                    if (!subj.isMerged() && !this.strategy.getABox().isClosed()) continue;
                    return;
                }
            }
            if (subj.isMerged()) {
                return;
            }
            obj = obj.getSame();
            if (allValuesSize == allValues.size()) continue;
            i = allValues.iterator();
            allValuesSize = allValues.size();
        }
    }

    void applyAllValuesTop(ATermAppl allTopC, ATermAppl c, DependencySet ds) {
        for (Node node : this.strategy.getABox().getNodes()) {
            if (!node.isIndividual() || node.isPruned() || node.hasType((ATerm)c)) continue;
            node.addType(c, ds);
            node.addType(allTopC, ds);
            if (!this.strategy.getABox().isClosed()) continue;
            break;
        }
    }
}

