/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy.printer;

import aterm.ATermAppl;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.printer.TaxonomyPrinter;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.TaxonomyUtils;

public class RDFXMLTaxonomyPrinter
implements TaxonomyPrinter<ATermAppl> {
    static final String OWL_EQUIVALENT_CLASS = "owl:equivalentClass";
    static final String RDFS_SUB_CLASS_OF = "rdfs:subClassOf";
    static final String RDF_TYPE = "rdf:type";
    protected boolean onlyDirectSubclass = true;
    private Taxonomy<ATermAppl> taxonomy;
    private PrintWriter out;
    private Set<ATermAppl> visited;

    @Override
    public void print(Taxonomy<ATermAppl> taxonomy) {
        this.print(taxonomy, new PrintWriter(System.out));
    }

    @Override
    public void print(Taxonomy<ATermAppl> taxonomy, PrintWriter out) {
        this.taxonomy = taxonomy;
        this.out = out;
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println();
        out.println("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" ");
        out.println("         xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" ");
        out.println("         xmlns:owl=\"http://www.w3.org/2002/07/owl#\"> ");
        out.println();
        this.printTree();
        out.println();
        out.println("</rdf:RDF>");
        out.flush();
    }

    protected void printTree() {
        this.visited = new HashSet<ATermAppl>();
        this.visited.add(ATermUtils.BOTTOM);
        this.printTree(ATermUtils.TOP);
        this.printTree(ATermUtils.BOTTOM);
        for (ATermAppl c : this.taxonomy.getClasses()) {
            this.printTree(c);
        }
    }

    protected void printTree(ATermAppl c) {
        if (this.visited.contains(c)) {
            return;
        }
        Set<ATermAppl> eqClasses = ATermUtils.primitiveOrBottom(this.taxonomy.getEquivalents(c));
        this.visited.add(c);
        this.visited.addAll(eqClasses);
        this.printConceptDefinition(c, false);
        for (ATermAppl aTermAppl : eqClasses) {
            this.printTriple(OWL_EQUIVALENT_CLASS, aTermAppl);
        }
        if (!c.equals(ATermUtils.BOTTOM)) {
            Set<Set<ATermAppl>> supers = this.taxonomy.getSupers(c, this.onlyDirectSubclass);
            Iterator iterator = supers.iterator();
            while (iterator.hasNext()) {
                Set equivalenceSet = (Set)iterator.next();
                ATermAppl subClass = ATermUtils.primitiveOrBottom(equivalenceSet).iterator().next();
                this.printTriple(RDFS_SUB_CLASS_OF, subClass);
            }
        }
        this.out.println("</owl:Class>");
        for (ATermAppl aTermAppl : eqClasses) {
            this.out.println();
            this.printConceptDefinition(aTermAppl, true);
        }
        this.out.println();
        Set<ATermAppl> instances = TaxonomyUtils.getDirectInstances(this.taxonomy, c);
        for (ATermAppl instance : instances) {
            if (ATermUtils.isBnode(instance)) {
                return;
            }
            this.out.print("<rdf:Description rdf:about=\"");
            this.out.print(instance.getName());
            this.out.println("\">");
            this.printTriple(RDF_TYPE, c);
            this.out.println("</rdf:Description>");
            this.out.println();
        }
    }

    protected void printTriple(String predicate, ATermAppl c2) {
        this.out.print("   <" + predicate);
        this.out.print(" rdf:resource=\"");
        this.printConcept(c2);
        this.out.println("\"/> ");
    }

    protected void printConceptDefinition(ATermAppl c, boolean close) {
        this.out.print("<owl:Class rdf:about=\"");
        this.printConcept(c);
        if (close) {
            this.out.println("\"/> ");
        } else {
            this.out.println("\"> ");
        }
    }

    protected void printConcept(ATermAppl c) {
        String uri = null;
        uri = c.equals(ATermUtils.TOP) ? "http://www.w3.org/2002/07/owl#Thing" : (c.equals(ATermUtils.BOTTOM) ? "http://www.w3.org/2002/07/owl#Nothing" : c.getName());
        this.out.print(uri);
    }
}

