/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tbox.impl;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import com.clarkparsia.pellet.datatypes.Facet;
import com.clarkparsia.pellet.rules.model.AtomDConstant;
import com.clarkparsia.pellet.rules.model.AtomDObject;
import com.clarkparsia.pellet.rules.model.AtomDVariable;
import com.clarkparsia.pellet.rules.model.AtomIConstant;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.AtomIVariable;
import com.clarkparsia.pellet.rules.model.BuiltInAtom;
import com.clarkparsia.pellet.rules.model.ClassAtom;
import com.clarkparsia.pellet.rules.model.DataRangeAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.Rule;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.tbox.impl.TBoxExpImpl;
import org.mindswap.pellet.tbox.impl.TermDefinition;
import org.mindswap.pellet.tbox.impl.TgBox;
import org.mindswap.pellet.tbox.impl.TuBox;
import org.mindswap.pellet.utils.ATermUtils;

public class RuleAbsorber {
    public static final Logger log = TgBox.log;
    public static final Map<ATermAppl, String> FACETS = new HashMap<ATermAppl, String>();
    private KnowledgeBase kb;
    private TuBox Tu;

    public RuleAbsorber(TBoxExpImpl tbox) {
        this.kb = tbox.getKB();
        this.Tu = tbox.Tu;
    }

    public boolean absorbRule(Set<ATermAppl> set, Set<ATermAppl> explanation) {
        int propertyAtoms = 0;
        int primitiveClassAtoms = 0;
        ATermAppl head = null;
        for (ATermAppl term : set) {
            if (ATermUtils.isPrimitive(term)) {
                TermDefinition td = this.Tu.getTD((ATerm)term);
                if (td != null && !td.getEqClassAxioms().isEmpty()) continue;
                ++primitiveClassAtoms;
                continue;
            }
            if (ATermUtils.isSomeValues(term)) {
                ++propertyAtoms;
                continue;
            }
            if (!ATermUtils.isNot(term)) continue;
            head = term;
        }
        if (head == null || propertyAtoms == 0 && primitiveClassAtoms < 2) {
            return false;
        }
        set.remove(head);
        AtomIVariable var = new AtomIVariable("var");
        int varCount = 0;
        ArrayList<RuleAtom> bodyAtoms = new ArrayList<RuleAtom>();
        for (ATermAppl term : set) {
            varCount = this.processClass(var, term, bodyAtoms, varCount);
        }
        ArrayList<RuleAtom> headAtoms = new ArrayList<RuleAtom>();
        this.processClass(var, ATermUtils.negate(head), headAtoms, 1);
        Rule rule = new Rule(headAtoms, bodyAtoms, explanation);
        this.kb.addRule(rule);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Absorbed rule: " + rule);
        }
        return true;
    }

    protected int processClass(AtomIObject var, ATermAppl c, List<RuleAtom> atoms, int varCount) {
        AFun afun = c.getAFun();
        if (afun.equals(ATermUtils.ANDFUN)) {
            ATermList list = (ATermList)c.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conjunct = (ATermAppl)list.getFirst();
                varCount = this.processClass(var, conjunct, atoms, varCount);
                list = list.getNext();
            }
        } else if (afun.equals(ATermUtils.SOMEFUN)) {
            ATermAppl p = (ATermAppl)c.getArgument(0);
            ATermAppl filler = (ATermAppl)c.getArgument(1);
            if (filler.getAFun().equals(ATermUtils.VALUEFUN)) {
                ATermAppl nominal = (ATermAppl)filler.getArgument(0);
                if (this.kb.isDatatypeProperty((ATerm)p)) {
                    AtomDConstant arg = new AtomDConstant(nominal);
                    DatavaluedPropertyAtom atom = new DatavaluedPropertyAtom(p, var, arg);
                    atoms.add(atom);
                } else {
                    AtomIConstant arg = new AtomIConstant(nominal);
                    IndividualPropertyAtom atom = new IndividualPropertyAtom(p, var, arg);
                    atoms.add(atom);
                }
            } else {
                ++varCount;
                if (this.kb.isDatatypeProperty((ATerm)p)) {
                    AtomDVariable newVar = new AtomDVariable("var" + varCount);
                    DatavaluedPropertyAtom atom = new DatavaluedPropertyAtom(p, var, newVar);
                    atoms.add(atom);
                    this.processDatatype(newVar, filler, atoms);
                } else {
                    AtomIVariable newVar = new AtomIVariable("var" + varCount);
                    IndividualPropertyAtom atom = new IndividualPropertyAtom(p, var, newVar);
                    atoms.add(atom);
                    varCount = this.processClass(newVar, filler, atoms, varCount);
                }
            }
        } else if (!c.equals(ATermUtils.TOP)) {
            atoms.add(new ClassAtom(c, var));
        }
        return varCount;
    }

    protected void processDatatype(AtomDObject var, ATermAppl c, List<RuleAtom> atoms) {
        AFun afun = c.getAFun();
        if (afun.equals(ATermUtils.ANDFUN)) {
            ATermList list = (ATermList)c.getArgument(0);
            while (!list.isEmpty()) {
                ATermAppl conjunct = (ATermAppl)list.getFirst();
                this.processDatatype(var, conjunct, atoms);
                list = list.getNext();
            }
        } else if (afun.equals(ATermUtils.RESTRDATATYPEFUN)) {
            ATermAppl baseDatatype = (ATermAppl)c.getArgument(0);
            atoms.add(new DataRangeAtom(baseDatatype, var));
            ATermList list = (ATermList)c.getArgument(1);
            while (!list.isEmpty()) {
                ATermAppl facetRestriction = (ATermAppl)list.getFirst();
                ATermAppl facet = (ATermAppl)facetRestriction.getArgument(0);
                String builtin = FACETS.get(facet);
                if (builtin == null) {
                    atoms.add(new DataRangeAtom(c, var));
                    return;
                }
                ATermAppl value = (ATermAppl)facetRestriction.getArgument(1);
                atoms.add(new BuiltInAtom(builtin, var, new AtomDConstant(value)));
                list = list.getNext();
            }
        } else {
            atoms.add(new DataRangeAtom(c, var));
        }
    }

    static {
        FACETS.put(Facet.XSD.MIN_INCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#greaterThanOrEqual");
        FACETS.put(Facet.XSD.MIN_EXCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#greaterThan");
        FACETS.put(Facet.XSD.MAX_INCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#lessThanOrEqual");
        FACETS.put(Facet.XSD.MAX_EXCLUSIVE.getName(), "http://www.w3.org/2003/11/swrlb#lessThan");
    }
}

