/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.el;

import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.CollectionUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.MultiValueMap;

public class GenericTaxonomyBuilder {
    private Taxonomy<ATermAppl> taxonomy;
    private MultiValueMap<ATermAppl, ATermAppl> subsumers;

    public Taxonomy<ATermAppl> build(MultiValueMap<ATermAppl, ATermAppl> subsumers) {
        this.subsumers = subsumers;
        this.taxonomy = new Taxonomy<ATermAppl>(null, ATermUtils.TOP, ATermUtils.BOTTOM);
        for (ATermAppl aTermAppl : (Set)subsumers.get(ATermUtils.TOP)) {
            if (!ATermUtils.isPrimitive(aTermAppl)) continue;
            this.taxonomy.addEquivalentNode(aTermAppl, this.taxonomy.getTop());
        }
        for (Map.Entry entry : subsumers.entrySet()) {
            ATermAppl c = (ATermAppl)entry.getKey();
            if (!ATermUtils.isPrimitive(c)) continue;
            if (((Set)entry.getValue()).contains(ATermUtils.BOTTOM)) {
                this.taxonomy.addEquivalentNode(c, this.taxonomy.getBottom());
                continue;
            }
            this.add(c);
        }
        return this.taxonomy;
    }

    private TaxonomyNode<ATermAppl> add(ATermAppl c) {
        TaxonomyNode<ATermAppl> node = this.taxonomy.getNode(c);
        if (node == null) {
            Set<ATermAppl> equivalents = CollectionUtils.makeSet();
            Set<TaxonomyNode<ATermAppl>> subsumerNodes = CollectionUtils.makeSet();
            for (ATermAppl subsumer : (Set)this.subsumers.get(c)) {
                if (c.equals(subsumer) || !ATermUtils.isPrimitive(subsumer)) continue;
                if (((Set)this.subsumers.get(subsumer)).contains(c)) {
                    equivalents.add(subsumer);
                    continue;
                }
                TaxonomyNode<ATermAppl> supNode = this.add(subsumer);
                subsumerNodes.add(supNode);
            }
            node = this.add(c, subsumerNodes);
            for (ATermAppl eq : equivalents) {
                this.taxonomy.addEquivalentNode(eq, node);
            }
        }
        return node;
    }

    private TaxonomyNode<ATermAppl> add(ATermAppl c, Set<TaxonomyNode<ATermAppl>> subsumers) {
        Set<TaxonomyNode<ATermAppl>> parents = CollectionUtils.makeSet(subsumers);
        Set supers = CollectionUtils.makeSet();
        Set<ATermAppl> subs = Collections.singleton(ATermUtils.BOTTOM);
        for (TaxonomyNode<ATermAppl> subsumer : subsumers) {
            parents.removeAll(subsumer.getSupers());
        }
        for (TaxonomyNode<ATermAppl> parent : parents) {
            supers.add(parent.getName());
            parent.removeSub(this.taxonomy.getBottom());
        }
        return this.taxonomy.addNode(Collections.singleton(c), supers, subs, false);
    }
}

