/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.rete.BetaNode;
import com.clarkparsia.pellet.rules.rete.NodeProvider;
import com.clarkparsia.pellet.rules.rete.Token;
import com.clarkparsia.pellet.rules.rete.WME;
import java.util.Arrays;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.utils.ATermUtils;

public class BetaBuiltinNode
extends BetaNode {
    private final ABox abox;
    private final String name;
    private final BuiltIn builtin;
    private final NodeProvider[] args;

    public BetaBuiltinNode(ABox abox, String name, BuiltIn builtin, NodeProvider[] args) {
        this.abox = abox;
        this.name = name;
        this.builtin = builtin;
        this.args = args;
    }

    @Override
    public void activate(WME wme) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void activate(Token token) {
        Literal[] literals = new Literal[this.args.length];
        for (int i = 0; i < literals.length; ++i) {
            literals[i] = this.args[i] == null ? null : (Literal)this.args[i].getNode(null, token);
        }
        if (this.builtin.apply(this.abox, literals)) {
            this.activateChildren(WME.createBuiltin(literals, DependencySet.INDEPENDENT), token);
        }
    }

    @Override
    public void print(String indent) {
        indent = indent + "  ";
        System.out.print(indent);
        System.out.println(this);
        for (BetaNode node : this.getBetas()) {
            node.print(indent);
        }
    }

    public String toString() {
        return "Builtin " + ATermUtils.toString(ATermUtils.makeTermAppl(this.name)) + Arrays.toString(this.args);
    }
}

