/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import com.clarkparsia.pellet.rules.rete.BetaNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

public abstract class ReteNode {
    public static final Logger log = Logger.getLogger(ReteNode.class.getName());
    private List<BetaNode> children = new ArrayList<BetaNode>();
    private boolean marked = false;

    public void addChild(BetaNode beta) {
        this.children.add(beta);
    }

    public Collection<BetaNode> getBetas() {
        return this.children;
    }

    public void reset() {
        for (BetaNode child : this.children) {
            child.reset();
        }
    }

    public void restore(int branch) {
        for (BetaNode child : this.children) {
            child.restore(branch);
        }
    }

    public void mark() {
        this.setMark(true);
    }

    public void unmark() {
        this.setMark(false);
    }

    private void setMark(boolean value) {
        this.marked = value;
        for (ReteNode reteNode : this.children) {
            reteNode.setMark(value);
        }
    }

    public void print(String indent) {
        System.out.print(indent);
        System.out.println(this);
    }
}

