/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils.progress;

import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.mindswap.pellet.utils.progress.AbstractProgressMonitor;

public class SwingProgressMonitor
extends AbstractProgressMonitor {
    private ProgressMonitor monitor = null;

    public SwingProgressMonitor() {
    }

    public SwingProgressMonitor(int length) {
        super(length);
    }

    @Override
    public boolean isCanceled() {
        return this.monitor.isCanceled();
    }

    @Override
    protected void resetProgress() {
        super.resetProgress();
        this.monitor = new ProgressMonitor(null, this.progressTitle, this.progressMessage, 0, this.progressLength);
        this.monitor.setProgress(this.progress);
    }

    @Override
    public void setProgressMessage(String progressMessage) {
        super.setProgressMessage(progressMessage);
        this.monitor.setNote(progressMessage);
    }

    @Override
    public void taskFinished() {
        super.taskFinished();
        this.monitor.close();
    }

    @Override
    protected void updateProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingProgressMonitor.this.monitor.setProgress(SwingProgressMonitor.this.progress);
            }
        });
    }
}

