/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.reachability;

import com.clarkparsia.reachability.EntityNode;
import com.clarkparsia.reachability.Node;
import com.clarkparsia.reachability.ReachabilityGraph;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Reachability<E> {
    public static final Logger log = Logger.getLogger(Reachability.class.getName());
    private ReachabilityGraph<E> graph;
    private Set<E> activatedEntities;
    private Set<Node> affectedNodes;
    private Queue<Node> waitingQueue;

    public Reachability(ReachabilityGraph<E> graph) {
        this.graph = graph;
    }

    public ReachabilityGraph<E> getGraph() {
        return this.graph;
    }

    private void reset() {
        this.activatedEntities = new HashSet();
        this.affectedNodes = new HashSet<Node>();
        this.waitingQueue = new LinkedList<Node>();
        this.waitingQueue.add(this.graph.getStartNode());
    }

    private void activateNode(EntityNode<E> node) {
        if (node.isActive()) {
            throw new IllegalStateException();
        }
        this.affectedNodes.add(node);
        this.activatedEntities.addAll(node.getEntities());
        this.waitingQueue.add(node);
        node.inputActivated();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Activated: " + node);
        }
    }

    public boolean contains(E entity) {
        return this.graph.getNode(entity) != null;
    }

    public Set<E> computeReachable(Iterable<E> initialEntities) {
        this.reset();
        for (Object initialEntity : initialEntities) {
            EntityNode<E> initialNode = this.graph.getNode(initialEntity);
            if (initialNode == null) {
                throw new IllegalArgumentException("Unknown entity: " + initialEntity);
            }
            if (initialNode.isActive()) continue;
            this.activateNode(initialNode);
        }
        while (!this.waitingQueue.isEmpty()) {
            Node node = this.waitingQueue.poll();
            assert (node.isActive());
            for (Node outputNode : node.getOutputs()) {
                if (outputNode.isActive()) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Already activated: " + outputNode);
                    continue;
                }
                this.affectedNodes.add(outputNode);
                if (!outputNode.inputActivated()) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Activated: " + outputNode);
                }
                this.waitingQueue.add(outputNode);
                if (!(outputNode instanceof EntityNode)) continue;
                this.activatedEntities.addAll(this.entityNode(outputNode).getEntities());
            }
        }
        for (Node node : this.affectedNodes) {
            node.reset();
        }
        return this.activatedEntities;
    }

    private EntityNode<E> entityNode(Node node) {
        return (EntityNode)node;
    }
}

