/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.ChangeTypeDetector;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.io.ModuleExtractorPersistence;
import com.clarkparsia.modularity.io.UncloseableOutputStream;
import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.LocalityEvaluator;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellet.expressivity.Expressivity;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

public abstract class AbstractModuleExtractor
implements ModuleExtractor {
    public static final Logger log = Logger.getLogger(AbstractModuleExtractor.class.getName());
    private Set<OWLAxiom> additions = new HashSet<OWLAxiom>();
    private Set<OWLClass> newClasses = new HashSet<OWLClass>();
    private Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();
    private Set<OWLAxiom> deletions = new HashSet<OWLAxiom>();
    protected EnumSet<KnowledgeBase.ChangeType> changes = EnumSet.noneOf(KnowledgeBase.ChangeType.class);
    protected MultiValueMap<OWLEntity, OWLAxiom> entityAxioms = new MultiValueMap();
    private LocalityEvaluator localityEvaluator = null;
    protected MultiValueMap<OWLEntity, OWLEntity> modules = null;
    private boolean nonLocalAxioms = false;
    private Timers timers = new Timers();
    private static final String MODULE_EXTRACTOR_AXIOMS_FILE_NAME = "ModuleExtractorAxioms";
    private static final String MODULE_EXTRACTOR_MODULES_FILE_NAME = "ModuleExtractorModules";

    public AbstractModuleExtractor() {
        this((LocalityEvaluator)new SyntacticLocalityEvaluator(LocalityClass.BOTTOM_BOTTOM));
    }

    public AbstractModuleExtractor(LocalityEvaluator localityEvaluator) {
        this.localityEvaluator = localityEvaluator;
    }

    @Override
    public void addAxiom(OWLAxiom axiom) {
        this.checkNonLocalAxiom(axiom);
        if (this.axioms.contains(axiom)) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding " + axiom);
        }
        this.deletions.remove(axiom);
        this.additions.add(axiom);
        this.categorizeAddedAxiom(axiom);
    }

    @Override
    public boolean canUpdate() {
        return this.modules != null && !this.nonLocalAxioms;
    }

    private void checkNonLocalAxiom(OWLAxiom axiom) {
        if (!axiom.isLogicalAxiom()) {
            return;
        }
        if (this.canUpdate() && !this.isLocal(axiom, Collections.<OWLEntity>emptySet())) {
            log.warning("*** Non-local axiom: " + axiom);
            this.nonLocalAxioms = true;
        }
    }

    @Override
    public void deleteAxiom(OWLAxiom axiom) {
        this.checkNonLocalAxiom(axiom);
        if (!this.axioms.contains(axiom)) {
            if (this.additions.remove(axiom) && log.isLoggable(Level.FINE)) {
                log.fine("Deleted axiom from add queue before processing " + axiom);
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Deleting " + axiom);
        }
        this.additions.remove(axiom);
        this.deletions.add(axiom);
        this.categorizeRemovedAxiom(axiom);
    }

    @Override
    public MultiValueMap<OWLEntity, OWLEntity> getModules() {
        return this.modules;
    }

    @Override
    public MultiValueMap<OWLEntity, OWLEntity> extractModules() {
        Timer timer = this.timers.startTimer("extractModules");
        this.processAdditions();
        this.additions.clear();
        this.deletions.clear();
        this.changes.clear();
        this.nonLocalAxioms = false;
        this.modules = new MultiValueMap();
        this.extractModuleSignatures(this.entityAxioms.keySet());
        timer.stop();
        return this.modules;
    }

    private void extractModuleSignatures(Set<? extends OWLEntity> entities) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Extracting module for each of " + entities);
        }
        if (entities.isEmpty()) {
            return;
        }
        ConsoleProgressMonitor monitor = new ConsoleProgressMonitor();
        monitor.setProgressTitle("Extracting");
        monitor.setProgressLength(entities.size());
        monitor.taskStarted();
        this.extractModuleSignatures(entities, (ProgressMonitor)monitor);
        monitor.taskFinished();
        if (log.isLoggable(Level.FINER)) {
            log.finer("Modules: " + this.modules);
        }
    }

    protected abstract void extractModuleSignatures(Set<? extends OWLEntity> var1, ProgressMonitor var2);

    private Set<OWLEntity> getAffectedRoots(OWLAxiom axiom, Taxonomy<OWLClass> taxonomy, boolean add) {
        HashSet<OWLEntity> roots = new HashSet<OWLEntity>();
        HashSet<TaxonomyNode<OWLClass>> visited = new HashSet<TaxonomyNode<OWLClass>>();
        visited.add(taxonomy.getBottom());
        this.getAffectedRoots(axiom, (TaxonomyNode<OWLClass>)taxonomy.getTop(), roots, add, visited);
        if (!add && roots.isEmpty()) {
            for (OWLClass unsat : taxonomy.getEquivalents((Object)OWL.Nothing)) {
                Set signature = (Set)this.modules.get((Object)unsat);
                if (signature == null || !signature.containsAll(this.getSignature(axiom))) continue;
                roots.add((OWLEntity)unsat);
            }
        }
        return roots;
    }

    private void getAffectedRoots(OWLAxiom axiom, TaxonomyNode<OWLClass> node, Set<OWLEntity> effects, boolean add, Set<TaxonomyNode<OWLClass>> visited) {
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        OWLEntity entity = (OWLEntity)node.getName();
        Set signature = (Set)this.modules.get((Object)entity);
        boolean outdated = false;
        if (signature == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Removed entity " + entity);
            }
        } else {
            outdated = add ? !this.isLocal(axiom, signature) : signature.containsAll(this.getSignature(axiom));
        }
        if (outdated) {
            effects.addAll(node.getEquivalents());
        } else {
            for (TaxonomyNode next : node.getSubs()) {
                this.getAffectedRoots(axiom, (TaxonomyNode<OWLClass>)next, effects, add, visited);
            }
        }
    }

    @Override
    public Set<OWLAxiom> getAxioms(OWLEntity entity) {
        Set<OWLAxiom> axioms = (Set<OWLAxiom>)this.entityAxioms.get((Object)entity);
        if (axioms == null) {
            axioms = Collections.emptySet();
        }
        return axioms;
    }

    @Override
    public OWLOntology getModule(OWLEntity entity) {
        return this.getModuleFromSignature((Set)this.modules.get((Object)entity));
    }

    protected Set<OWLAxiom> getModuleAxioms(Set<OWLEntity> signature) {
        HashSet referenced = new HashSet();
        HashSet<OWLEntity> augmentedSig = new HashSet<OWLEntity>(signature);
        augmentedSig.add((OWLEntity)OWL.Thing);
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> candidates = new HashSet<OWLAxiom>();
        for (OWLEntity e : signature) {
            candidates.addAll(this.getAxioms(e));
        }
        for (OWLAxiom axiom : candidates) {
            Set sigAxiom = axiom.getSignature();
            if (!augmentedSig.containsAll(sigAxiom) || this.isLocal(axiom, signature)) continue;
            axioms.add(axiom);
            referenced.addAll(sigAxiom);
        }
        HashSet<OWLEntity> notReferenced = new HashSet<OWLEntity>(signature);
        notReferenced.removeAll(referenced);
        for (OWLEntity e : notReferenced) {
            if (this.entityAxioms.get((Object)e) == null) continue;
            axioms.add((OWLAxiom)OWL.declaration((OWLEntity)e));
        }
        return axioms;
    }

    @Override
    public OWLOntology getModuleFromSignature(Set<OWLEntity> signature) {
        Set<OWLAxiom> moduleAxioms = this.getModuleAxioms(signature);
        return OWL.Ontology(moduleAxioms);
    }

    protected Set<OWLEntity> getSignature(OWLAxiom axiom) {
        return axiom.getSignature();
    }

    @Override
    public boolean isChanged() {
        return !this.additions.isEmpty() || !this.deletions.isEmpty() || this.nonLocalAxioms;
    }

    protected boolean isLocal(OWLAxiom axiom, Set<OWLEntity> signature) {
        return this.localityEvaluator.isLocal(axiom, signature);
    }

    @Override
    public void addAxioms(Iterable<OWLAxiom> axioms) {
        for (OWLAxiom axiom : axioms) {
            this.addAxiom(axiom);
        }
    }

    private void processAdditions() {
        for (OWLAxiom axiom : this.additions) {
            this.axioms.add(axiom);
            for (OWLEntity entity : axiom.getSignature()) {
                this.entityAxioms.add((Object)entity, (Object)axiom);
                if (!(entity instanceof OWLClass)) continue;
                OWLClass cls = (OWLClass)entity;
                if (this.modules == null || this.modules.containsKey((Object)cls)) continue;
                this.newClasses.add(cls);
            }
        }
    }

    private void processDeletions() {
        for (OWLAxiom axiom : this.deletions) {
            this.axioms.remove(axiom);
            for (OWLEntity entity : axiom.getSignature()) {
                this.entityAxioms.remove((Object)entity, (Object)axiom);
                if (this.entityAxioms.containsKey((Object)entity)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Remove " + entity + " which is not mentioned anymore");
                }
                this.modules.remove((Object)entity);
            }
        }
    }

    private void updateEffectedModules(Set<OWLEntity> effects, Taxonomy<OWLClass> taxonomy, boolean add) {
        HashSet<Object> affectedRoots = new HashSet<Object>();
        HashSet<OWLEntity> affected = new HashSet<OWLEntity>();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Update modules for " + (add ? "additions" : "deletions"));
        }
        affectedRoots.addAll(this.newClasses);
        Set<OWLAxiom> axioms = add ? this.additions : this.deletions;
        for (OWLAxiom oWLAxiom : axioms) {
            affectedRoots.addAll(this.getAffectedRoots(oWLAxiom, taxonomy, add));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Affected roots " + affectedRoots);
        }
        for (OWLEntity oWLEntity : affectedRoots) {
            affected.add(oWLEntity);
            if (!(oWLEntity instanceof OWLClass) || !taxonomy.contains((Object)((OWLClass)oWLEntity))) continue;
            affected.addAll(taxonomy.getFlattenedSubs((Object)((OWLClass)oWLEntity), false));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Affected entities " + affected);
        }
        for (OWLEntity oWLEntity : affected) {
            this.modules.remove((Object)oWLEntity);
        }
        this.extractModuleSignatures(affected);
        for (OWLEntity oWLEntity : affected) {
            Set module = (Set)this.modules.get((Object)oWLEntity);
            if (module == null) {
                String msg = "No module for " + oWLEntity;
                log.log(Level.SEVERE, msg, new RuntimeException(msg));
            }
            effects.addAll(module);
        }
    }

    @Override
    public Set<OWLEntity> applyChanges(Taxonomy<OWLClass> taxonomy) throws UnsupportedOperationException {
        Timer timer = this.timers.startTimer("updateModules");
        if (!this.canUpdate()) {
            throw new UnsupportedOperationException("Modules cannot be updated!");
        }
        HashSet<OWLEntity> effects = new HashSet<OWLEntity>();
        this.processAdditions();
        this.updateEffectedModules(effects, taxonomy, true);
        this.updateEffectedModules(effects, taxonomy, false);
        this.processDeletions();
        this.additions.clear();
        this.deletions.clear();
        this.changes.clear();
        this.newClasses.clear();
        timer.stop();
        return effects;
    }

    @Override
    public Timers getTimers() {
        return this.timers;
    }

    @Override
    public Set<OWLAxiom> getAxioms() {
        return Collections.unmodifiableSet(this.axioms);
    }

    @Override
    public Set<OWLEntity> getEntities() {
        return Collections.unmodifiableSet(this.entityAxioms.keySet());
    }

    public void resetModules() {
        this.processAdditions();
        this.additions.clear();
        this.deletions.clear();
        this.changes.clear();
        this.nonLocalAxioms = false;
        this.modules = new MultiValueMap();
    }

    @Override
    public boolean isClassificationNeeded(Expressivity expressivity) {
        return this.isTBoxChanged() || this.isRBoxChanged() || expressivity.hasNominal() && !PelletOptions.USE_PSEUDO_NOMINALS;
    }

    public boolean isTBoxChanged() {
        return this.changes.contains(KnowledgeBase.ChangeType.TBOX_ADD) || this.changes.contains(KnowledgeBase.ChangeType.TBOX_DEL);
    }

    public boolean isRBoxChanged() {
        return this.changes.contains(KnowledgeBase.ChangeType.RBOX_ADD) || this.changes.contains(KnowledgeBase.ChangeType.RBOX_DEL);
    }

    public boolean isABoxChanged() {
        return this.changes.contains(KnowledgeBase.ChangeType.ABOX_ADD) || this.changes.contains(KnowledgeBase.ChangeType.ABOX_DEL);
    }

    private void categorizeAddedAxiom(OWLAxiom axiom) {
        if (ChangeTypeDetector.isTBoxAxiom(axiom)) {
            this.changes.add(KnowledgeBase.ChangeType.TBOX_ADD);
        } else if (ChangeTypeDetector.isRBoxAxiom(axiom)) {
            this.changes.add(KnowledgeBase.ChangeType.RBOX_ADD);
        } else if (ChangeTypeDetector.isABoxAxiom(axiom)) {
            this.changes.add(KnowledgeBase.ChangeType.ABOX_ADD);
        }
    }

    private void categorizeRemovedAxiom(OWLAxiom axiom) {
        if (ChangeTypeDetector.isTBoxAxiom(axiom)) {
            this.changes.add(KnowledgeBase.ChangeType.TBOX_DEL);
        } else if (ChangeTypeDetector.isRBoxAxiom(axiom)) {
            this.changes.add(KnowledgeBase.ChangeType.RBOX_DEL);
        } else if (ChangeTypeDetector.isABoxAxiom(axiom)) {
            this.changes.add(KnowledgeBase.ChangeType.ABOX_DEL);
        }
    }

    @Override
    public void save(ZipOutputStream outputStream) throws IOException, IllegalStateException {
        if (!this.additions.isEmpty() || !this.deletions.isEmpty()) {
            throw new IllegalStateException("The module extractor contains unapplied changes to the modules, and therefore cannot be saved.");
        }
        ZipEntry axiomsEntry = new ZipEntry(MODULE_EXTRACTOR_AXIOMS_FILE_NAME);
        outputStream.putNextEntry(axiomsEntry);
        ModuleExtractorPersistence.saveAxioms(this.axioms, new UncloseableOutputStream(outputStream));
        ZipEntry modulesEntry = new ZipEntry(MODULE_EXTRACTOR_MODULES_FILE_NAME);
        outputStream.putNextEntry(modulesEntry);
        ModuleExtractorPersistence.saveModules(this.modules, new UncloseableOutputStream(outputStream));
        outputStream.flush();
    }

    @Override
    public void load(ZipInputStream inputStream) throws IOException, IllegalArgumentException {
        this.resetModules();
        ZipEntry zipEntry = inputStream.getNextEntry();
        if (!MODULE_EXTRACTOR_AXIOMS_FILE_NAME.equals(zipEntry.getName())) {
            throw new IllegalArgumentException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", zipEntry.getName(), MODULE_EXTRACTOR_AXIOMS_FILE_NAME));
        }
        OWLOntology axiomOntology = ModuleExtractorPersistence.loadAxiomOntology(inputStream);
        Set axioms = axiomOntology.getAxioms();
        this.additions.addAll(axioms);
        this.processAdditions();
        this.additions.clear();
        zipEntry = inputStream.getNextEntry();
        if (!MODULE_EXTRACTOR_MODULES_FILE_NAME.equals(zipEntry.getName())) {
            throw new IllegalArgumentException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", zipEntry.getName(), MODULE_EXTRACTOR_MODULES_FILE_NAME));
        }
        this.modules = ModuleExtractorPersistence.loadModules(inputStream);
    }
}

