/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.reachability.EntityNode;
import com.clarkparsia.reachability.Node;
import com.clarkparsia.reachability.ReachabilityGraph;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class GraphBuilder {
    public static final Logger log = Logger.getLogger(GraphBuilder.class.getName());
    private ReachabilityGraph graph = new ReachabilityGraph();
    private AxiomVisitor axiomVisitor = new AxiomVisitor();
    private BottomEvaluator bottomEvaluator = new BottomEvaluator();
    private TopEvaluator topEvaluator = new TopEvaluator();
    private final Node NULL_NODE = this.graph.getNullNode();
    private final Node START_NODE = this.graph.getStartNode();

    public void addAxiom(OWLAxiom axiom) {
        axiom.accept((OWLAxiomVisitor)this.axiomVisitor);
    }

    private void addOutputs(Node node, OWLAxiom axiom) {
        if (node.equals(this.NULL_NODE)) {
            return;
        }
        Set entities = OntologyUtils.getSignature((OWLAxiom)axiom);
        for (OWLEntity entity : entities) {
            EntityNode outNode = this.graph.createEntityNode(entity);
            node.addOutput(outNode);
        }
    }

    private void addOutputs(OWLAxiom axiom) {
        Set signature = OntologyUtils.getSignature((OWLAxiom)axiom);
        OWLEntity[] entities = signature.toArray(new OWLEntity[signature.size()]);
        int n = entities.length;
        for (int i = 0; i < n - 1; ++i) {
            EntityNode n1 = this.graph.createEntityNode(entities[i]);
            for (int j = i + 1; j < n; ++j) {
                EntityNode n2 = this.graph.createEntityNode(entities[j]);
                n1.addOutput(n2);
                n2.addOutput(n1);
            }
        }
    }

    public ReachabilityGraph build() {
        this.graph.simplify();
        return this.graph;
    }

    private class TopEvaluator
    implements OWLClassExpressionVisitor {
        private Node node;

        public Node evaluate(OWLClassExpression desc) {
            this.node = null;
            desc.accept((OWLClassExpressionVisitor)this);
            if (this.node == null) {
                throw new IllegalStateException("Evaluation returned null");
            }
            return this.node;
        }

        public void visit(OWLClass desc) {
            this.node = desc.equals(OWL.Thing) ? GraphBuilder.this.NULL_NODE : GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataAllValuesFrom desc) {
            this.node = GraphBuilder.this.graph.createEntityNode(desc.getProperty().asOWLDataProperty());
        }

        public void visit(OWLDataExactCardinality desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataMaxCardinality desc) {
            this.node = GraphBuilder.this.graph.createEntityNode(desc.getProperty().asOWLDataProperty());
        }

        public void visit(OWLDataMinCardinality desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataSomeValuesFrom desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataHasValue desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectAllValuesFrom desc) {
            HashSet<Node> inputNodes = new HashSet<Node>();
            inputNodes.add(GraphBuilder.this.graph.createEntityNode(desc.getProperty().getNamedProperty()));
            inputNodes.add(this.evaluate((OWLClassExpression)desc.getFiller()));
            this.node = GraphBuilder.this.graph.createAndNode(inputNodes);
        }

        public void visit(OWLObjectComplementOf desc) {
            this.node = GraphBuilder.this.bottomEvaluator.evaluate(desc.getOperand());
        }

        public void visit(OWLObjectExactCardinality desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectIntersectionOf desc) {
            HashSet<Node> inputNodes = new HashSet<Node>();
            for (OWLClassExpression conj : desc.getOperands()) {
                Node conjNode = this.evaluate(conj);
                inputNodes.add(conjNode);
            }
            this.node = GraphBuilder.this.graph.createOrNode(inputNodes);
        }

        public void visit(OWLObjectMaxCardinality desc) {
            this.node = GraphBuilder.this.graph.createEntityNode(desc.getProperty().getNamedProperty());
        }

        public void visit(OWLObjectMinCardinality desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectOneOf desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectHasSelf desc) {
            this.node = GraphBuilder.this.NULL_NODE;
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectUnionOf desc) {
            HashSet<Node> inputNodes = new HashSet<Node>();
            for (OWLClassExpression disj : desc.getOperands()) {
                Node disjNode = this.evaluate(disj);
                inputNodes.add(disjNode);
            }
            if (!inputNodes.isEmpty()) {
                this.node = GraphBuilder.this.graph.createAndNode(inputNodes);
            }
        }

        public void visit(OWLObjectHasValue desc) {
            this.node = GraphBuilder.this.START_NODE;
        }
    }

    private class BottomEvaluator
    implements OWLClassExpressionVisitor {
        private Node node;

        public Node evaluate(OWLClassExpression desc) {
            this.node = null;
            desc.accept((OWLClassExpressionVisitor)this);
            if (this.node == null) {
                throw new IllegalStateException("Evaluation returned null");
            }
            return this.node;
        }

        public void visit(OWLClass desc) {
            this.node = desc.equals(OWL.Nothing) ? GraphBuilder.this.START_NODE : (desc.equals(OWL.Thing) ? GraphBuilder.this.NULL_NODE : GraphBuilder.this.graph.createEntityNode(desc));
        }

        public void visit(OWLDataAllValuesFrom desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataExactCardinality desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataMaxCardinality desc) {
            this.node = desc.getCardinality() == 0 ? GraphBuilder.this.graph.createEntityNode(desc.getProperty().asOWLDataProperty()) : GraphBuilder.this.START_NODE;
        }

        public void visit(OWLDataMinCardinality desc) {
            this.node = GraphBuilder.this.graph.createEntityNode(desc.getProperty().asOWLDataProperty());
        }

        public void visit(OWLDataSomeValuesFrom desc) {
            this.node = GraphBuilder.this.graph.createEntityNode(desc.getProperty().asOWLDataProperty());
        }

        public void visit(OWLDataHasValue desc) {
            this.node = GraphBuilder.this.graph.createEntityNode(desc.getProperty().asOWLDataProperty());
        }

        public void visit(OWLObjectAllValuesFrom desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectComplementOf desc) {
            this.node = GraphBuilder.this.topEvaluator.evaluate(desc.getOperand());
        }

        public void visit(OWLObjectExactCardinality desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectIntersectionOf desc) {
            HashSet<Node> inputNodes = new HashSet<Node>();
            for (OWLClassExpression c : desc.getOperands()) {
                Node conjNode = this.evaluate(c);
                inputNodes.add(conjNode);
            }
            if (!inputNodes.isEmpty()) {
                this.node = GraphBuilder.this.graph.createAndNode(inputNodes);
            }
        }

        public void visit(OWLObjectMaxCardinality desc) {
            this.node = desc.getCardinality() == 0 ? GraphBuilder.this.graph.createEntityNode(desc.getProperty().getNamedProperty()) : GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectMinCardinality desc) {
            this.node = GraphBuilder.this.graph.createEntityNode(desc.getProperty().getNamedProperty());
        }

        public void visit(OWLObjectOneOf desc) {
            this.node = GraphBuilder.this.START_NODE;
        }

        public void visit(OWLObjectHasSelf desc) {
            this.node = GraphBuilder.this.graph.createEntityNode(desc.getProperty().getNamedProperty());
        }

        public void visit(OWLObjectSomeValuesFrom desc) {
            HashSet<Node> inputNodes = new HashSet<Node>();
            inputNodes.add(GraphBuilder.this.graph.createEntityNode(desc.getProperty().getNamedProperty()));
            inputNodes.add(this.evaluate((OWLClassExpression)desc.getFiller()));
            this.node = GraphBuilder.this.graph.createAndNode(inputNodes);
        }

        public void visit(OWLObjectUnionOf desc) {
            HashSet<Node> inputNodes = new HashSet<Node>();
            for (OWLClassExpression disj : desc.getOperands()) {
                Node disjNode = this.evaluate(disj);
                inputNodes.add(disjNode);
            }
            this.node = GraphBuilder.this.graph.createOrNode(inputNodes);
        }

        public void visit(OWLObjectHasValue desc) {
            this.node = GraphBuilder.this.graph.createEntityNode(desc.getProperty().getNamedProperty());
        }
    }

    private class AxiomVisitor
    implements OWLAxiomVisitor {
        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        }

        public void visit(OWLClassAssertionAxiom axiom) {
            if (axiom.getIndividual().isAnonymous()) {
                return;
            }
            Node node = GraphBuilder.this.bottomEvaluator.evaluate(axiom.getClassExpression());
            GraphBuilder.this.addOutputs(node, (OWLAxiom)axiom);
            GraphBuilder.this.addOutputs(GraphBuilder.this.graph.createEntityNode((OWLNamedIndividual)axiom.getIndividual()), (OWLAxiom)axiom);
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
            HashSet<Node> nodes = new HashSet<Node>();
            nodes.add(GraphBuilder.this.graph.createEntityNode(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty()));
            nodes.add(GraphBuilder.this.topEvaluator.evaluate(axiom.getDomain()));
            GraphBuilder.this.addOutputs(GraphBuilder.this.graph.createAndNode(nodes), (OWLAxiom)axiom);
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
            EntityNode subNode = GraphBuilder.this.graph.createEntityNode(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty());
            EntityNode supNode = GraphBuilder.this.graph.createEntityNode(((OWLDataPropertyExpression)axiom.getSuperProperty()).asOWLDataProperty());
            subNode.getOutputs().add(supNode);
        }

        public void visit(OWLDeclarationAxiom axiom) {
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
            this.processDisjoints((OWLAxiom)axiom, axiom.getClassExpressions());
        }

        protected void processDisjoints(OWLAxiom axiom, Set<OWLClassExpression> desc) {
            OWLClassExpression[] descriptions = desc.toArray(new OWLClassExpression[0]);
            HashSet<Node> or = new HashSet<Node>();
            for (int i = 0; i < descriptions.length - 1; ++i) {
                for (int j = i; j < descriptions.length; ++j) {
                    Node n1 = GraphBuilder.this.bottomEvaluator.evaluate(descriptions[i]);
                    Node n2 = GraphBuilder.this.bottomEvaluator.evaluate(descriptions[j]);
                    or.add(GraphBuilder.this.graph.createAndNode(SetUtils.create((Object[])new Node[]{n1, n2})));
                }
            }
            if (!or.isEmpty()) {
                if (or.size() == 1) {
                    GraphBuilder.this.addOutputs((Node)or.iterator().next(), axiom);
                } else {
                    GraphBuilder.this.addOutputs(GraphBuilder.this.graph.createOrNode(or), axiom);
                }
            }
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
            this.processDisjoints((OWLAxiom)axiom, axiom.getClassExpressions());
            this.processEquivalent((OWLAxiom)axiom, (OWLClassExpression)axiom.getOWLClass(), (OWLClassExpression)OWL.or((Set)axiom.getClassExpressions()));
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            Iterator eqs = axiom.getClassExpressions().iterator();
            OWLClassExpression c1 = (OWLClassExpression)eqs.next();
            if (!eqs.hasNext()) {
                return;
            }
            OWLClassExpression c2 = (OWLClassExpression)eqs.next();
            if (eqs.hasNext()) {
                throw new UnsupportedOperationException("OWLEquivalentClassesAxiom with more than 2 elements");
            }
            this.processEquivalent((OWLAxiom)axiom, c1, c2);
        }

        protected void processEquivalent(OWLAxiom axiom, OWLClassExpression c1, OWLClassExpression c2) {
            HashSet<Node> nodes1 = new HashSet<Node>();
            nodes1.add(GraphBuilder.this.topEvaluator.evaluate(c1));
            nodes1.add(GraphBuilder.this.topEvaluator.evaluate(c2));
            HashSet<Node> nodes2 = new HashSet<Node>();
            nodes2.add(GraphBuilder.this.bottomEvaluator.evaluate(c1));
            nodes2.add(GraphBuilder.this.bottomEvaluator.evaluate(c2));
            Node or1 = GraphBuilder.this.graph.createOrNode(nodes1);
            Node or2 = GraphBuilder.this.graph.createOrNode(nodes2);
            Node result = GraphBuilder.this.graph.createAndNode(SetUtils.create((Object[])new Node[]{or1, or2}));
            GraphBuilder.this.addOutputs(result, axiom);
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        }

        public void visit(OWLImportsDeclaration axiom) {
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLHasKeyAxiom theOWLHasKeyAxiom) {
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
            HashSet<Node> nodes = new HashSet<Node>();
            for (OWLObjectPropertyExpression p : axiom.getPropertyChain()) {
                nodes.add(GraphBuilder.this.graph.createEntityNode(p.getNamedProperty()));
            }
            GraphBuilder.this.addOutputs(GraphBuilder.this.graph.createAndNode(nodes), (OWLAxiom)axiom);
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
            HashSet<Node> nodes = new HashSet<Node>();
            nodes.add(GraphBuilder.this.graph.createEntityNode(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty()));
            nodes.add(GraphBuilder.this.topEvaluator.evaluate(axiom.getDomain()));
            GraphBuilder.this.addOutputs(GraphBuilder.this.graph.createAndNode(nodes), (OWLAxiom)axiom);
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
            HashSet<Node> nodes = new HashSet<Node>();
            nodes.add(GraphBuilder.this.graph.createEntityNode(((OWLObjectPropertyExpression)axiom.getProperty()).getNamedProperty()));
            nodes.add(GraphBuilder.this.topEvaluator.evaluate((OWLClassExpression)axiom.getRange()));
            GraphBuilder.this.addOutputs(GraphBuilder.this.graph.createAndNode(nodes), (OWLAxiom)axiom);
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
            EntityNode subNode = GraphBuilder.this.graph.createEntityNode(((OWLObjectPropertyExpression)axiom.getSubProperty()).getNamedProperty());
            EntityNode supNode = GraphBuilder.this.graph.createEntityNode(((OWLObjectPropertyExpression)axiom.getSuperProperty()).getNamedProperty());
            subNode.addOutput(supNode);
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSameIndividualAxiom axiom) {
            GraphBuilder.this.addOutputs((OWLAxiom)axiom);
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            HashSet<Node> nodes = new HashSet<Node>();
            nodes.add(GraphBuilder.this.topEvaluator.evaluate(axiom.getSuperClass()));
            nodes.add(GraphBuilder.this.bottomEvaluator.evaluate(axiom.getSubClass()));
            if (!nodes.isEmpty()) {
                GraphBuilder.this.addOutputs(GraphBuilder.this.graph.createAndNode(nodes), (OWLAxiom)axiom);
            }
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        }

        public void visit(SWRLRule axiom) {
        }
    }
}

