/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.reachability;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class PairSet<T>
extends AbstractSet<T>
implements Set<T> {
    private Set<T> firstSet;
    private Set<T> secondSet;
    private int size;

    public PairSet(Set<T> first, Set<T> second) {
        this.firstSet = first;
        this.secondSet = second;
        this.size = this.computeUnionSize();
    }

    private int computeUnionSize() {
        int size = this.firstSet.size() + this.secondSet.size();
        if (this.firstSet.size() < this.secondSet.size()) {
            for (T e : this.firstSet) {
                if (!this.secondSet.contains(e)) continue;
                --size;
            }
        } else {
            for (T e : this.secondSet) {
                if (!this.firstSet.contains(e)) continue;
                --size;
            }
        }
        return size;
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException("Pair sets are read-only");
    }

    @Override
    public boolean contains(Object o) {
        return this.firstSet.contains(o) || this.secondSet.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return new PairIterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Pair sets are read-only");
    }

    @Override
    public int size() {
        return this.size;
    }

    public class PairIterator
    implements Iterator<T> {
        private Set<T> firstIteratedSet;
        private Iterator<T> firstIterator;
        private Iterator<T> secondIterator;
        private T next;

        public PairIterator() {
            if (PairSet.this.firstSet.size() < PairSet.this.secondSet.size()) {
                this.firstIteratedSet = PairSet.this.firstSet;
                this.firstIterator = PairSet.this.firstSet.iterator();
                this.secondIterator = PairSet.this.secondSet.iterator();
            } else {
                this.firstIteratedSet = PairSet.this.secondSet;
                this.firstIterator = PairSet.this.secondSet.iterator();
                this.secondIterator = PairSet.this.firstSet.iterator();
            }
            this.findNext();
        }

        private void findNext() {
            if (this.firstIterator.hasNext()) {
                this.next = this.firstIterator.next();
            } else {
                this.next = null;
                while (this.secondIterator.hasNext() && this.next == null) {
                    this.next = this.secondIterator.next();
                    if (!this.firstIteratedSet.contains(this.next)) continue;
                    this.next = null;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this.next;
            this.findNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

