/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.reachability;

import com.clarkparsia.reachability.AndNode;
import com.clarkparsia.reachability.EntityNode;
import com.clarkparsia.reachability.Node;
import com.clarkparsia.reachability.ReachabilityGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SCC {
    private SCC() {
    }

    public static <E> List<Set<EntityNode<E>>> computeSCC(ReachabilityGraph<E> graph) {
        return new SCCComputer<E>().computeSCC(graph);
    }

    private static class SCCComputer<E> {
        private List<Set<EntityNode<E>>> stronglyConnectedComponents;
        private int index;
        private ArrayList<NodeInfo> stack;
        private Map<Node, NodeInfo> nodeInfos;

        private SCCComputer() {
        }

        public List<Set<EntityNode<E>>> computeSCC(ReachabilityGraph<E> graph) {
            this.stronglyConnectedComponents = new ArrayList<Set<EntityNode<E>>>();
            this.nodeInfos = new HashMap<Node, NodeInfo>();
            Collection<EntityNode<E>> nodes = graph.getEntityNodes();
            for (Node node : nodes) {
                if (this.nodeInfos.containsKey(node)) continue;
                this.computeSCC(node);
            }
            return this.stronglyConnectedComponents;
        }

        private void computeSCC(Node node) {
            this.index = 0;
            this.stack = new ArrayList();
            NodeInfo nodeInfo = new NodeInfo(node);
            this.visit(nodeInfo);
        }

        private void visit(NodeInfo nodeInfo) {
            this.nodeInfos.put(nodeInfo.node, nodeInfo);
            nodeInfo.index = this.index;
            nodeInfo.lowlink = this.index;
            ++this.index;
            this.stack.add(nodeInfo);
            nodeInfo.onStack = true;
            for (Node out : nodeInfo.node.getOutputs()) {
                if (out instanceof AndNode) continue;
                NodeInfo outInfo = this.nodeInfos.get(out);
                if (outInfo == null) {
                    outInfo = new NodeInfo(out);
                    this.visit(outInfo);
                    nodeInfo.lowlink = Math.min(nodeInfo.lowlink, outInfo.lowlink);
                    continue;
                }
                if (!outInfo.onStack) continue;
                nodeInfo.lowlink = Math.min(nodeInfo.lowlink, outInfo.index);
            }
            if (nodeInfo.lowlink == nodeInfo.index) {
                HashSet<EntityNode> connectedComponent = new HashSet<EntityNode>();
                int i = this.stack.size() - 1;
                NodeInfo info = null;
                while (info != nodeInfo) {
                    info = this.stack.get(i);
                    info.onStack = false;
                    if (info.node instanceof EntityNode) {
                        connectedComponent.add((EntityNode)info.node);
                    }
                    --i;
                }
                if (connectedComponent.size() > 0) {
                    this.stronglyConnectedComponents.add(connectedComponent);
                }
                this.stack.subList(i + 1, this.stack.size()).clear();
            }
        }
    }

    private static class NodeInfo {
        private Node node;
        private int index;
        private int lowlink;
        private boolean onStack;

        private NodeInfo(Node n) {
            this.node = n;
            this.index = -1;
            this.lowlink = -1;
            this.onStack = false;
        }

        public String toString() {
            return this.node.toString();
        }
    }
}

