/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.testrun;

import com.clarkparsia.owlwg.testcase.TestVocabulary;
import com.clarkparsia.owlwg.testrun.ReasoningRun;
import com.clarkparsia.owlwg.testrun.ResultVocabulary;
import com.clarkparsia.owlwg.testrun.SyntaxConstraintRun;
import com.clarkparsia.owlwg.testrun.SyntaxTranslationRun;
import com.clarkparsia.owlwg.testrun.TestRunResult;
import com.clarkparsia.owlwg.testrun.TestRunResultVisitor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class TestRunResultAdapter {
    private static Integer bnodeid = 0;
    private OWLAnonymousIndividual currentIndividual;
    private final OWLDataFactory dataFactory;
    private final RunTypeAdapter runTypeAdapter;

    private static URI mintBNode() {
        Integer n = bnodeid;
        Integer n2 = bnodeid = Integer.valueOf(bnodeid + 1);
        return URI.create(String.format("testrunadapter_%d", bnodeid));
    }

    public TestRunResultAdapter(OWLDataFactory dataFactory) {
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        this.dataFactory = dataFactory;
        this.runTypeAdapter = new RunTypeAdapter();
    }

    public Collection<OWLAxiom> asOWLAxioms(TestRunResult r, OWLAnonymousIndividual i) {
        if (r == null) {
            throw new NullPointerException();
        }
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        this.currentIndividual = i;
        axioms.add((OWLAxiom)this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)ResultVocabulary.Class.TEST_RUN.getOWLClass(), (OWLIndividual)this.currentIndividual));
        axioms.add((OWLAxiom)this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)r.getResultType().getOWLClass(), (OWLIndividual)this.currentIndividual));
        axioms.add((OWLAxiom)this.dataFactory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)ResultVocabulary.ObjectProperty.RUNNER.getOWLObjectProperty(), (OWLIndividual)this.currentIndividual, (OWLIndividual)this.dataFactory.getOWLNamedIndividual(r.getTestRunner().getIRI())));
        OWLAnonymousIndividual testAnonIndividual = this.dataFactory.getOWLAnonymousIndividual(TestRunResultAdapter.mintBNode().toString());
        axioms.add((OWLAxiom)this.dataFactory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)ResultVocabulary.ObjectProperty.TEST.getOWLObjectProperty(), (OWLIndividual)this.currentIndividual, (OWLIndividual)testAnonIndividual));
        axioms.add((OWLAxiom)this.dataFactory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)TestVocabulary.DatatypeProperty.IDENTIFIER.getOWLDataProperty(), (OWLIndividual)testAnonIndividual, this.dataFactory.getOWLLiteral(r.getTestCase().getIdentifier())));
        String details = r.getDetails();
        if (details != null && details.length() > 0) {
            axioms.add((OWLAxiom)this.dataFactory.getOWLAnnotationAssertionAxiom(this.dataFactory.getOWLAnnotationProperty(ResultVocabulary.AnnotationProperty.DETAILS.getAnnotationPropertyIRI()), (OWLAnnotationSubject)i, (OWLAnnotationValue)this.dataFactory.getOWLLiteral(details)));
        }
        axioms.addAll(this.runTypeAdapter.process(r));
        return axioms;
    }

    private class RunTypeAdapter
    implements TestRunResultVisitor {
        private List<OWLAxiom> axioms;

        private RunTypeAdapter() {
        }

        public List<OWLAxiom> process(TestRunResult result) {
            this.axioms = new ArrayList<OWLAxiom>();
            result.accept(this);
            return this.axioms;
        }

        @Override
        public void visit(SyntaxConstraintRun result) {
            this.axioms.add((OWLAxiom)TestRunResultAdapter.this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)result.getTestType().getOWLClass(), (OWLIndividual)TestRunResultAdapter.this.currentIndividual));
            this.axioms.add((OWLAxiom)TestRunResultAdapter.this.dataFactory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)ResultVocabulary.ObjectProperty.SYNTAX_CONSTRAINT.getOWLObjectProperty(), (OWLIndividual)TestRunResultAdapter.this.currentIndividual, result.getConstraint().getOWLIndividual()));
        }

        @Override
        public void visit(ReasoningRun result) {
            this.axioms.add((OWLAxiom)TestRunResultAdapter.this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)result.getTestType().getOWLClass(), (OWLIndividual)TestRunResultAdapter.this.currentIndividual));
        }

        @Override
        public void visit(SyntaxTranslationRun result) {
            this.axioms.add((OWLAxiom)TestRunResultAdapter.this.dataFactory.getOWLClassAssertionAxiom((OWLClassExpression)result.getTestType().getOWLClass(), (OWLIndividual)TestRunResultAdapter.this.currentIndividual));
        }
    }
}

