/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapiv3;

import com.clarkparsia.owlapiv3.OWL;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;

public class OntologyUtils {
    private static OWLOntologyManager manager = OWL.manager;

    public static void addAxioms(OWLOntology ontology, Collection<? extends OWLAxiom> axioms) {
        OntologyUtils.updateOntology(ontology, axioms, true);
    }

    public static void addAxioms(OWLOntology ontology, OWLAxiom ... axioms) {
        OntologyUtils.addAxioms(ontology, Arrays.asList(axioms));
    }

    public static boolean containsClass(Set<Set<OWLClass>> classes, OWLClass cls) {
        for (Set<OWLClass> set : classes) {
            if (!set.contains(cls)) continue;
            return true;
        }
        return false;
    }

    public static Set<OWLEntity> getSignature(OWLAxiom axiom) {
        return axiom.getSignature();
    }

    public static OWLOntologyManager getOWLOntologyManager() {
        return manager;
    }

    public static void clearOWLOntologyManager() {
        for (OWLOntology ont : manager.getOntologies()) {
            manager.removeOntology(ont);
        }
    }

    public static OWLOntology loadOntology(String uri) {
        try {
            return manager.loadOntology(IRI.create((String)uri));
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public static OWLOntology loadOntology(InputStream inputStream) {
        try {
            return manager.loadOntologyFromOntologyDocument(inputStream);
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public static OWLOntology loadOntology(String uri, boolean withAnnotations) {
        OWLOntology ont = OntologyUtils.loadOntology(uri);
        if (!withAnnotations) {
            OntologyUtils.removeAllAnnotations(ont, manager);
        }
        return ont;
    }

    public static OWLOntology loadOntology(InputStream inputStream, boolean withAnnotations) {
        OWLOntology ont = OntologyUtils.loadOntology(inputStream);
        if (!withAnnotations) {
            OntologyUtils.removeAllAnnotations(ont, manager);
        }
        return ont;
    }

    public static void printAxioms(Collection<? extends OWLAxiom> axioms) {
        for (OWLAxiom oWLAxiom : axioms) {
            System.out.println(oWLAxiom);
        }
    }

    public static void printOntology(OWLOntology ont) {
        OntologyUtils.printAxioms(ont.getAxioms());
    }

    public static void removeAxioms(OWLOntology ontology, Collection<? extends OWLAxiom> axioms) {
        OntologyUtils.updateOntology(ontology, axioms, false);
    }

    public static void removeAxioms(OWLOntology ontology, OWLAxiom ... axioms) {
        OntologyUtils.removeAxioms(ontology, Arrays.asList(axioms));
    }

    public static void save(OWLOntology ont, String path) throws OWLOntologyStorageException {
        manager.saveOntology(ont, IRI.create((URI)new File(path).toURI()));
    }

    public static void updateOntology(OWLOntology ontology, Collection<? extends OWLAxiom> axioms, boolean add) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLAxiom oWLAxiom : axioms) {
            AddAxiom change = add ? new AddAxiom(ontology, oWLAxiom) : new RemoveAxiom(ontology, oWLAxiom);
            changes.add(change);
        }
        manager.applyChanges(changes);
    }

    public static boolean containsUnreferencedEntity(OWLOntology ontology, OWLClassExpression desc) {
        for (OWLEntity entity : desc.getSignature()) {
            if (ontology.containsEntityInSignature(entity) || entity instanceof OWLClass && (((OWLClass)entity).isOWLThing() || ((OWLClass)entity).isOWLNothing())) continue;
            return true;
        }
        return false;
    }

    public static Set<OWLOntology> removeAxiom(OWLAxiom axiom, Set<OWLOntology> ontologies, OWLOntologyManager manager) {
        HashSet<OWLOntology> modifiedOnts = new HashSet<OWLOntology>();
        for (OWLOntology ont : ontologies) {
            if (!ont.getAxioms().contains(axiom)) continue;
            modifiedOnts.add(ont);
            manager.applyChange((OWLOntologyChange)new RemoveAxiom(ont, axiom));
        }
        return modifiedOnts;
    }

    public static void addAxiom(OWLAxiom axiom, Set<OWLOntology> ontologies, OWLOntologyManager manager) {
        for (OWLOntology ont : ontologies) {
            manager.applyChange((OWLOntologyChange)new AddAxiom(ont, axiom));
        }
    }

    public static void removeAllAnnotations(OWLOntology ontology, OWLOntologyManager manager) {
        try {
            HashSet referencedEntities = new HashSet();
            referencedEntities.addAll(ontology.getClassesInSignature());
            referencedEntities.addAll(ontology.getObjectPropertiesInSignature());
            referencedEntities.addAll(ontology.getDataPropertiesInSignature());
            referencedEntities.addAll(ontology.getIndividualsInSignature());
            ArrayList<Object> changes = new ArrayList<Object>();
            for (OWLAxiom axiom : ontology.getAxioms()) {
                if (axiom.isLogicalAxiom()) continue;
                changes.add(new RemoveAxiom(ontology, axiom));
            }
            manager.applyChanges(changes);
            changes = new ArrayList();
            for (OWLEntity entity : referencedEntities) {
                if (ontology.containsEntityInSignature(entity)) continue;
                OWLDeclarationAxiom declaration = manager.getOWLDataFactory().getOWLDeclarationAxiom(entity);
                changes.add(new AddAxiom(ontology, (OWLAxiom)declaration));
            }
            manager.applyChanges(changes);
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public static OWLEntity findEntity(String name, Set<OWLOntology> ontologies) {
        OWLOntology ontology;
        OWLEntity entity = null;
        Iterator<OWLOntology> iterator = ontologies.iterator();
        while (iterator.hasNext() && (entity = OntologyUtils.findEntity(name, ontology = iterator.next())) == null) {
        }
        return entity;
    }

    public static OWLEntity findEntity(String name, OWLOntology ontology) {
        OWLClass entity = null;
        if (name.equals("owl:Thing")) {
            entity = OWL.Thing;
        } else if (name.equals("owl:Nothing")) {
            entity = OWL.Nothing;
        } else {
            IRI baseIRI;
            IRI iri = IRI.create((String)name);
            if (iri == null) {
                throw new RuntimeException("Invalid IRI: " + iri);
            }
            if (!iri.isAbsolute() && (baseIRI = (IRI)ontology.getOntologyID().getOntologyIRI().orNull()) != null) {
                iri = baseIRI.resolve("#" + iri);
            }
            if (ontology.containsClassInSignature(iri, Imports.EXCLUDED)) {
                entity = OWL.Class(iri);
            } else if (ontology.containsObjectPropertyInSignature(iri, Imports.EXCLUDED)) {
                entity = OWL.ObjectProperty(iri);
            } else if (ontology.containsDataPropertyInSignature(iri, Imports.EXCLUDED)) {
                entity = OWL.DataProperty(iri);
            } else if (ontology.containsIndividualInSignature(iri, Imports.EXCLUDED)) {
                entity = OWL.Individual(iri).asOWLNamedIndividual();
            }
        }
        return entity;
    }
}

