/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class PelletReasonerFactory
implements OWLReasonerFactory {
    private static final PelletReasonerFactory INSTANCE = new PelletReasonerFactory();

    public static PelletReasonerFactory getInstance() {
        return INSTANCE;
    }

    public String getReasonerName() {
        return "Pellet";
    }

    public String toString() {
        return this.getReasonerName();
    }

    public PelletReasoner createReasoner(OWLOntology ontology) {
        return new PelletReasoner(ontology, BufferingMode.BUFFERING);
    }

    public PelletReasoner createReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        return new PelletReasoner(ontology, config, BufferingMode.BUFFERING);
    }

    public PelletReasoner createNonBufferingReasoner(OWLOntology ontology) {
        return new PelletReasoner(ontology, BufferingMode.NON_BUFFERING);
    }

    public PelletReasoner createNonBufferingReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        return new PelletReasoner(ontology, config, BufferingMode.NON_BUFFERING);
    }
}

