/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg;

import com.clarkparsia.owlwg.testcase.PremisedTest;
import com.clarkparsia.owlwg.testcase.TestCase;
import com.clarkparsia.owlwg.testcase.TestCaseFactory;
import com.clarkparsia.owlwg.testcase.TestVocabulary;
import com.clarkparsia.owlwg.testcase.filter.FilterCondition;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;

public class TestCollection<O>
implements Iterable<TestCase<O>> {
    private final Map<OWLIndividual, TestCase<O>> cases;

    public TestCollection(TestCaseFactory<O> factory, OWLOntology o) {
        this(factory, o, FilterCondition.ACCEPT_ALL);
    }

    public TestCollection(TestCaseFactory<O> factory, OWLOntology o, FilterCondition filter) {
        PremisedTest<O> t;
        OWLNamedIndividual i;
        if (factory == null) {
            throw new NullPointerException();
        }
        if (filter == null) {
            throw new NullPointerException();
        }
        this.cases = new HashMap<OWLIndividual, TestCase<O>>();
        Set axioms = o.getClassAssertionAxioms((OWLClassExpression)TestVocabulary.Class.POSITIVE_ENTAILMENT_TEST.getOWLClass());
        if (axioms != null) {
            for (OWLClassAssertionAxiom ax : axioms) {
                i = ax.getIndividual().asOWLNamedIndividual();
                t = factory.getPositiveEntailmentTestCase(o, i);
                if (!filter.accepts(t)) continue;
                this.cases.put((OWLIndividual)i, t);
            }
        }
        if ((axioms = o.getClassAssertionAxioms((OWLClassExpression)TestVocabulary.Class.NEGATIVE_ENTAILMENT_TEST.getOWLClass())) != null) {
            for (OWLClassAssertionAxiom ax : axioms) {
                i = ax.getIndividual().asOWLNamedIndividual();
                t = factory.getNegativeEntailmentTestCase(o, i);
                if (!filter.accepts(t)) continue;
                this.cases.put((OWLIndividual)i, t);
            }
        }
        if ((axioms = o.getClassAssertionAxioms((OWLClassExpression)TestVocabulary.Class.CONSISTENCY_TEST.getOWLClass())) != null) {
            for (OWLClassAssertionAxiom ax : axioms) {
                i = ax.getIndividual().asOWLNamedIndividual();
                if (this.cases.containsKey(i) || !filter.accepts(t = factory.getConsistencyTestCase(o, i)) || this.cases.containsKey(i)) continue;
                this.cases.put((OWLIndividual)i, t);
            }
        }
        if ((axioms = o.getClassAssertionAxioms((OWLClassExpression)TestVocabulary.Class.INCONSISTENCY_TEST.getOWLClass())) != null) {
            for (OWLClassAssertionAxiom ax : axioms) {
                i = ax.getIndividual().asOWLNamedIndividual();
                t = factory.getInconsistencyTestCase(o, i);
                if (!filter.accepts(t)) continue;
                this.cases.put((OWLIndividual)i, t);
            }
        }
    }

    public LinkedList<TestCase<O>> asList() {
        return new LinkedList<TestCase<O>>(this.getTests());
    }

    private Collection<TestCase<O>> getTests() {
        return Collections.unmodifiableCollection(this.cases.values());
    }

    @Override
    public Iterator<TestCase<O>> iterator() {
        return this.getTests().iterator();
    }

    public int size() {
        return this.getTests().size();
    }
}

