/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.runner.pellet;

import com.clarkparsia.owlwg.owlapi3.runner.impl.OwlApi3AbstractRunner;
import com.clarkparsia.owlwg.testrun.TestRunResult;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;

public class PelletOA3TestRunner
extends OwlApi3AbstractRunner {
    private static final PelletReasonerFactory reasonerFactory;
    private static final IRI iri;

    @Override
    public String getName() {
        return "Pellet";
    }

    @Override
    public IRI getIRI() {
        return iri;
    }

    @Override
    protected boolean isConsistent(OWLOntology o) {
        PelletReasoner reasoner = reasonerFactory.createReasoner(o);
        reasoner.getKB().setTimeout(this.timeout);
        return reasoner.isConsistent();
    }

    @Override
    protected boolean isEntailed(OWLOntology premise, OWLOntology conclusion) {
        PelletReasoner reasoner = reasonerFactory.createReasoner(premise);
        reasoner.getKB().setTimeout(this.timeout);
        return reasoner.isEntailed(conclusion.getLogicalAxioms());
    }

    @Override
    protected TestRunResult run(OwlApi3AbstractRunner.TestAsRunnable runnable) {
        runnable.run();
        try {
            return runnable.getResult();
        }
        catch (Throwable th) {
            System.gc();
            return runnable.getErrorResult(th);
        }
    }

    static {
        iri = IRI.create((String)"http://clarkparsia.com/pellet");
        reasonerFactory = new PelletReasonerFactory();
    }
}

