/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.testcase.filter;

import com.clarkparsia.owlwg.testcase.TestCase;
import com.clarkparsia.owlwg.testcase.filter.FilterCondition;
import java.util.Arrays;
import java.util.Collection;

public class ConjunctionFilter
implements FilterCondition {
    private final FilterCondition[] conditions;

    public static ConjunctionFilter and(Collection<? extends FilterCondition> conditions) {
        return new ConjunctionFilter(conditions);
    }

    public static ConjunctionFilter and(FilterCondition ... conditions) {
        return ConjunctionFilter.and(Arrays.asList(conditions));
    }

    public ConjunctionFilter(Collection<? extends FilterCondition> conditions) {
        if (conditions == null) {
            throw new NullPointerException();
        }
        this.conditions = conditions.toArray(new FilterCondition[0]);
    }

    public ConjunctionFilter(FilterCondition ... conditions) {
        int n = conditions.length;
        this.conditions = new FilterCondition[n];
        System.arraycopy(conditions, 0, this.conditions, 0, n);
    }

    @Override
    public boolean accepts(TestCase testcase) {
        for (FilterCondition c : this.conditions) {
            if (c.accepts(testcase)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.conditions.length; ++i) {
            buf.append(this.conditions[i].toString());
            buf.append(" ");
        }
        buf.append("and");
        return buf.toString();
    }
}

