/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3.test;

import com.clarkparsia.owlwg.Constants;
import com.clarkparsia.owlwg.TestCollection;
import com.clarkparsia.owlwg.cli.FilterConditionParser;
import com.clarkparsia.owlwg.owlapi3.testcase.impl.OwlApi3TestCaseFactory;
import com.clarkparsia.owlwg.runner.pellet.PelletOA3TestRunner;
import com.clarkparsia.owlwg.testcase.TestCase;
import com.clarkparsia.owlwg.testcase.filter.FilterCondition;
import com.clarkparsia.owlwg.testrun.RunResultType;
import com.clarkparsia.owlwg.testrun.TestRunResult;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;

@Ignore(value="Failing tests")
@RunWith(value=Parameterized.class)
public class OWLWGTestCase {
    @Rule
    public Timeout timeout = new Timeout(30000);
    private TestCase<OWLOntology> test;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Parameterized.Parameters
    public static List<Object[]> data() throws OWLOntologyCreationException, OWLOntologyChangeException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OwlApi3TestCaseFactory factory = new OwlApi3TestCaseFactory();
        FilterCondition filter = FilterConditionParser.parse("approved proposed extracredit or direct dl and");
        manager.loadOntologyFromOntologyDocument(OWLWGTestCase.class.getResourceAsStream(Constants.TEST_ONTOLOGY_PHYSICAL_IRI));
        manager.loadOntologyFromOntologyDocument(OWLWGTestCase.class.getResourceAsStream(Constants.RESULTS_ONTOLOGY_PHYSICAL_IRI));
        OWLOntology casesOntology = manager.loadOntologyFromOntologyDocument(OWLWGTestCase.class.getResourceAsStream(Constants.OWLWG_TEST_CASES_IRI));
        try {
            TestCollection<OWLOntology> cases = new TestCollection<OWLOntology>(factory, casesOntology, filter);
            ArrayList<Object[]> testParams = new ArrayList<Object[]>(cases.size());
            for (Object e : cases.asList()) {
                testParams.add(new Object[]{e});
            }
            ArrayList<Object[]> arrayList = testParams;
            return arrayList;
        }
        finally {
            manager.removeOntology(casesOntology);
        }
    }

    public OWLWGTestCase(TestCase<OWLOntology> test) {
        this.test = test;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void runTestCase() {
        try {
            PelletOA3TestRunner runner = new PelletOA3TestRunner();
            for (TestRunResult result : runner.run(this.test, 10000L)) {
                RunResultType resultType = result.getResultType();
                if (RunResultType.PASSING.equals((Object)resultType)) continue;
                if (result.getCause() != null) {
                    if (result.getCause() instanceof FreshEntitiesException) continue;
                    throw new RuntimeException(this.test.getIdentifier(), result.getCause());
                }
                Assert.fail((String)result.toString());
            }
        }
        finally {
            this.test.dispose();
            this.test = null;
            System.gc();
        }
    }
}

