/*
 * Decompiled with CFR 0.152.
 */
package profiler.statistical;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import profiler.statistical.Release;
import profiler.statistical.ReleaseUtils;

public class ReleaseManager {
    private List<Release> releases = new ArrayList<Release>();

    private void sort() {
        Collections.sort(this.releases, new Comparator<Release>(){

            @Override
            public int compare(Release o1, Release o2) {
                return o2.getReleaseDate().compareTo(o1.getReleaseDate());
            }
        });
    }

    public Release getLatestRelease() {
        if (this.releases.size() > 0) {
            return this.releases.get(0);
        }
        return null;
    }

    public Release getRelease(int index) {
        return this.releases.get(index);
    }

    public List<Release> getReleases() {
        return this.releases;
    }

    public void load(String filename) {
        File f = new File(filename);
        if (f.isDirectory()) {
            for (File file : f.listFiles()) {
                if (!file.isFile() || file.isHidden()) continue;
                this.addReleaseFromFile(file.getAbsolutePath());
            }
        } else {
            this.addReleaseFromFile(filename);
        }
        this.sort();
    }

    private void addReleaseFromFile(String filename) {
        try {
            Release r = ReleaseUtils.readFromFile(filename);
            this.releases.add(r);
        }
        catch (Exception e) {
            System.err.println("Problem reading release information file " + filename);
            e.printStackTrace();
        }
    }
}

