/*
 * Decompiled with CFR 0.152.
 */
package profiler.statistical;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StatisticalLineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.ui.RefineryUtilities;
import profiler.ProfileKB;
import profiler.statistical.Release;
import profiler.statistical.ReleaseManager;
import profiler.statistical.ReleaseStatistics;

public class ReleasePerformanceVisualizer
extends JFrame {
    private static String REPOSITORY;
    private JPanel mainPanel;
    private JPanel chart;
    private MenuPanel menu;
    private ReleaseManager manager = new ReleaseManager();

    public static void main(String[] args) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream("profiler/releasevisualizer.properties"));
        REPOSITORY = properties.getProperty("REPOSITORY", "profiler/releases");
        ReleasePerformanceVisualizer viz = new ReleasePerformanceVisualizer("Release Performance Visualizer");
        viz.setDefaultCloseOperation(3);
        viz.pack();
        RefineryUtilities.centerFrameOnScreen((Window)viz);
        viz.setVisible(true);
    }

    public ReleasePerformanceVisualizer(String title) {
        super(title);
        this.manager.load(REPOSITORY);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.menu = new MenuPanel(this.manager);
        this.mainPanel.add((Component)this.menu, "East");
        this.chart = this.createChartPanel();
        this.mainPanel.add((Component)this.chart, "Center");
        this.setContentPane(this.mainPanel);
    }

    private DefaultStatisticalCategoryDataset createDataset() {
        DefaultStatisticalCategoryDataset dataset = new DefaultStatisticalCategoryDataset();
        int count = 0;
        List<Release> releases = this.manager.getReleases();
        for (int i = releases.size() - 1; i >= 0; --i) {
            List<ReleaseStatistics> stats;
            Release release = releases.get(i);
            if (this.menu.releases.isSelectedIndex(count) && (stats = release.getStatistics((String)this.menu.ontology.getSelectedItem())) != null) {
                for (ReleaseStatistics stat : stats) {
                    double variance;
                    double mean;
                    if (!this.menu.tasks.isSelectedIndex(stat.getTask().ordinal())) continue;
                    if (this.menu.time.getSelectedIndex() == 0) {
                        mean = stat.getTimeStat("avg");
                        variance = stat.getTimeStat("var");
                    } else {
                        mean = stat.getMemStat("avg");
                        variance = stat.getMemStat("var");
                    }
                    dataset.add(mean, Math.sqrt(variance), (Comparable)((Object)stat.getTask().toString()), (Comparable)((Object)release.getVersion()));
                }
            }
            ++count;
        }
        return dataset;
    }

    private JFreeChart createChart(DefaultStatisticalCategoryDataset dataset) {
        StatisticalLineAndShapeRenderer renderer = new StatisticalLineAndShapeRenderer(true, true);
        for (int i = 0; i < dataset.getRowCount(); ++i) {
            renderer.setSeriesStroke(i, (Stroke)new BasicStroke(5.0f));
        }
        String numberAxisLabel = this.menu.time.getSelectedIndex() == 0 ? "Execution Time (s)" : "Used Memory (%)";
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, new CategoryAxis("Release"), (ValueAxis)new NumberAxis(numberAxisLabel), (CategoryItemRenderer)renderer);
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinesVisible(true);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setForegroundAlpha(0.8f);
        return new JFreeChart((String)this.menu.ontology.getSelectedItem(), (Plot)plot);
    }

    public JPanel createChartPanel() {
        JFreeChart chart = this.createChart(this.createDataset());
        return new ChartPanel(chart);
    }

    private class MenuPanel
    extends JPanel {
        JComboBox time;
        JList tasks;
        JComboBox ontology;
        JList releases;
        JButton ok;

        public MenuPanel(ReleaseManager manager) {
            this.setLayout(new BoxLayout(this, 1));
            this.time = new JComboBox<String>(new String[]{"Time", "Memory"});
            this.time.setBorder(BorderFactory.createTitledBorder("Statistic"));
            this.add(this.time);
            this.add(Box.createVerticalGlue());
            this.tasks = new JList<ProfileKB.Task>(ProfileKB.Task.values());
            this.tasks.setSelectionInterval(0, this.tasks.getModel().getSize() - 1);
            this.tasks.setBorder(BorderFactory.createTitledBorder("Task"));
            this.tasks.setVisibleRowCount(5);
            this.add(new JScrollPane(this.tasks));
            this.add(Box.createVerticalGlue());
            HashSet<String> ontologies = new HashSet<String>();
            for (Release release : manager.getReleases()) {
                for (Map.Entry<String, List<ReleaseStatistics>> statistic : release.getAllStatistics().entrySet()) {
                    ontologies.add(statistic.getKey());
                }
            }
            this.ontology = new JComboBox<Object>(ontologies.toArray());
            this.ontology.setBorder(BorderFactory.createTitledBorder("Ontology"));
            this.add(this.ontology);
            this.add(Box.createVerticalGlue());
            this.releases = new JList<Object>(manager.getReleases().toArray());
            this.releases.setSelectionInterval(0, this.releases.getModel().getSize() - 1);
            this.releases.setBorder(BorderFactory.createTitledBorder("Releases"));
            this.releases.setVisibleRowCount(5);
            this.add(new JScrollPane(this.releases));
            this.add(Box.createVerticalGlue());
            this.ok = new JButton("Draw");
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ReleasePerformanceVisualizer.this.mainPanel.remove(ReleasePerformanceVisualizer.this.chart);
                    ReleasePerformanceVisualizer.this.chart = ReleasePerformanceVisualizer.this.createChartPanel();
                    ReleasePerformanceVisualizer.this.mainPanel.add((Component)ReleasePerformanceVisualizer.this.chart, "Center");
                    ReleasePerformanceVisualizer.this.mainPanel.validate();
                }
            });
            this.add(this.ok);
        }
    }
}

