/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.test;

import com.clarkparsia.owlapi.explanation.PelletExplanation;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;

public class MiscExplanationTests {
    private static Properties savedOptions;

    @BeforeClass
    public static void saveOptions() {
        Properties newOptions = new Properties();
        newOptions.setProperty("USE_TRACING", "true");
        savedOptions = PelletOptions.setOptions((Properties)newOptions);
    }

    @AfterClass
    public static void restoreOptions() {
        PelletOptions.setOptions((Properties)savedOptions);
    }

    @Test
    public void testOWLAPI() throws Exception {
        OWLClass A = OWL.Class((String)"A");
        OWLClass B = OWL.Class((String)"B");
        OWLClass C = OWL.Class((String)"C");
        OWLNamedIndividual i = OWL.Individual((String)"i");
        OWLNamedIndividual j = OWL.Individual((String)"j");
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(OWL.disjointClasses((OWLClassExpression)A, (OWLClassExpression)B));
        axioms.add(OWL.equivalentClasses((OWLClassExpression)C, (OWLClassExpression)OWL.Nothing));
        axioms.add(OWL.classAssertion((OWLIndividual)i, (OWLClassExpression)A));
        axioms.add(OWL.classAssertion((OWLIndividual)i, (OWLClassExpression)B));
        axioms.add(OWL.classAssertion((OWLIndividual)j, (OWLClassExpression)C));
        OWLOntology ontology = OWL.Ontology(axioms);
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createReasoner(ontology);
        PelletExplanation explain = new PelletExplanation(reasoner);
        Set actual = explain.getInconsistencyExplanations();
        HashSet<Object> f = new HashSet<Object>();
        f.add(OWL.classAssertion((OWLIndividual)i, (OWLClassExpression)B));
        f.add(OWL.classAssertion((OWLIndividual)i, (OWLClassExpression)A));
        f.add(OWL.disjointClasses((OWLClassExpression)A, (OWLClassExpression)B));
        HashSet<Object> s = new HashSet<Object>();
        s.add(OWL.equivalentClasses((OWLClassExpression)C, (OWLClassExpression)OWL.Nothing));
        s.add(OWL.classAssertion((OWLIndividual)j, (OWLClassExpression)C));
        HashSet<HashSet<Object>> expected = new HashSet<HashSet<Object>>();
        expected.add(f);
        expected.add(s);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testPunning1() throws Exception {
        OWLClass A = OWL.Class((String)"A");
        OWLClass B = OWL.Class((String)"B");
        OWLNamedIndividual i = OWL.Individual((String)"A");
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(OWL.disjointClasses((OWLClassExpression)A, (OWLClassExpression)B));
        axioms.add(OWL.classAssertion((OWLIndividual)i, (OWLClassExpression)A));
        axioms.add(OWL.classAssertion((OWLIndividual)i, (OWLClassExpression)B));
        OWLOntology ontology = OWL.Ontology(axioms);
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createReasoner(ontology);
        PelletExplanation explain = new PelletExplanation(reasoner);
        Assert.assertFalse((boolean)explain.getInconsistencyExplanations().isEmpty());
    }

    @Test
    public void testPunning2() throws Exception {
        OWLObjectProperty P = OWL.ObjectProperty((String)"P");
        OWLObjectProperty S = OWL.ObjectProperty((String)"S");
        OWLNamedIndividual i = OWL.Individual((String)"P");
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(OWL.disjointProperties((OWLObjectPropertyExpression)P, (OWLObjectPropertyExpression)S));
        axioms.add(OWL.propertyAssertion((OWLIndividual)i, (OWLObjectPropertyExpression)P, (OWLIndividual)i));
        axioms.add(OWL.propertyAssertion((OWLIndividual)i, (OWLObjectPropertyExpression)S, (OWLIndividual)i));
        OWLOntology ontology = OWL.Ontology(axioms);
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createReasoner(ontology);
        PelletExplanation explain = new PelletExplanation(reasoner);
        Assert.assertFalse((boolean)explain.getInconsistencyExplanations().isEmpty());
    }

    @Test
    public void testPunning3() throws Exception {
        OWLClass A = OWL.Class((String)"A");
        OWLNamedIndividual i = OWL.Individual((String)"A");
        OWLClass B = OWL.Class((String)"B");
        OWLNamedIndividual j = OWL.Individual((String)"B");
        HashSet<Object> axioms = new HashSet<Object>();
        axioms.add(OWL.disjointClasses((OWLClassExpression)A, (OWLClassExpression)B));
        axioms.add(OWL.classAssertion((OWLIndividual)i, (OWLClassExpression)A));
        axioms.add(OWL.classAssertion((OWLIndividual)j, (OWLClassExpression)B));
        axioms.add(OWL.sameAs((OWLIndividual)i, (OWLIndividual)j));
        OWLOntology ontology = OWL.Ontology(axioms);
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createReasoner(ontology);
        PelletExplanation explain = new PelletExplanation(reasoner);
        Assert.assertFalse((boolean)explain.getInconsistencyExplanations().isEmpty());
    }

    @Test
    public void testPunningOneOf() throws Exception {
        OWLClass A = OWL.Class((String)"A");
        OWLNamedIndividual a = OWL.Individual((String)"A");
        OWLNamedIndividual b = OWL.Individual((String)"b");
        HashSet<OWLEquivalentClassesAxiom> axioms = new HashSet<OWLEquivalentClassesAxiom>();
        axioms.add(OWL.equivalentClasses((OWLClassExpression)A, (OWLClassExpression)OWL.oneOf((OWLIndividual[])new OWLIndividual[]{a, b})));
        OWLOntology ontology = OWL.Ontology(axioms);
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createReasoner(ontology);
        PelletExplanation explain = new PelletExplanation(reasoner);
        Assert.assertEquals(axioms, (Object)explain.getEntailmentExplanation((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)A)));
    }

    @Test
    public void testPunningSingletonOneOf() throws Exception {
        OWLClass A = OWL.Class((String)"A");
        OWLNamedIndividual a = OWL.Individual((String)"A");
        HashSet<OWLEquivalentClassesAxiom> axioms = new HashSet<OWLEquivalentClassesAxiom>();
        axioms.add(OWL.equivalentClasses((OWLClassExpression)A, (OWLClassExpression)OWL.oneOf((OWLIndividual[])new OWLIndividual[]{a})));
        OWLOntology ontology = OWL.Ontology(axioms);
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createReasoner(ontology);
        PelletExplanation explain = new PelletExplanation(reasoner);
        Assert.assertEquals(axioms, (Object)explain.getEntailmentExplanation((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)A)));
    }

    @Test
    public void testJena() throws Exception {
        Resource A = ResourceFactory.createResource((String)"A");
        Resource B = ResourceFactory.createResource((String)"B");
        Resource C = ResourceFactory.createResource((String)"C");
        Resource i = ResourceFactory.createResource((String)"i");
        Model expected = ModelFactory.createDefaultModel();
        expected.add(A, OWL2.disjointWith, (RDFNode)B);
        expected.add(i, RDF.type, (RDFNode)A);
        expected.add(i, RDF.type, (RDFNode)B);
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.add(expected);
        model.add(i, RDF.type, (RDFNode)C);
        model.prepare();
        Model actual = ((PelletInfGraph)model.getGraph()).explainInconsistency();
        Assert.assertEquals((Object)expected.listStatements().toSet(), (Object)actual.listStatements().toSet());
    }

    @Test
    public void testUnsatisfiable453() {
        OWLClass VolcanicMountain = OWL.Class((String)"http://test#a_VOLCANICMOUNTAIN");
        OWLClass Mountain = OWL.Class((String)"http://test#a_MOUNTAIN");
        OWLClass Volcano = OWL.Class((String)"http://test#a_VOLCANO");
        OWLClass UplandArea = OWL.Class((String)"http://test#a_UPLANDAREA");
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)VolcanicMountain, (OWLClassExpression)Mountain), OWL.subClassOf((OWLClassExpression)VolcanicMountain, (OWLClassExpression)Volcano), OWL.subClassOf((OWLClassExpression)Mountain, (OWLClassExpression)UplandArea), OWL.subClassOf((OWLClassExpression)UplandArea, (OWLClassExpression)OWL.not((OWLClassExpression)Volcano)), OWL.disjointClasses((OWLClassExpression)UplandArea, (OWLClassExpression)Volcano)};
        OWLOntology ontology = OWL.Ontology((OWLAxiom[])axioms);
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createReasoner(ontology);
        PelletExplanation explain = new PelletExplanation(reasoner);
        Set actual = explain.getUnsatisfiableExplanations((OWLClassExpression)VolcanicMountain, 0);
        Set f = SetUtils.create((Object[])new OWLAxiom[]{axioms[0], axioms[1], axioms[2], axioms[3]});
        Set s = SetUtils.create((Object[])new OWLAxiom[]{axioms[0], axioms[1], axioms[2], axioms[4]});
        Set expected = SetUtils.create((Object[])new Set[]{f, s});
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testJenaUpdates() throws Exception {
        Resource A = ResourceFactory.createResource((String)"A");
        Resource B = ResourceFactory.createResource((String)"B");
        Resource C = ResourceFactory.createResource((String)"C");
        Resource i = ResourceFactory.createResource((String)"i");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.add(i, RDF.type, (RDFNode)A);
        model.add(A, RDFS.subClassOf, (RDFNode)B);
        model.prepare();
        Model actual = ((PelletInfGraph)model.getGraph()).explain(i, RDF.type, (RDFNode)B);
        Model expected = model.getRawModel();
        Assert.assertEquals((Object)expected.listStatements().toSet(), (Object)actual.listStatements().toSet());
        model.add(B, RDFS.subClassOf, (RDFNode)C);
        model.prepare();
        actual = ((PelletInfGraph)model.getGraph()).explain(i, RDF.type, (RDFNode)C);
        expected = model.getRawModel();
        Assert.assertEquals((Object)expected.listStatements().toSet(), (Object)actual.listStatements().toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFromResource(OntModel model, String resource) {
        InputStream stream = null;
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(resource);
            model.read(stream, null);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

