/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.jena.test;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public abstract class AbstractJenaTests {
    protected static final Resource A = ResourceFactory.createResource((String)"A");
    protected static final Resource B = ResourceFactory.createResource((String)"B");
    protected static final Resource C = ResourceFactory.createResource((String)"C");
    protected static final Resource D = ResourceFactory.createResource((String)"D");
    protected static final Resource E = ResourceFactory.createResource((String)"E");
    protected static final Resource a = ResourceFactory.createResource((String)"a");
    protected static final Resource b = ResourceFactory.createResource((String)"b");
    protected static final Resource c = ResourceFactory.createResource((String)"c");
    protected static final Resource d = ResourceFactory.createResource((String)"d");
    protected static final Resource e = ResourceFactory.createResource((String)"e");
    protected OntModel model;
    protected OntModel reasoner;

    @Before
    public void before() {
        this.model = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        this.reasoner = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, (Model)this.model);
        this.reasoner.setStrictMode(false);
    }

    @After
    public void after() throws Exception {
        this.model.close();
    }

    protected void classes(Resource ... classes) {
        for (Resource cls : classes) {
            this.model.add(cls, RDF.type, (RDFNode)OWL.Class);
        }
    }

    protected void objectProperties(Resource ... props) {
        for (Resource p : props) {
            this.model.add(p, RDF.type, (RDFNode)OWL.ObjectProperty);
        }
    }

    protected void dataProperties(Resource ... props) {
        for (Resource p : props) {
            this.model.add(p, RDF.type, (RDFNode)OWL.DatatypeProperty);
        }
    }

    protected void annotationProperties(Resource ... props) {
        for (Resource p : props) {
            this.model.add(p, RDF.type, (RDFNode)OWL.AnnotationProperty);
        }
    }

    protected void individuals(Resource ... inds) {
        for (Resource ind : inds) {
            this.model.add(ind, RDF.type, (RDFNode)OWL.Thing);
        }
    }

    public Resource oneOf(Resource ... terms) {
        return this.model.createEnumeratedClass(null, this.model.createList((RDFNode[])terms));
    }

    public Resource not(Resource cls) {
        return this.model.createComplementClass(null, cls);
    }

    public void assertConsistent() {
        Assert.assertTrue((boolean)((PelletInfGraph)this.reasoner.getGraph()).isConsistent());
    }

    public void assertInconsistent() {
        Assert.assertFalse((boolean)((PelletInfGraph)this.reasoner.getGraph()).isConsistent());
    }
}

