/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.AxiomBasedModuleExtractor;
import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.io.IncrementalClassifierPersistence;
import com.clarkparsia.modularity.test.TestUtils;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.test.PelletTestSuite;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class PersistenceClassificationTest {
    public static final String base = PelletTestSuite.base + "modularity/";
    private static final String TEST_FILE = "test-persistence-classification.zip";

    public ModuleExtractor createModuleExtractor() {
        return new AxiomBasedModuleExtractor();
    }

    public void testFile(String fileName) throws IOException {
        String common = "file:" + base + fileName;
        this.testClassification(common + ".owl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testClassification(String inputOnt) throws IOException {
        File testFile = new File(TEST_FILE);
        OWLOntology ontology = OntologyUtils.loadOntology((String)inputOnt);
        try {
            PelletReasoner unified = PelletReasonerFactory.getInstance().createReasoner(ontology);
            ModuleExtractor moduleExtractor = this.createModuleExtractor();
            IncrementalClassifier modular = new IncrementalClassifier(unified, moduleExtractor);
            modular.classify();
            FileOutputStream fos = new FileOutputStream(testFile);
            IncrementalClassifierPersistence.save((IncrementalClassifier)modular, (OutputStream)fos);
            fos.close();
            FileInputStream fis = new FileInputStream(testFile);
            IncrementalClassifier modular2 = IncrementalClassifierPersistence.load((InputStream)fis);
            fis.close();
            TestUtils.assertClassificationEquals((OWLReasoner)unified, (OWLReasoner)modular2);
            Assert.assertTrue((boolean)testFile.delete());
            unified.dispose();
            modular.dispose();
            modular2.dispose();
        }
        finally {
            OWL.manager.removeOntology(ontology);
        }
    }

    @Test
    public void koalaPersistenceClassifyTest() throws IOException {
        this.testFile("koala");
    }

    @Test
    public void miniTambisPersistenceClassifyTest() throws IOException {
        this.testFile("miniTambis");
    }

    @Test
    public void sumoPersistenceClassifyTest() throws IOException {
        this.testFile("SUMO");
    }

    @Test
    public void sweetPersistenceClassifyTest() throws IOException {
        this.testFile("SWEET");
    }

    @Test
    public void galenPersistenceClassifyTest() throws IOException {
        this.testFile("galen");
    }

    @Test
    public void winePersistenceClassifyTest() throws IOException {
        this.testFile("wine");
    }
}

