/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.AxiomBasedModuleExtractor;
import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.PelletIncremantalReasonerFactory;
import com.clarkparsia.modularity.io.IncrementalClassifierPersistence;
import com.clarkparsia.modularity.test.AbstractModularityTest;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.utils.MultiValueMap;
import org.semanticweb.owlapi.model.OWLOntology;

public class PersistenceModularityTest
extends AbstractModularityTest {
    private static final String TEST_FILE = "test-persistence.zip";

    @Override
    public ModuleExtractor createModuleExtractor() {
        return new AxiomBasedModuleExtractor();
    }

    private void testPersistence(OWLOntology ontology) throws IOException {
        File testFile = new File(TEST_FILE);
        ModuleExtractor moduleExtractor = this.createModuleExtractor();
        IncrementalClassifier modular = PelletIncremantalReasonerFactory.getInstance().createReasoner(ontology, moduleExtractor);
        modular.classify();
        MultiValueMap expectedModules = modular.getModules();
        FileOutputStream fos = new FileOutputStream(testFile);
        IncrementalClassifierPersistence.save((IncrementalClassifier)modular, (OutputStream)fos);
        fos.close();
        modular.dispose();
        FileInputStream fis = new FileInputStream(testFile);
        modular = IncrementalClassifierPersistence.load((InputStream)fis);
        fis.close();
        modular.dispose();
        MultiValueMap actualModules = modular.getModules();
        Assert.assertEquals((Object)expectedModules, (Object)actualModules);
        Assert.assertTrue((boolean)testFile.delete());
    }

    private void testPersistence(String file) throws IOException {
        OWLOntology ontology = OntologyUtils.loadOntology((String)("file:" + file), (boolean)false);
        try {
            this.testPersistence(ontology);
        }
        finally {
            OWL.manager.removeOntology(ontology);
        }
    }

    @Test
    public void testGalen() throws IOException {
        this.testPersistence("test/data/modularity/galen.owl");
    }

    public static void main(String[] args) throws IOException {
        new PersistenceModularityTest().testPersistence("test/data/modularity/galen.owl");
    }
}

