/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.reachability.EntityNode;
import com.clarkparsia.reachability.Node;
import com.clarkparsia.reachability.ReachabilityGraph;
import com.clarkparsia.reachability.SCC;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SCCTests {
    private ReachabilityGraph graph;
    private EntityNode[] nodes;

    private void addEdge(int in, int out) {
        this.nodes[in].addOutput((Node)this.nodes[out]);
    }

    private void createGraph(int n) {
        this.graph = new ReachabilityGraph();
        this.nodes = new EntityNode[n];
        for (int i = 0; i < n; ++i) {
            this.nodes[i] = this.graph.createEntityNode((Object)OWL.Class((String)("entity" + i)));
        }
    }

    private void testSCC(int[][] expectedSCC) {
        List computed = SCC.computeSCC((ReachabilityGraph)this.graph);
        Assert.assertEquals((String)"SCC count", (long)expectedSCC.length, (long)computed.size());
        for (int[] component : expectedSCC) {
            HashSet<EntityNode> set = new HashSet<EntityNode>();
            for (int i : component) {
                set.add(this.nodes[i]);
            }
            Assert.assertTrue((boolean)computed.contains(set));
        }
    }

    @Test
    public void simpleTest1() {
        this.createGraph(8);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(1, 4);
        this.addEdge(1, 5);
        this.addEdge(2, 3);
        this.addEdge(2, 6);
        this.addEdge(3, 2);
        this.addEdge(3, 7);
        this.addEdge(4, 0);
        this.addEdge(4, 5);
        this.addEdge(5, 6);
        this.addEdge(6, 5);
        this.addEdge(7, 3);
        this.addEdge(7, 6);
        int[][] scc = new int[][]{{0, 1, 4}, {2, 3, 7}, {5, 6}};
        this.testSCC(scc);
    }

    @Test
    public void simpleTest2() {
        this.createGraph(11);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(1, 3);
        this.addEdge(1, 4);
        this.addEdge(2, 5);
        this.addEdge(4, 1);
        this.addEdge(4, 6);
        this.addEdge(5, 2);
        this.addEdge(5, 7);
        this.addEdge(6, 7);
        this.addEdge(6, 8);
        this.addEdge(7, 10);
        this.addEdge(8, 9);
        this.addEdge(9, 6);
        this.addEdge(10, 8);
        int[][] scc = new int[][]{{0}, {1, 4}, {3}, {2, 5}, {6, 7, 8, 9, 10}};
        this.testSCC(scc);
    }

    @Test
    public void disconnectedTest() {
        this.createGraph(7);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(2, 3);
        this.addEdge(3, 2);
        this.addEdge(4, 5);
        this.addEdge(5, 6);
        this.addEdge(6, 4);
        int[][] scc = new int[][]{{0}, {1}, {2, 3}, {4, 5, 6}};
        this.testSCC(scc);
    }
}

