/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.PelletIncremantalReasonerFactory;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import org.junit.Assert;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.utils.Comparators;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class TestUtils {
    public static <T> void assertToStringEquals(String msg, T[] expected, T[] computed) {
        Comparator comparator = Comparators.stringComparator;
        ArrayList<T> onlyInComputed = new ArrayList<T>();
        ArrayList<T> onlyInExpected = new ArrayList<T>();
        ArrayList<T> both = new ArrayList<T>();
        Arrays.sort(expected, comparator);
        Arrays.sort(computed, comparator);
        int i = 0;
        int j = 0;
        while (i < computed.length && j < expected.length) {
            if (computed[i].equals(expected[j])) {
                both.add(computed[i]);
                ++i;
                ++j;
                continue;
            }
            if (comparator.compare(computed[i], expected[j]) < 0) {
                onlyInComputed.add(computed[i]);
                ++i;
                continue;
            }
            onlyInExpected.add(expected[j]);
            ++j;
        }
        while (i < computed.length) {
            onlyInComputed.add(computed[i++]);
        }
        while (j < expected.length) {
            onlyInExpected.add(expected[j++]);
        }
        if (!onlyInComputed.isEmpty() || !onlyInExpected.isEmpty()) {
            System.err.println(msg);
            System.err.println("Both " + both.size() + " " + both);
            System.err.println("Computed " + onlyInComputed.size() + " " + onlyInComputed);
            System.err.println("Expected " + onlyInExpected.size() + " " + onlyInExpected);
            System.err.println();
            Assert.fail((String)msg);
        }
    }

    public static List<OWLOntologyChange> createChanges(OWLOntology ontology, Collection<? extends OWLAxiom> axioms, boolean add) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLAxiom oWLAxiom : axioms) {
            AddAxiom change = add ? new AddAxiom(ontology, oWLAxiom) : new RemoveAxiom(ontology, oWLAxiom);
            changes.add((OWLOntologyChange)change);
        }
        return changes;
    }

    public static <E> Set<E> flatten(Set<Set<E>> setOfSets) {
        HashSet<E> result = new HashSet<E>();
        for (Set<E> set : setOfSets) {
            result.addAll(set);
        }
        return result;
    }

    public static double[] getSizes(Collection<? extends Collection<?>> collections) {
        double[] sizes = new double[collections.size()];
        int i = 0;
        for (Collection<?> collection : collections) {
            sizes[i++] = collection.size();
        }
        return sizes;
    }

    public static OWLAxiom selectRandomAxiom(OWLOntology ontology) throws OWLException {
        Set<OWLAxiom> selectedAxioms = TestUtils.selectRandomAxioms(ontology, 1);
        return selectedAxioms.iterator().next();
    }

    public static Set<OWLAxiom> selectRandomAxioms(OWLOntology ontology, int count) {
        Set axioms = ontology.getAxioms();
        return TestUtils.selectRandomElements(axioms, count);
    }

    public static <T> Set<T> selectRandomElements(Collection<T> coll, int K) {
        int N = coll.size();
        if (K > N) {
            throw new IllegalArgumentException(K + " >= " + N);
        }
        List<Object> list = coll instanceof RandomAccess ? (List<Object>)coll : new ArrayList<T>(coll);
        Random rand = new Random();
        for (int k = 0; k < K; ++k) {
            int j = rand.nextInt(N - k) + k;
            Collections.swap(list, k, j);
        }
        return new HashSet(list.subList(0, K));
    }

    public static void assertClassificationEquals(OWLReasoner expected, OWLReasoner actual) {
        for (OWLClass cls : actual.getRootOntology().getClassesInSignature()) {
            TestUtils.assertClassificationEquals(expected, actual, cls);
        }
    }

    public static void assertClassificationEquals(OWLReasoner expected, OWLReasoner actual, OWLClass cls) {
        Set expectedEquivalents = expected.getEquivalentClasses((OWLClassExpression)cls).getEntities();
        Set actualEquivalents = actual.getEquivalentClasses((OWLClassExpression)cls).getEntities();
        Assert.assertEquals((String)("Equivalents different for Class: " + cls), (Object)expectedEquivalents, (Object)actualEquivalents);
        Set expectedSupers = expected.getSuperClasses((OWLClassExpression)cls, true).getFlattened();
        Set actualSupers = actual.getSuperClasses((OWLClassExpression)cls, true).getFlattened();
        Assert.assertEquals((String)("Supers different for Class: " + cls), (Object)expectedSupers, (Object)actualSupers);
    }

    public static void assertDisjointnessEquals(OWLReasoner expected, OWLReasoner actual) {
        for (OWLClass cls : actual.getRootOntology().getClassesInSignature()) {
            TestUtils.assertDisjointnessEquals(expected, actual, cls);
        }
    }

    public static void assertDisjointnessEquals(OWLReasoner expected, OWLReasoner actual, OWLClass cls) {
        Set expectedDisjoints = expected.getDisjointClasses((OWLClassExpression)cls).getFlattened();
        Set actualDisjoints = actual.getDisjointClasses((OWLClassExpression)cls).getFlattened();
        Assert.assertEquals((String)("Disjoint classes different for Class: " + cls), (Object)expectedDisjoints, (Object)actualDisjoints);
    }

    public static void assertInstancesEquals(OWLReasoner expected, OWLReasoner actual) {
        for (OWLClass cls : actual.getRootOntology().getClassesInSignature()) {
            TestUtils.assertInstancesEquals(expected, actual, cls);
        }
    }

    public static void assertInstancesEquals(OWLReasoner expected, OWLReasoner actual, OWLClass cls) {
        Set expectedIndividuals = expected.getInstances((OWLClassExpression)cls, true).getFlattened();
        Set actualIndividuals = actual.getInstances((OWLClassExpression)cls, true).getFlattened();
        Assert.assertEquals((String)("Instances different for Class: " + cls), (Object)expectedIndividuals, (Object)actualIndividuals);
    }

    public static void assertTypesEquals(OWLReasoner expected, OWLReasoner actual) {
        for (OWLNamedIndividual ind : actual.getInstances((OWLClassExpression)OWL.Thing, false).getFlattened()) {
            TestUtils.assertTypesEquals(expected, actual, ind);
        }
    }

    public static void assertTypesEquals(OWLReasoner expected, OWLReasoner actual, OWLNamedIndividual individual) {
        Set expectedTypes = expected.getTypes(individual, true).getFlattened();
        Set actualTypes = actual.getTypes(individual, true).getFlattened();
        Assert.assertEquals((String)("Types different for individual: " + individual), (Object)expectedTypes, (Object)actualTypes);
    }

    public static void runDisjointnessTest(OWLOntology ontology, ModuleExtractor modExtractor) {
        TestUtils.runComparisonTest(ontology, modExtractor, new ReasonerComparisonMethod(){

            @Override
            public void compare(OWLReasoner expected, OWLReasoner actual) {
                TestUtils.assertDisjointnessEquals(expected, actual);
            }
        });
    }

    public static void runDisjointnessUpdateTest(OWLOntology ontology, ModuleExtractor modExtractor, Collection<OWLAxiom> additions, Collection<OWLAxiom> deletions) {
        TestUtils.runComparisonUpdateTest(ontology, modExtractor, additions, deletions, new ReasonerComparisonMethod(){

            @Override
            public void compare(OWLReasoner expected, OWLReasoner actual) {
                TestUtils.assertDisjointnessEquals(expected, actual);
            }
        });
    }

    public static void runInstancesTest(OWLOntology ontology, ModuleExtractor modExtractor) {
        TestUtils.runComparisonTest(ontology, modExtractor, new ReasonerComparisonMethod(){

            @Override
            public void compare(OWLReasoner expected, OWLReasoner actual) {
                TestUtils.assertInstancesEquals(expected, actual);
            }
        });
    }

    public static void runInstancesUpdateTest(OWLOntology ontology, ModuleExtractor modExtractor, Collection<OWLAxiom> additions, Collection<OWLAxiom> deletions) {
        TestUtils.runComparisonUpdateTest(ontology, modExtractor, additions, deletions, new ReasonerComparisonMethod(){

            @Override
            public void compare(OWLReasoner expected, OWLReasoner actual) {
                TestUtils.assertInstancesEquals(expected, actual);
            }
        });
    }

    public static void runTypesTest(OWLOntology ontology, ModuleExtractor modExtractor) {
        TestUtils.runComparisonTest(ontology, modExtractor, new ReasonerComparisonMethod(){

            @Override
            public void compare(OWLReasoner expected, OWLReasoner actual) {
                TestUtils.assertTypesEquals(expected, actual);
            }
        });
    }

    public static void runTypesUpdateTest(OWLOntology ontology, ModuleExtractor modExtractor, Collection<OWLAxiom> additions, Collection<OWLAxiom> deletions) {
        TestUtils.runComparisonUpdateTest(ontology, modExtractor, additions, deletions, new ReasonerComparisonMethod(){

            @Override
            public void compare(OWLReasoner expected, OWLReasoner actual) {
                TestUtils.assertTypesEquals(expected, actual);
            }
        });
    }

    public static void runUpdateTest(OWLOntology ontology, ModuleExtractor modExtractor, Collection<OWLAxiom> additions, Collection<OWLAxiom> deletions) throws OWLException {
        TestUtils.runComparisonUpdateTest(ontology, modExtractor, additions, deletions, new ReasonerComparisonMethod(){

            @Override
            public void compare(OWLReasoner expected, OWLReasoner actual) {
                TestUtils.assertClassificationEquals(expected, actual);
            }
        });
    }

    private static void runComparisonTest(OWLOntology ontology, ModuleExtractor modExtractor, ReasonerComparisonMethod comparisonMethod) {
        PelletReasoner unified = PelletReasonerFactory.getInstance().createNonBufferingReasoner(ontology);
        IncrementalClassifier modular = PelletIncremantalReasonerFactory.getInstance().createReasoner(ontology, modExtractor);
        PelletOptions.USE_CLASSIFICATION_MONITOR = PelletOptions.MonitorType.CONSOLE;
        modular.classify();
        unified.getKB().classify();
        comparisonMethod.compare((OWLReasoner)unified, (OWLReasoner)modular);
        modular.dispose();
    }

    private static void runComparisonUpdateTest(OWLOntology ontology, ModuleExtractor modExtractor, Collection<OWLAxiom> additions, Collection<OWLAxiom> deletions, ReasonerComparisonMethod comparisonMethod) {
        PelletReasoner unified = PelletReasonerFactory.getInstance().createNonBufferingReasoner(ontology);
        IncrementalClassifier modular = PelletIncremantalReasonerFactory.getInstance().createReasoner(ontology, modExtractor);
        PelletOptions.USE_CLASSIFICATION_MONITOR = PelletOptions.MonitorType.CONSOLE;
        modular.classify();
        comparisonMethod.compare((OWLReasoner)unified, (OWLReasoner)modular);
        OntologyUtils.addAxioms((OWLOntology)ontology, additions);
        OntologyUtils.removeAxioms((OWLOntology)ontology, deletions);
        modular.classify();
        unified.flush();
        unified.getKB().classify();
        modular.timers.print();
        comparisonMethod.compare((OWLReasoner)unified, (OWLReasoner)modular);
        modular.dispose();
    }

    public static <T> Set<T> set(T ... elements) {
        switch (elements.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(elements[0]);
            }
        }
        return new HashSet<T>(Arrays.asList(elements));
    }

    private static interface ReasonerComparisonMethod {
        public void compare(OWLReasoner var1, OWLReasoner var2);
    }
}

