/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.datatypes.DatatypeReasoner;
import com.clarkparsia.pellet.datatypes.DatatypeReasonerImpl;
import com.clarkparsia.pellet.datatypes.Datatypes;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidConstrainingFacetException;
import com.clarkparsia.pellet.datatypes.exceptions.InvalidLiteralException;
import com.clarkparsia.pellet.datatypes.exceptions.UnrecognizedDatatypeException;
import com.clarkparsia.pellet.utils.TermFactory;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.test.PelletTestCase;

public class DatatypeReasonerTests {
    private ABox abox;
    private DatatypeReasoner reasoner;

    private static BigDecimal decimal(String value) {
        return new BigDecimal(value);
    }

    private static Collection<ATermAppl> getSatisfiableDecimalEnumerations() {
        List<ATermAppl> dataranges = Arrays.asList(TermFactory.oneOf((ATermAppl[])new ATermAppl[]{TermFactory.literal((String)"1.0", (ATermAppl)Datatypes.DECIMAL), TermFactory.literal((String)"2.0", (ATermAppl)Datatypes.DECIMAL), TermFactory.literal((String)"3.0", (ATermAppl)Datatypes.DECIMAL)}), TermFactory.oneOf((ATermAppl[])new ATermAppl[]{TermFactory.literal((String)"2.0", (ATermAppl)Datatypes.DECIMAL), TermFactory.literal((String)"4.0", (ATermAppl)Datatypes.DECIMAL), TermFactory.literal((String)"6.0", (ATermAppl)Datatypes.DECIMAL)}));
        return dataranges;
    }

    private static Collection<ATermAppl> getSatisfiableDecimalRanges() {
        ATermAppl dt1 = TermFactory.restrict((ATermAppl)Datatypes.DECIMAL, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((String)"1.0", (ATermAppl)Datatypes.DECIMAL)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((String)"3.0", (ATermAppl)Datatypes.DECIMAL))});
        ATermAppl dt2 = TermFactory.restrict((ATermAppl)Datatypes.DECIMAL, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((String)"2.0", (ATermAppl)Datatypes.DECIMAL)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((String)"4.0", (ATermAppl)Datatypes.DECIMAL))});
        List<ATermAppl> dataranges = Arrays.asList(dt1, dt2);
        return dataranges;
    }

    private static Collection<ATermAppl> getUnsatisfiableDecimalEnumerations() {
        List<ATermAppl> dataranges = Arrays.asList(TermFactory.oneOf((ATermAppl[])new ATermAppl[]{TermFactory.literal((String)"1.0", (ATermAppl)Datatypes.DECIMAL), TermFactory.literal((String)"2.0", (ATermAppl)Datatypes.DECIMAL), TermFactory.literal((String)"3.0", (ATermAppl)Datatypes.DECIMAL)}), TermFactory.oneOf((ATermAppl[])new ATermAppl[]{TermFactory.literal((String)"4.0", (ATermAppl)Datatypes.DECIMAL), TermFactory.literal((String)"5.0", (ATermAppl)Datatypes.DECIMAL), TermFactory.literal((String)"6.0", (ATermAppl)Datatypes.DECIMAL)}));
        return dataranges;
    }

    private static Collection<ATermAppl> getUnsatisfiableDecimalRanges() {
        ATermAppl dt1 = TermFactory.restrict((ATermAppl)Datatypes.DECIMAL, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((String)"1.0", (ATermAppl)Datatypes.DECIMAL)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((String)"3.0", (ATermAppl)Datatypes.DECIMAL))});
        ATermAppl dt2 = TermFactory.restrict((ATermAppl)Datatypes.DECIMAL, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((String)"4.0", (ATermAppl)Datatypes.DECIMAL)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((String)"6.0", (ATermAppl)Datatypes.DECIMAL))});
        List<ATermAppl> dataranges = Arrays.asList(dt1, dt2);
        return dataranges;
    }

    @Test
    public void oneVSatisfiableDecimalRanges() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Literal x = new Literal(TermFactory.term((String)"x"), null, this.abox, DependencySet.INDEPENDENT);
        for (ATermAppl a : DatatypeReasonerTests.getSatisfiableDecimalRanges()) {
            x.addType(a, DependencySet.INDEPENDENT);
        }
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(x), Collections.emptyMap()));
    }

    @Test
    public void oneVSatisfiableEnumerations() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Literal x = new Literal(TermFactory.term((String)"x"), null, this.abox, DependencySet.INDEPENDENT);
        for (ATermAppl a : DatatypeReasonerTests.getSatisfiableDecimalEnumerations()) {
            x.addType(a, DependencySet.INDEPENDENT);
        }
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(x), Collections.emptyMap()));
    }

    @Test
    public void oneVUnsatisfiableDecimalRanges() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Literal x = new Literal(TermFactory.term((String)"x"), null, this.abox, DependencySet.INDEPENDENT);
        for (ATermAppl a : DatatypeReasonerTests.getUnsatisfiableDecimalRanges()) {
            x.addType(a, DependencySet.INDEPENDENT);
        }
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(Collections.singleton(x), Collections.emptyMap()));
    }

    @Test
    public void oneVUnsatisfiableEnumerations() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Literal x = new Literal(TermFactory.term((String)"x"), null, this.abox, DependencySet.INDEPENDENT);
        for (ATermAppl a : DatatypeReasonerTests.getUnsatisfiableDecimalEnumerations()) {
            x.addType(a, DependencySet.INDEPENDENT);
        }
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(Collections.singleton(x), Collections.emptyMap()));
    }

    @Before
    public void reset() {
        this.reasoner = new DatatypeReasonerImpl();
        this.abox = new ABox(null);
    }

    @Test
    public void unarySatisfiableDecimalEnumerations() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Collection<ATermAppl> dataranges = DatatypeReasonerTests.getSatisfiableDecimalEnumerations();
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(dataranges));
    }

    @Test
    public void unarySatisfiableDecimalRanges() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Collection<ATermAppl> dataranges = DatatypeReasonerTests.getSatisfiableDecimalRanges();
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(dataranges));
    }

    @Test
    public void unaryUnsatisfiableDecimalEnumerations() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Collection<ATermAppl> dataranges = DatatypeReasonerTests.getUnsatisfiableDecimalEnumerations();
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(dataranges));
    }

    @Test
    public void unaryUnsatisfiableDecimalRanges() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Collection<ATermAppl> dataranges = DatatypeReasonerTests.getUnsatisfiableDecimalRanges();
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(dataranges));
    }

    @Test
    public void unaryValuesInDecimalRange() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl type = TermFactory.restrict((ATermAppl)Datatypes.DECIMAL, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((String)"1.0", (ATermAppl)Datatypes.DECIMAL)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((String)"2.5", (ATermAppl)Datatypes.DECIMAL))});
        Set<ATermAppl> types = Collections.singleton(type);
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)DatatypeReasonerTests.decimal("0.99")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)1));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)2));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)DatatypeReasonerTests.decimal("2.5")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)DatatypeReasonerTests.decimal("2.51")));
    }

    @Test
    public void unaryValuesInNamedDecimalRange() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl rdt = TermFactory.restrict((ATermAppl)Datatypes.DECIMAL, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((String)"1.0", (ATermAppl)Datatypes.DECIMAL)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((String)"2.5", (ATermAppl)Datatypes.DECIMAL))});
        ATermAppl name = TermFactory.term((String)"newDt");
        Set<ATermAppl> types = Collections.singleton(name);
        Assert.assertTrue((boolean)this.reasoner.define(name, rdt));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)DatatypeReasonerTests.decimal("0.99")));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)1));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)2));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)DatatypeReasonerTests.decimal("2.5")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)DatatypeReasonerTests.decimal("2.51")));
    }

    public void assertSatisfiable(ATermAppl ... dataranges) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.testSatisfiability(true, dataranges);
    }

    public void assertUnsatisfiable(ATermAppl ... dataranges) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.testSatisfiability(false, dataranges);
    }

    public void testSatisfiability(boolean isSatisfiable, ATermAppl ... dataranges) throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        Assert.assertTrue((isSatisfiable == this.reasoner.isSatisfiable(Arrays.asList(dataranges)) ? 1 : 0) != 0);
    }

    @Test
    public void intersectIntegerDecimal() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertSatisfiable(Datatypes.INTEGER, Datatypes.DECIMAL);
    }

    @Test
    public void intersectIntegerNotDecimal() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertUnsatisfiable(Datatypes.INTEGER, TermFactory.not((ATermAppl)Datatypes.DECIMAL));
    }

    @Test
    public void intersectIntegerBytePositiveInteger() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertSatisfiable(Datatypes.INTEGER, Datatypes.BYTE, Datatypes.POSITIVE_INTEGER);
    }

    @Test
    public void intersectPositiveNegativeInteger() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertUnsatisfiable(Datatypes.NEGATIVE_INTEGER, Datatypes.POSITIVE_INTEGER);
    }

    @Test
    public void intersectNonPositiveNonNegativeInteger() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertSatisfiable(Datatypes.NON_NEGATIVE_INTEGER, Datatypes.NON_POSITIVE_INTEGER);
    }

    @Test
    public void intersectIntegerFloat() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertUnsatisfiable(Datatypes.INTEGER, Datatypes.FLOAT);
    }

    @Test
    public void intersectFloatDouble() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertUnsatisfiable(Datatypes.FLOAT, Datatypes.DOUBLE);
    }

    @Test
    public void intersectIntegerNotFloat() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertSatisfiable(Datatypes.INTEGER, TermFactory.not((ATermAppl)Datatypes.FLOAT));
    }

    @Test
    public void intersectIntegerIntervalNotInteger() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl integerInterval = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)0)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((int)1))});
        this.assertUnsatisfiable(integerInterval, TermFactory.not((ATermAppl)Datatypes.INTEGER));
    }

    @Test
    public void intersectFloatIntervalNotFloat() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl floatInterval = TermFactory.restrict((ATermAppl)Datatypes.FLOAT, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((float)0.0f)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((float)1.0f))});
        this.assertUnsatisfiable(floatInterval, TermFactory.not((ATermAppl)Datatypes.FLOAT));
    }

    @Test
    public void intersectNegatedIntegerInterval() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl intInterval1 = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)0)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((int)1))});
        ATermAppl intInterval2 = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)2)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((int)3))});
        this.assertSatisfiable(intInterval1, TermFactory.not((ATermAppl)intInterval2));
    }

    @Test
    public void intersectNegatedDoubleInterval() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl doubleInterval1 = TermFactory.restrict((ATermAppl)Datatypes.DOUBLE, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((double)0.0)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((double)1.0))});
        ATermAppl doubleInterval2 = TermFactory.restrict((ATermAppl)Datatypes.DOUBLE, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((double)2.0)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((double)3.0))});
        this.assertSatisfiable(doubleInterval1, TermFactory.not((ATermAppl)doubleInterval2));
    }

    @Test
    public void intersectNegatedFloatInterval() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl floatInterval1 = TermFactory.restrict((ATermAppl)Datatypes.FLOAT, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((float)0.0f)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((float)1.0f))});
        ATermAppl floatInterval2 = TermFactory.restrict((ATermAppl)Datatypes.FLOAT, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((float)2.0f)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((float)3.0f))});
        this.assertSatisfiable(floatInterval1, TermFactory.not((ATermAppl)floatInterval2));
    }

    @Test
    public void intersectFloatAndFloatInterval() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl floatInterval = TermFactory.restrict((ATermAppl)Datatypes.FLOAT, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((float)0.0f)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((float)1.0f))});
        this.assertSatisfiable(floatInterval, Datatypes.FLOAT, Datatypes.LITERAL);
    }

    @Test
    public void intersectDoubleIntervalNotDouble() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl doubleInterval = TermFactory.restrict((ATermAppl)Datatypes.DOUBLE, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((double)0.0)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((double)1.0))});
        this.assertUnsatisfiable(doubleInterval, TermFactory.not((ATermAppl)Datatypes.DOUBLE));
    }

    @Test
    public void intersectIntegerNotByte() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertSatisfiable(Datatypes.INTEGER, TermFactory.not((ATermAppl)Datatypes.BYTE));
    }

    @Test
    public void intersectDoubleNotIntegerNotFloat() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertSatisfiable(Datatypes.DOUBLE, TermFactory.not((ATermAppl)Datatypes.INTEGER), TermFactory.not((ATermAppl)Datatypes.FLOAT));
    }

    @Test
    public void intersectNotIntegerByte() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertUnsatisfiable(TermFactory.not((ATermAppl)Datatypes.INTEGER), Datatypes.BYTE);
    }

    @Test
    public void intersectNotIntegerNotByte() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertSatisfiable(Datatypes.BYTE, TermFactory.not((ATermAppl)Datatypes.POSITIVE_INTEGER), TermFactory.not((ATermAppl)Datatypes.NEGATIVE_INTEGER));
    }

    @Test
    public void intersectIntegerNotLiteral() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertUnsatisfiable(Datatypes.BYTE, TermFactory.not((ATermAppl)Datatypes.LITERAL));
    }

    @Test
    public void intersectIntegerNegatedEmptyIntegerRange() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl type = TermFactory.not((ATermAppl)TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((String)"2", (ATermAppl)Datatypes.INTEGER)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((String)"1", (ATermAppl)Datatypes.INTEGER))}));
        List<ATermAppl> types = Arrays.asList(Datatypes.INTEGER, type);
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types));
        Assert.assertTrue((boolean)this.reasoner.containsAtLeast(2, types));
    }

    @Test
    public void intersectIntegerNegatedIntegerValue() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        List<ATermAppl> types = Arrays.asList(Datatypes.INTEGER, TermFactory.not((ATermAppl)TermFactory.value((ATermAppl)TermFactory.literal((int)3))));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types));
        Assert.assertTrue((boolean)this.reasoner.containsAtLeast(2, types));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, this.reasoner.getValue(TermFactory.literal((int)1))));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, this.reasoner.getValue(TermFactory.literal((int)3))));
    }

    @Test
    public void intersectTextNegatedTextValue() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        List<ATermAppl> types = Arrays.asList(Datatypes.PLAIN_LITERAL, TermFactory.not((ATermAppl)TermFactory.value((ATermAppl)TermFactory.literal((String)"http://example.org"))));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types));
        Assert.assertTrue((boolean)this.reasoner.containsAtLeast(2, types));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"http://example.com")));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"http://example.org")));
    }

    @Test
    public void intersectStringToken() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertSatisfiable(Datatypes.STRING, Datatypes.TOKEN);
    }

    @Test
    public void intersectNameToken() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        this.assertSatisfiable(Datatypes.NAME, Datatypes.TOKEN);
    }

    @Test
    public void intersectAnyURINegatedTextValue() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        List<ATermAppl> types = Arrays.asList(Datatypes.ANY_URI, TermFactory.not((ATermAppl)TermFactory.value((ATermAppl)TermFactory.literal((String)"http://example.org"))));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types));
        Assert.assertTrue((boolean)this.reasoner.containsAtLeast(2, types));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"http://example.com", (ATermAppl)Datatypes.ANY_URI)));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"http://example.org", (ATermAppl)Datatypes.ANY_URI)));
    }

    @Test
    public void intersectAnyURINegatedURIValue() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        List<ATermAppl> types = Arrays.asList(Datatypes.ANY_URI, TermFactory.not((ATermAppl)TermFactory.value((ATermAppl)TermFactory.literal((String)"http://example.org", (ATermAppl)Datatypes.ANY_URI))));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types));
        Assert.assertTrue((boolean)this.reasoner.containsAtLeast(2, types));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"http://example.com", (ATermAppl)Datatypes.ANY_URI)));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(types, (Object)TermFactory.literal((String)"http://example.org", (ATermAppl)Datatypes.ANY_URI)));
    }

    @Test
    public void unionWithEmptyDatatype() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl dt1 = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)1)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((int)3))});
        ATermAppl dt2 = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((int)4)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((int)6))});
        ATermAppl dt3 = TermFactory.and((ATermAppl)Datatypes.NEGATIVE_INTEGER, (ATermAppl)Datatypes.POSITIVE_INTEGER);
        ATermAppl datarange = TermFactory.or((ATermAppl[])new ATermAppl[]{dt1, dt2, dt3});
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(datarange)));
        Assert.assertTrue((boolean)this.reasoner.containsAtLeast(6, Collections.singleton(datarange)));
        Assert.assertFalse((boolean)this.reasoner.containsAtLeast(7, Collections.singleton(datarange)));
    }

    @Test
    public void emptyFloatInterval() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl emptyFloatRestriction = TermFactory.restrict((ATermAppl)Datatypes.FLOAT, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((float)Float.intBitsToFloat(0))), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((float)Float.intBitsToFloat(1)))});
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(Collections.singleton(emptyFloatRestriction)));
    }

    @Test
    public void floatRestrictionWithSevenValues() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl floatRestrictionWithSevenValues = TermFactory.restrict((ATermAppl)Datatypes.FLOAT, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((float)Float.intBitsToFloat(0))), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((float)Float.intBitsToFloat(8)))});
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(floatRestrictionWithSevenValues)));
        Assert.assertTrue((boolean)this.reasoner.containsAtLeast(7, Collections.singleton(floatRestrictionWithSevenValues)));
        Assert.assertFalse((boolean)this.reasoner.containsAtLeast(8, Collections.singleton(floatRestrictionWithSevenValues)));
    }

    @Test
    public void floatExclusiveRandom() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        try {
            float high = rand.nextFloat();
            float low = rand.nextFloat();
            if (low > high) {
                float tmp = low;
                low = high;
                high = tmp;
            }
            ATermAppl floatExclusiveRandom = TermFactory.restrict((ATermAppl)Datatypes.FLOAT, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((float)Float.valueOf(low).floatValue())), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((float)Float.valueOf(high).floatValue()))});
            int size = Float.floatToIntBits(high) - Float.floatToIntBits(low) - 1;
            Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(floatExclusiveRandom)));
            Assert.assertTrue((boolean)this.reasoner.containsAtLeast(size, Collections.singleton(floatExclusiveRandom)));
            Assert.assertFalse((boolean)this.reasoner.containsAtLeast(size + 1, Collections.singleton(floatExclusiveRandom)));
        }
        catch (AssertionError e) {
            System.err.println("Random seed: " + seed);
            throw e;
        }
    }

    @Test
    public void floatTwoZeros() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl floatTwoZeros = TermFactory.restrict((ATermAppl)Datatypes.FLOAT, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((float)-1.4E-45f)), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((float)Float.MIN_VALUE))});
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(floatTwoZeros)));
        Assert.assertTrue((boolean)this.reasoner.containsAtLeast(2, Collections.singleton(floatTwoZeros)));
        Assert.assertFalse((boolean)this.reasoner.containsAtLeast(3, Collections.singleton(floatTwoZeros)));
    }

    @Test
    public void floatInterval() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl floatInterval = TermFactory.restrict((ATermAppl)Datatypes.FLOAT, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((float)1.0f)), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((float)2.0f))});
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(Collections.singleton(TermFactory.not((ATermAppl)floatInterval)), (Object)Float.valueOf(1.0f)));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(Collections.singleton(TermFactory.not((ATermAppl)floatInterval)), (Object)Float.valueOf(1.5f)));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(TermFactory.not((ATermAppl)floatInterval)), (Object)Float.valueOf(2.0f)));
    }

    @Test
    public void emptyIntegerInterval() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl integerExclusiveInterval = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((int)0)), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((int)1))});
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(Collections.singleton(integerExclusiveInterval)));
    }

    @Test
    public void integerTwoValues() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl integerExclusiveInterval = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((int)-1)), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((int)1))});
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(integerExclusiveInterval)));
        Assert.assertTrue((boolean)this.reasoner.containsAtLeast(1, Collections.singleton(integerExclusiveInterval)));
        Assert.assertFalse((boolean)this.reasoner.containsAtLeast(2, Collections.singleton(integerExclusiveInterval)));
    }

    @Test
    public void integerExclusiveIntervalExtreme() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl integerExclusiveInterval = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((int)0)), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((int)Integer.MAX_VALUE))});
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(integerExclusiveInterval)));
        Assert.assertTrue((boolean)this.reasoner.containsAtLeast(0x7FFFFFFE, Collections.singleton(integerExclusiveInterval)));
        Assert.assertFalse((boolean)this.reasoner.containsAtLeast(Integer.MAX_VALUE, Collections.singleton(integerExclusiveInterval)));
    }

    public void integerExclusiveIntervalOverflow() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl integerExclusiveInterval = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((int)Integer.MIN_VALUE)), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((int)Integer.MAX_VALUE))});
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(integerExclusiveInterval)));
        Assert.assertTrue((boolean)this.reasoner.containsAtLeast(Integer.MAX_VALUE, Collections.singleton(integerExclusiveInterval)));
    }

    @Test
    public void integerExclusiveRandom() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        long seed = System.currentTimeMillis();
        Random rand = new Random(seed);
        try {
            int low;
            int high = rand.nextInt();
            do {
                if ((low = rand.nextInt()) <= high) continue;
                int tmp = low;
                low = high;
                high = tmp;
            } while (Long.valueOf(high) - Long.valueOf(low) > Integer.MAX_VALUE);
            ATermAppl integerExclusiveInterval = TermFactory.restrict((ATermAppl)Datatypes.INTEGER, (ATermAppl[])new ATermAppl[]{TermFactory.minExclusive((ATermAppl)TermFactory.literal((int)low)), TermFactory.maxExclusive((ATermAppl)TermFactory.literal((int)high))});
            Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(integerExclusiveInterval)));
            Assert.assertTrue((boolean)this.reasoner.containsAtLeast(high - low - 1, Collections.singleton(integerExclusiveInterval)));
            Assert.assertFalse((boolean)this.reasoner.containsAtLeast(high - low, Collections.singleton(integerExclusiveInterval)));
        }
        catch (AssertionError e) {
            System.err.println("Random seed: " + seed);
            throw e;
        }
    }

    @Test
    public void userDefinedDatatypes303a() {
        ATermAppl c = TermFactory.term((String)"C");
        ATermAppl v = TermFactory.term((String)"v");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl one = TermFactory.literal((int)1);
        KnowledgeBase kb = new KnowledgeBase();
        kb.addClass(c);
        kb.addDatatypeProperty((ATerm)v);
        kb.addIndividual(i);
        kb.addSubClass(c, TermFactory.min((ATermAppl)v, (int)1, (ATermAppl)Datatypes.INTEGER));
        kb.addRange((ATerm)v, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{one}));
        kb.addType(i, c);
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, v, one));
    }

    @Test
    public void userDefinedDatatypes303b() {
        ATermAppl c = TermFactory.term((String)"C");
        ATermAppl v = TermFactory.term((String)"v");
        ATermAppl i = TermFactory.term((String)"i");
        ATermAppl one = TermFactory.literal((int)1);
        KnowledgeBase kb = new KnowledgeBase();
        kb.addClass(c);
        kb.addDatatypeProperty((ATerm)v);
        kb.addIndividual(i);
        kb.addSubClass(c, TermFactory.some((ATermAppl)v, (ATermAppl)Datatypes.INTEGER));
        kb.addRange((ATerm)v, TermFactory.oneOf((ATermAppl[])new ATermAppl[]{one}));
        kb.addType(i, c);
        Assert.assertTrue((boolean)kb.hasPropertyValue(i, v, one));
    }

    @Test
    public void anyURI383() {
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl uri = TermFactory.literal((URI)URI.create("http://www.example.org"));
        KnowledgeBase kb = new KnowledgeBase();
        kb.addClass(C);
        kb.addClass(D);
        kb.addDatatypeProperty((ATerm)p);
        kb.addRange((ATerm)p, Datatypes.ANY_URI);
        kb.addEquivalentClass(C, TermFactory.hasValue((ATermAppl)p, (ATermAppl)uri));
        kb.addEquivalentClass(D, TermFactory.min((ATermAppl)p, (int)1, (ATermAppl)TermFactory.TOP_LIT));
        PelletTestCase.assertSubClass(kb, C, D, true);
        PelletTestCase.assertSubClass(kb, D, C, false);
    }

    @Ignore(value="See ticket #524")
    @Test
    public void incomparableDateTime() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl d = TermFactory.restrict((ATermAppl)Datatypes.DATE_TIME, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((String)"1956-01-01T04:00:00-05:00", (ATermAppl)Datatypes.DATE_TIME))});
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(d)));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(d), this.reasoner.getValue(TermFactory.literal((String)"1956-01-01T10:00:00", (ATermAppl)Datatypes.DATE_TIME))));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(Collections.singleton(d), this.reasoner.getValue(TermFactory.literal((String)"1956-01-01T10:00:00Z", (ATermAppl)Datatypes.DATE_TIME))));
    }

    @Ignore(value="Equal but not identical semantics is very counter-intuitive and currently Pellet treats equals values as identical")
    @Test
    public void equalbutNotIdenticalDateTime() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl d = TermFactory.restrict((ATermAppl)Datatypes.DATE_TIME, (ATermAppl[])new ATermAppl[]{TermFactory.minInclusive((ATermAppl)TermFactory.literal((String)"1956-06-25T04:00:00-05:00", (ATermAppl)Datatypes.DATE_TIME)), TermFactory.maxInclusive((ATermAppl)TermFactory.literal((String)"1956-06-25T04:00:00-05:00", (ATermAppl)Datatypes.DATE_TIME))});
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(d)));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(d), this.reasoner.getValue(TermFactory.literal((String)"1956-06-25T04:00:00-05:00", (ATermAppl)Datatypes.DATE_TIME))));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(Collections.singleton(d), this.reasoner.getValue(TermFactory.literal((String)"1956-06-25T10:00:00+01:00", (ATermAppl)Datatypes.DATE_TIME))));
    }

    @Ignore(value="Equal but not identical semantics is very counter-intuitive and currently Pellet treats equals values as identical")
    @Test
    public void equalbutNotIdenticalDateTimeOneOf() throws InvalidConstrainingFacetException, InvalidLiteralException, UnrecognizedDatatypeException {
        ATermAppl d = TermFactory.oneOf((ATermAppl[])new ATermAppl[]{TermFactory.literal((String)"1956-06-25T04:00:00-05:00", (ATermAppl)Datatypes.DATE_TIME)});
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(d)));
        Assert.assertTrue((boolean)this.reasoner.isSatisfiable(Collections.singleton(d), this.reasoner.getValue(TermFactory.literal((String)"1956-06-25T04:00:00-05:00", (ATermAppl)Datatypes.DATE_TIME))));
        Assert.assertFalse((boolean)this.reasoner.isSatisfiable(Collections.singleton(d), this.reasoner.getValue(TermFactory.literal((String)"1956-06-25T10:00:00+01:00", (ATermAppl)Datatypes.DATE_TIME))));
    }
}

