/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.datatypes.test;

import com.clarkparsia.pellet.datatypes.OWLRealUtils;
import com.clarkparsia.pellet.datatypes.types.real.Rational;
import org.junit.Assert;
import org.junit.Test;

public class RationalTests {
    private static Rational rational(String s) {
        return Rational.valueOf((String)s);
    }

    @Test(expected=NumberFormatException.class)
    public void invalidParseDecimalDenominator() {
        Rational.valueOf((String)" 1 / 3.3");
    }

    @Test(expected=NumberFormatException.class)
    public void invalidParseDecimalNumerator() {
        Rational.valueOf((String)" 1.1 / 3");
    }

    @Test(expected=NumberFormatException.class)
    public void invalidParseNegativeDenominator() {
        Rational.valueOf((String)" 3 / -3");
    }

    @Test(expected=NumberFormatException.class)
    public void invalidParseZeroDenominator() {
        Rational.valueOf((String)" 3 / 0");
    }

    @Test
    public void numericCompare() {
        Assert.assertEquals((long)0L, (long)RationalTests.rational("1/3").compareTo(RationalTests.rational("17/51")));
        Assert.assertEquals((long)-1L, (long)RationalTests.rational("1/3").compareTo(RationalTests.rational("18/51")));
        Assert.assertEquals((long)1L, (long)RationalTests.rational("1/3").compareTo(RationalTests.rational("16/51")));
        Assert.assertEquals((long)0L, (long)RationalTests.rational("-1/3").compareTo(RationalTests.rational("-17/51")));
        Assert.assertEquals((long)1L, (long)RationalTests.rational("-1/3").compareTo(RationalTests.rational("-18/51")));
        Assert.assertEquals((long)-1L, (long)RationalTests.rational("-1/3").compareTo(RationalTests.rational("-16/51")));
        Assert.assertEquals((long)0L, (long)new Rational((Number)1, (Number)3).compareTo(new Rational((Number)1L, (Number)3L)));
    }

    @Test
    public void objectEquals() {
        Assert.assertEquals((Object)RationalTests.rational("1/3"), (Object)RationalTests.rational("1/3"));
        Assert.assertFalse((boolean)RationalTests.rational("1/3").equals((Object)RationalTests.rational("1/4")));
        Assert.assertFalse((boolean)RationalTests.rational("1/3").equals((Object)RationalTests.rational("10/30")));
        Assert.assertFalse((boolean)RationalTests.rational("1/3").equals((Object)RationalTests.rational("-1/3")));
        Assert.assertFalse((boolean)new Rational((Number)1, (Number)3).equals((Object)new Rational((Number)1L, (Number)3L)));
    }

    @Test
    public void lexicalForm() {
        Assert.assertEquals((Object)"1 / 3", (Object)RationalTests.rational("1/3").toString());
        Assert.assertEquals((Object)"10 / 5", (Object)RationalTests.rational("10/5").toString());
        Assert.assertEquals((Object)"-1 / 3", (Object)RationalTests.rational("-1/3").toString());
        Assert.assertEquals((Object)"-10 / 5", (Object)RationalTests.rational("-10/5").toString());
    }

    @Test
    public void simplification() {
        Assert.assertEquals((Object)RationalTests.rational("1/3"), (Object)Rational.simplify((Rational)RationalTests.rational("17/51")));
        Assert.assertEquals((Object)RationalTests.rational("5/1"), (Object)Rational.simplify((Rational)RationalTests.rational("65/13")));
    }

    @Test
    public void validParse() {
        Rational r = Rational.valueOf((String)"1 / 3");
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((Object)new Rational(OWLRealUtils.getCanonicalObject((Number)1), OWLRealUtils.getCanonicalObject((Number)3)), (Object)r);
        r = Rational.valueOf((String)"12 / 36");
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((Object)new Rational(OWLRealUtils.getCanonicalObject((Number)12), OWLRealUtils.getCanonicalObject((Number)36)), (Object)r);
        r = Rational.valueOf((String)"-1 / 3");
        Assert.assertNotNull((Object)r);
        Assert.assertEquals((Object)new Rational(OWLRealUtils.getCanonicalObject((Number)-1), OWLRealUtils.getCanonicalObject((Number)3)), (Object)r);
    }
}

