/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.jena;

import com.clarkparsia.pellet.test.jena.ConcurrencyTest;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Test;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class RealizationTest {
    private static final String ONTOLOGY_PATH_ = "/test/data/misc/jena-datatypes.owl";
    private static final String PREFIX = "http://example.org/";

    @Test
    public void testDoNotReclassify() throws Exception {
        OntModel ontModel = this.loadOntologyModel(ONTOLOGY_PATH_);
        ontModel.setStrictMode(false);
        ((PelletInfGraph)ontModel.getGraph()).realize();
        Individual x = ontModel.getIndividual("http://example.org/x");
        System.err.println(x.listOntClasses(false).toList());
        ontModel.add(ontModel.createLiteralStatement(ontModel.createResource("http://example.org/y"), ontModel.getProperty("http://example.org/p"), 5));
        Individual y = ontModel.getIndividual("http://example.org/y");
        System.err.println(y.listOntClasses(false).toList());
        PelletOptions.AUTO_REALIZE = false;
        ontModel.add(ontModel.createLiteralStatement(ontModel.createResource("http://example.org/z"), ontModel.getProperty("http://example.org/p"), 15));
        Individual z = ontModel.getIndividual("http://example.org/z");
        System.err.println(z.listOntClasses(false).toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OntModel loadOntologyModel(String ontologyPath) throws IOException {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        InputStream ontStream = null;
        try {
            ontStream = ConcurrencyTest.class.getResourceAsStream(ontologyPath);
            model.read(ontStream, null, "TTL");
        }
        finally {
            if (ontStream != null) {
                ontStream.close();
            }
        }
        return model;
    }
}

