/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.owlapi;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.util.Collections;
import org.junit.After;
import org.junit.Before;
import org.mindswap.pellet.test.PelletTestSuite;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

public abstract class AbstractOWLAPITests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";
    protected static final OWLClass A = OWL.Class((String)"A");
    protected static final OWLClass B = OWL.Class((String)"B");
    protected static final OWLClass C = OWL.Class((String)"C");
    protected static final OWLClass D = OWL.Class((String)"D");
    protected static final OWLClass E = OWL.Class((String)"E");
    protected static final OWLClass F = OWL.Class((String)"F");
    protected static final OWLObjectProperty p = OWL.ObjectProperty((String)"p");
    protected static final OWLObjectProperty q = OWL.ObjectProperty((String)"q");
    protected static final OWLObjectProperty r = OWL.ObjectProperty((String)"r");
    protected static final OWLDataProperty dp = OWL.DataProperty((String)"dp");
    protected static final OWLDataProperty dq = OWL.DataProperty((String)"dq");
    protected static final OWLDataProperty dr = OWL.DataProperty((String)"dr");
    protected static final OWLNamedIndividual a = OWL.Individual((String)"a");
    protected static final OWLNamedIndividual b = OWL.Individual((String)"b");
    protected static final OWLNamedIndividual c = OWL.Individual((String)"c");
    protected static final OWLAnonymousIndividual anon = OWL.AnonymousIndividual();
    protected static final OWLLiteral lit = OWL.constant((String)"lit");
    protected OWLOntology ontology;
    protected PelletReasoner reasoner;

    public void createReasoner(OWLAxiom ... axioms) {
        this.ontology = OWL.Ontology((OWLAxiom[])axioms);
        this.reasoner = PelletReasonerFactory.getInstance().createReasoner(this.ontology);
    }

    @Before
    @After
    public void resetOntologyManager() {
        this.ontology = null;
        if (this.reasoner != null) {
            this.reasoner.dispose();
        }
        for (OWLOntology o : OWL.manager.getOntologies()) {
            OWL.manager.removeOntology(o);
        }
    }

    protected boolean processAdd(OWLAxiom axiom) {
        return this.processChange((OWLOntologyChange)new AddAxiom(this.ontology, axiom));
    }

    protected boolean processRemove(OWLAxiom axiom) {
        return this.processChange((OWLOntologyChange)new RemoveAxiom(this.ontology, axiom));
    }

    protected boolean processChange(OWLOntologyChange change) {
        return this.reasoner.processChanges(Collections.singletonList(change));
    }
}

