/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import com.clarkparsia.pellet.sparqldl.jena.JenaIOUtils;
import com.clarkparsia.pellet.test.query.ResultSetUtils;
import com.clarkparsia.pellet.test.query.SparqlDawgTester;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.util.FileManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.utils.URIUtils;

public class ARQSparqlDawgTester
implements SparqlDawgTester {
    private static final Logger log = Logger.getLogger(ARQSparqlDawgTester.class.getName());
    private List<String> avoidList = Arrays.asList("open-eq-07", "open-eq-08", "open-eq-09", "open-eq-10", "open-eq-11", "open-eq-12", "dawg-optional-filter-005-not-simplified", "date-2", "date-3", "unplus-1", "open-eq-03", "eq-1", "eq-2");
    private String queryURI = "";
    protected Set<String> graphURIs = new HashSet<String>();
    protected Set<String> namedGraphURIs = new HashSet<String>();
    protected Query query = null;
    private String resultURI = null;

    protected void afterExecution() {
    }

    protected void beforeExecution() {
    }

    protected Dataset createDataset() {
        if (this.query.getGraphURIs().isEmpty() && this.query.getNamedGraphURIs().isEmpty()) {
            return DatasetFactory.create(new ArrayList<String>(this.graphURIs), new ArrayList<String>(this.namedGraphURIs), (FileManager)FileManager.get(), (String)"");
        }
        return DatasetFactory.create((List)this.query.getGraphURIs(), (List)this.query.getNamedGraphURIs(), (FileManager)FileManager.get(), (String)"");
    }

    protected QueryExecution createQueryExecution() {
        return QueryExecutionFactory.create((Query)this.query, (Dataset)this.createDataset());
    }

    @Override
    public void setDatasetURIs(Set<String> graphURIs, Set<String> namedGraphURIs) {
        this.graphURIs = graphURIs;
        this.namedGraphURIs = namedGraphURIs;
    }

    @Override
    public void setQueryURI(String queryURI) {
        if (this.queryURI.equals(queryURI)) {
            return;
        }
        this.queryURI = queryURI;
        this.query = QueryFactory.read((String)queryURI);
    }

    @Override
    public void setResult(String resultURI) {
        this.resultURI = resultURI;
    }

    @Override
    public boolean isParsable() {
        try {
            this.query = QueryFactory.read((String)this.queryURI);
            return true;
        }
        catch (Exception e) {
            log.log(Level.INFO, e.getMessage(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCorrectlyEvaluated() {
        try {
            this.beforeExecution();
            QueryExecution exec = this.createQueryExecution();
            if (this.resultURI == null) {
                log.log(Level.WARNING, "No result set associated with this test, assumuing success!");
                boolean bl = true;
                return bl;
            }
            if (this.query.isSelectType()) {
                ResultSetRewindable real;
                ResultSetRewindable expected = ResultSetFactory.makeRewindable((ResultSet)JenaIOUtils.parseResultSet((String)this.resultURI));
                boolean correct = ResultSetUtils.assertEquals((ResultSet)expected, (ResultSet)(real = ResultSetFactory.makeRewindable((ResultSet)exec.execSelect())));
                if (!correct) {
                    this.logResults("Expected", expected);
                    this.logResults("Real", real);
                }
                boolean bl = correct;
                return bl;
            }
            if (this.query.isAskType()) {
                boolean askReal = exec.execAsk();
                boolean askExpected = JenaIOUtils.parseAskResult((String)this.resultURI);
                log.fine("Expected=" + askExpected);
                log.fine("Real=" + askReal);
                boolean bl = askReal == askExpected;
                return bl;
            }
            if (this.query.isConstructType()) {
                Model real = exec.execConstruct();
                Model expected = FileManager.get().loadModel(this.resultURI);
                log.fine("Expected=" + real);
                log.fine("Real=" + expected);
                boolean bl = real.isIsomorphicWith(expected);
                return bl;
            }
            if (this.query.isDescribeType()) {
                Model real = exec.execDescribe();
                Model expected = FileManager.get().loadModel(this.resultURI);
                log.fine("Expected=" + real);
                log.fine("Real=" + expected);
                boolean bl = real.isIsomorphicWith(expected);
                return bl;
            }
            try {
                throw new RuntimeException("The query has invalid type.");
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.afterExecution();
        }
    }

    private void logResults(String name, ResultSetRewindable results) {
        if (log.isLoggable(Level.WARNING)) {
            results.reset();
            StringBuilder sb = new StringBuilder(name + " (" + results.size() + ")=");
            while (results.hasNext()) {
                QuerySolution result = results.nextSolution();
                sb.append(result);
            }
            log.warning(sb.toString());
        }
        if (log.isLoggable(Level.FINE)) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ResultSetFormatter.out((OutputStream)out, (ResultSet)results);
            log.fine(out.toString());
        }
    }

    @Override
    public boolean isApplicable(String testURI) {
        return !this.avoidList.contains(URIUtils.getLocalName((String)testURI));
    }

    @Override
    public String getName() {
        return "ARQ";
    }
}

