/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import com.clarkparsia.pellet.test.query.EarlResultVocabulary;
import com.clarkparsia.pellet.test.query.ManifestEngineProcessor;
import com.clarkparsia.pellet.test.query.ResultEnum;
import com.clarkparsia.pellet.test.query.SingleTestResult;
import com.clarkparsia.pellet.test.query.SparqlDawgTestVocabulary;
import com.clarkparsia.pellet.test.query.SparqlDawgTester;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.sparql.vocabulary.EARL;
import com.hp.hpl.jena.sparql.vocabulary.FOAF;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.Locator;
import com.hp.hpl.jena.util.LocatorFile;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.utils.VersionInfo;

public class ManifestEngine {
    private static final Logger log = Logger.getLogger(ManifestEngine.class.getName());
    private final String manifest;
    private ManifestEngineProcessor singleTestExecutor;
    private final List<SingleTestResult> results = new ArrayList<SingleTestResult>();
    private boolean writeResults = false;

    public ManifestEngine(final SparqlDawgTester tester, String manifest) {
        this.manifest = manifest;
        this.singleTestExecutor = new ManifestEngineProcessor(){

            @Override
            public void manifestStarted(String manifestURI) {
                log.fine("START manifest: " + manifestURI);
            }

            @Override
            public void test(Resource test) {
                ManifestEngine.this.results.add(ManifestEngine.this.doSingleTest(tester, test));
            }

            @Override
            public void manifestFinished(String manifestURI) {
                log.fine("FINISH manifest: " + manifestURI);
            }
        };
    }

    public void setProcessor(ManifestEngineProcessor processor) {
        this.singleTestExecutor = processor;
    }

    public ManifestEngineProcessor setProcessor() {
        return this.singleTestExecutor;
    }

    public void run() {
        ARQ.setStrictMode();
        this.doTests();
        this.writeEarlResults();
    }

    private void writeEarlResults() {
        if (!this.writeResults) {
            return;
        }
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("doap", "http://usefulinc.com/ns/doap#");
        model.setNsPrefix("earl", EARL.getURI());
        model.setNsPrefix("foaf", FOAF.getURI());
        Resource organization = model.createResource(FOAF.Organization);
        model.add(organization, FOAF.name, "Clark & Parsia, LLC");
        model.add(organization, FOAF.homepage, "http://www.clarkparsia.com/");
        Resource project = model.createResource("http://pellet.owldl.com/", EarlResultVocabulary.Project);
        model.add(project, EarlResultVocabulary.doapName, "Pellet");
        Resource release = model.createResource(EarlResultVocabulary.Version);
        model.add(release, EarlResultVocabulary.revision, VersionInfo.getInstance().getVersionString());
        model.add(project, EarlResultVocabulary.release, (RDFNode)release);
        for (SingleTestResult result : this.results) {
            Resource resultState;
            Resource assertion = model.createResource(EARL.Assertion);
            model.add(assertion, EARL.assertedBy, (RDFNode)organization);
            Resource testResult = model.createResource(EARL.TestResult);
            switch (result.getResult()) {
                case PASS: {
                    resultState = EARL.passed;
                    break;
                }
                case FAIL: {
                    resultState = EARL.failed;
                    break;
                }
                case SKIP: {
                    resultState = EARL.NotTested;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown result type : " + result);
                }
            }
            model.add(testResult, EARL.outcome, (RDFNode)resultState);
            model.add(assertion, EARL.result, (RDFNode)testResult);
            model.add(assertion, EARL.subject, (RDFNode)project);
            model.add(assertion, EARL.test, (RDFNode)model.createResource(result.getUri().toString()));
        }
        try {
            model.write((Writer)new FileWriter("dawg-pellet-" + VersionInfo.getInstance().getVersionString() + ".rdf"), "RDF/XML-ABBREV");
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void doTests() {
        this.results.clear();
        try {
            String base = new URI(this.manifest).getPath();
            FileManager.get().addLocator((Locator)new LocatorFile(base));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this._doTest(this.manifest);
        this.printStatistics();
    }

    private void printStatistics() {
        int[] sizes = new int[]{60, 10, 10};
        String format = "| %1$-" + sizes[0] + "s| %2$-" + sizes[1] + "s| %3$-" + sizes[1] + "s|";
        char[] a = new char[String.format(format, new Object[sizes.length]).length()];
        Arrays.fill(a, '=');
        String separator = new String(a);
        log.fine(separator);
        log.fine(String.format(format, "name", "result", "time [ms]"));
        log.fine(separator);
        for (SingleTestResult test : this.results) {
            log.log(Level.FINE, String.format(format, new Object[]{test.getUri().getFragment(), test.getResult(), test.getTime()}));
        }
        log.fine(separator);
    }

    private void _doTest(String manifestURI) {
        log.fine("Processing manifest : " + manifestURI + "'.");
        this.singleTestExecutor.manifestStarted(manifestURI);
        try {
            Model model = ModelFactory.createDefaultModel();
            URI uri = URI.create(manifestURI);
            FileManager.get().readModel(model, uri.toString());
            StmtIterator i = model.listStatements(null, RDF.type, (RDFNode)SparqlDawgTestVocabulary.Manifest);
            while (i.hasNext()) {
                Statement singleTests;
                Statement stmt = i.nextStatement();
                Resource manifest = stmt.getSubject();
                Statement includeStmt = manifest.getProperty(SparqlDawgTestVocabulary.include);
                if (includeStmt != null) {
                    Resource manifestsCollection = includeStmt.getResource();
                    List<Resource> container = this.parseList(manifestsCollection);
                    for (Resource singleManifest : container) {
                        this._doTest(singleManifest.getURI());
                    }
                }
                if ((singleTests = manifest.getProperty(SparqlDawgTestVocabulary.entries)) != null) {
                    List<Resource> set = this.parseList(singleTests.getResource());
                    for (Resource singleTest : set) {
                        this.singleTestExecutor.test(singleTest);
                    }
                }
                this.singleTestExecutor.manifestFinished(manifestURI);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public SingleTestResult doSingleTest(SparqlDawgTester tester, Resource singleTest) {
        Resource testType = singleTest.getProperty(RDF.type).getResource();
        Statement statement = singleTest.getProperty(SparqlDawgTestVocabulary.approval);
        Resource testApprovalStatus = statement != null ? singleTest.getProperty(SparqlDawgTestVocabulary.approval).getResource() : SparqlDawgTestVocabulary.NotClassified;
        log.fine("Test : " + singleTest);
        log.fine("Type : " + testType.getLocalName() + " ");
        log.finer("Name : " + singleTest.getProperty(SparqlDawgTestVocabulary.name).getString());
        log.finer("Appr.: " + testApprovalStatus.getLocalName());
        log.finer("Tester: " + tester.getClass().getName());
        SingleTestResult result = this.doTestCase(tester, singleTest, testType);
        log.finer("");
        log.fine("Result: " + (Object)((Object)result.getResult()));
        log.fine("Time Elapsed: " + result.getTime());
        log.fine("--------------------------------------------------------------------");
        return result;
    }

    private List<Resource> parseList(Resource start) {
        ArrayList<Resource> set = new ArrayList<Resource>();
        Resource list = start;
        while (!RDF.nil.equals((Object)list)) {
            set.add(list.getProperty(RDF.first).getResource());
            list = list.getProperty(RDF.rest).getResource();
        }
        return set;
    }

    private SingleTestResult doSyntaxTest(SparqlDawgTester tester, Resource testCase, boolean parsable) {
        String queryFile = testCase.getProperty(SparqlDawgTestVocabulary.action).getResource().getURI();
        if (tester.isApplicable(testCase.getURI())) {
            tester.setQueryURI(queryFile);
            long startPoint = System.currentTimeMillis();
            boolean result = tester.isParsable();
            long time = System.currentTimeMillis() - startPoint;
            if (result == parsable) {
                return new SingleTestResult(URI.create(testCase.getURI()), ResultEnum.PASS, time);
            }
            if (parsable) {
                log.log(Level.SEVERE, "Fail: The input should be parsable, but parsing fails.");
            } else {
                log.log(Level.SEVERE, "Fail: The input should not be parsable, but parsing is succesful.");
            }
            return new SingleTestResult(URI.create(testCase.getURI()), ResultEnum.FAIL, time);
        }
        return new SingleTestResult(URI.create(testCase.getURI()), ResultEnum.SKIP, 0L);
    }

    private SingleTestResult doEvaluationTest(SparqlDawgTester tester, Resource testCase) {
        String queryFile = null;
        HashSet<String> dataFiles = new HashSet<String>();
        HashSet<String> graphDataFiles = new HashSet<String>();
        StmtIterator i = testCase.listProperties(SparqlDawgTestVocabulary.action);
        while (i.hasNext()) {
            Resource actionNode = i.nextStatement().getResource();
            Statement qfCandidate = actionNode.getProperty(SparqlDawgTestVocabulary.query);
            if (qfCandidate != null) {
                if (queryFile == null) {
                    queryFile = qfCandidate.getResource().getURI();
                } else {
                    throw new IllegalArgumentException("More than 1 query has been set : " + queryFile + " vs. " + qfCandidate);
                }
            }
            StmtIterator dataI = actionNode.listProperties(SparqlDawgTestVocabulary.data);
            while (dataI.hasNext()) {
                dataFiles.add(dataI.nextStatement().getResource().getURI());
            }
            StmtIterator graphDataI = actionNode.listProperties(SparqlDawgTestVocabulary.graphData);
            while (graphDataI.hasNext()) {
                graphDataFiles.add(graphDataI.nextStatement().getResource().getURI());
            }
        }
        Statement resultFileStmt = testCase.getProperty(SparqlDawgTestVocabulary.result);
        String resultFile = null;
        if (resultFileStmt != null) {
            resultFile = resultFileStmt.getResource().getURI();
        }
        if (tester.isApplicable(testCase.getURI())) {
            long startPoint = 0L;
            try {
                tester.setDatasetURIs(dataFiles, graphDataFiles);
                tester.setQueryURI(queryFile);
                tester.setResult(resultFile);
                startPoint = System.currentTimeMillis();
                boolean result = tester.isCorrectlyEvaluated();
                long time = System.currentTimeMillis() - startPoint;
                if (result) {
                    return new SingleTestResult(URI.create(testCase.getURI()), ResultEnum.PASS, time);
                }
                log.severe("Fail: Evaluation of the query is not correct.");
                return new SingleTestResult(URI.create(testCase.getURI()), ResultEnum.FAIL, time);
            }
            catch (UnsupportedFeatureException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return new SingleTestResult(URI.create(testCase.getURI()), ResultEnum.SKIP, System.currentTimeMillis() - startPoint);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return new SingleTestResult(URI.create(testCase.getURI()), ResultEnum.FAIL, System.currentTimeMillis() - startPoint);
            }
        }
        return new SingleTestResult(URI.create(testCase.getURI()), ResultEnum.SKIP, 0L);
    }

    private SingleTestResult doTestCase(SparqlDawgTester tester, Resource testCase, Resource testType) {
        if (testType.equals((Object)SparqlDawgTestVocabulary.PositiveSyntaxTest)) {
            return this.doSyntaxTest(tester, testCase, true);
        }
        if (testType.equals((Object)SparqlDawgTestVocabulary.NegativeSyntaxTest)) {
            return this.doSyntaxTest(tester, testCase, false);
        }
        if (testType.equals((Object)SparqlDawgTestVocabulary.QueryEvaluationTest)) {
            return this.doEvaluationTest(tester, testCase);
        }
        throw new RuntimeException("Unknown test type " + testType.getLocalName() + " for " + testCase);
    }

    public boolean isWriteResults() {
        return this.writeResults;
    }

    public void setWriteResults(boolean writeResults) {
        this.writeResults = writeResults;
    }
}

