/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import com.clarkparsia.jena.test.ResourceImportLoader;
import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class MiscSPARQLDLTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWineNonDistinguished() throws IOException {
        String query = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nPREFIX food: <http://www.w3.org/2001/sw/WebOnt/guide-src/food#> \nPREFIX wine: <http://www.w3.org/2001/sw/WebOnt/guide-src/wine#> \nSELECT ?Meal ?WineColor \nWHERE {\n ?Meal rdf:type food:MealCourse . \n?Meal food:hasDrink _:Wine . \n_:Wine wine:hasColor ?WineColor }";
        String ontologyFile = "/test/data/sparqldl-tests/simple/wine.rdf";
        InputStream ontologyStream = null;
        PelletOptions.TREAT_ALL_VARS_DISTINGUISHED = false;
        try {
            ontologyStream = this.getClass().getResourceAsStream(ontologyFile);
            OntDocumentManager.getInstance().setReadFailureHandler((OntDocumentManager.ReadFailureHandler)new ResourceImportLoader());
            OntModel m = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
            m.read(ontologyStream, "http://test.com/");
            m.prepare();
            Query q = QueryFactory.create((String)query);
            QueryExecution qe = SparqlDLExecutionFactory.create((Query)q, (Dataset)DatasetFactory.create((Model)m), null, (SparqlDLExecutionFactory.QueryEngineType)SparqlDLExecutionFactory.QueryEngineType.PELLET, (boolean)false);
            ResultSet rs = qe.execSelect();
            this.assertNumberOfResults(2, rs);
        }
        finally {
            if (ontologyStream != null) {
                ontologyStream.close();
            }
        }
    }

    private void assertNumberOfResults(int expected, ResultSet rs) {
        int cnt = 0;
        while (rs.hasNext()) {
            rs.next();
            ++cnt;
        }
        Assert.assertEquals((long)expected, (long)cnt);
    }
}

