/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.query;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.QueryEngine;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryAtom;
import com.clarkparsia.pellet.sparqldl.model.QueryAtomFactory;
import com.clarkparsia.pellet.sparqldl.model.QueryImpl;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.utils.TermFactory;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.test.AbstractKBTests;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.utils.ATermUtils;

public class TestBooleanQueries
extends AbstractKBTests {
    private static final ATermAppl x = ATermUtils.makeVar((String)"x");
    private static final ATermAppl y = ATermUtils.makeVar((String)"y");

    private Query query(QueryAtom ... atoms) {
        QueryImpl q = new QueryImpl(this.kb, true);
        for (QueryAtom atom : atoms) {
            q.add(atom);
        }
        return q;
    }

    private void testQuery(boolean expected, Query query) {
        Assert.assertEquals((Object)expected, (Object)(!QueryEngine.exec((Query)query).isEmpty() ? 1 : 0));
    }

    private void testABoxQuery(boolean expected, Query query) {
        Assert.assertEquals((Object)expected, (Object)QueryEngine.execBooleanABoxQuery((Query)query));
    }

    @Test
    public void testBooleanQueries() {
        this.classes(A, B);
        this.objectProperties(p);
        this.individuals(a, b);
        this.kb.addType(a, A);
        this.kb.addType(b, B);
        this.kb.addPropertyValue(p, a, b);
        Query q1 = this.query(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)A));
        Query q2 = this.query(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)B));
        Query q3 = this.query(QueryAtomFactory.PropertyValueAtom((ATermAppl)x, (ATermAppl)p, (ATermAppl)y), QueryAtomFactory.TypeAtom((ATermAppl)y, (ATermAppl)B));
        Query q4 = this.query(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)A), QueryAtomFactory.PropertyValueAtom((ATermAppl)x, (ATermAppl)p, (ATermAppl)y), QueryAtomFactory.TypeAtom((ATermAppl)y, (ATermAppl)B));
        Query q5 = this.query(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)C));
        Query q6 = this.query(QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)A), QueryAtomFactory.TypeAtom((ATermAppl)x, (ATermAppl)C));
        this.testABoxQuery(true, q1);
        this.testABoxQuery(true, q2);
        this.testABoxQuery(true, q3);
        this.testABoxQuery(true, q4);
        this.testABoxQuery(false, q5);
        this.testABoxQuery(false, q6);
        this.kb.removePropertyValue(p, a, b);
        this.testABoxQuery(true, q1);
        this.testABoxQuery(true, q2);
        this.testABoxQuery(false, q3);
        this.testABoxQuery(false, q4);
        this.testABoxQuery(false, q5);
        this.testABoxQuery(false, q6);
        this.kb.addSubClass(TermFactory.TOP, C);
        this.testABoxQuery(true, q1);
        this.testABoxQuery(true, q2);
        this.testABoxQuery(false, q3);
        this.testABoxQuery(false, q4);
        this.testABoxQuery(true, q5);
        this.testABoxQuery(true, q6);
    }

    @Test
    public void testMixedQuery() {
        this.classes(A, B, C);
        this.individuals(a);
        this.kb.addSubClass(A, C);
        this.kb.addSubClass(B, C);
        this.kb.addType(a, A);
        Query q1 = this.query(QueryAtomFactory.SubClassOfAtom((ATermAppl)x, (ATermAppl)C), QueryAtomFactory.TypeAtom((ATermAppl)y, (ATermAppl)x));
        q1.addDistVar(x, Query.VarType.CLASS);
        q1.addResultVar(x);
        QueryResult qr = QueryEngine.exec((Query)q1);
        ArrayList<ATermAppl> results = new ArrayList<ATermAppl>();
        for (ResultBinding result : qr) {
            System.out.println(result);
            results.add(result.getValue(x));
        }
        PelletTestCase.assertIteratorValues(results.iterator(), A, C);
    }

    @Test
    public void testNegatedBooleanQueries1() {
        this.classes(A, B);
        this.individuals(a);
        this.kb.addType(a, A);
        Query q1 = this.query(QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.TypeAtom((ATermAppl)a, (ATermAppl)A)));
        Query q2 = this.query(QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.TypeAtom((ATermAppl)a, (ATermAppl)B)));
        Query q3 = this.query(QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.TypeAtom((ATermAppl)a, (ATermAppl)TermFactory.not((ATermAppl)A))));
        Query q4 = this.query(QueryAtomFactory.NotKnownAtom((QueryAtom)QueryAtomFactory.TypeAtom((ATermAppl)a, (ATermAppl)TermFactory.not((ATermAppl)B))));
        this.testQuery(false, q1);
        this.testQuery(true, q2);
        this.testQuery(true, q3);
        this.testQuery(true, q4);
        this.kb.addDisjointClass(A, B);
        this.testQuery(false, q1);
        this.testQuery(true, q2);
        this.testQuery(true, q3);
        this.testQuery(false, q4);
    }
}

