/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.rbox;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.mindswap.pellet.test.AbstractKBTests;
import org.mindswap.pellet.test.PelletTestSuite;

public class DisjointPropertyTests
extends AbstractKBTests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";

    public static Test suite() {
        return new JUnit4TestAdapter(DisjointPropertyTests.class);
    }

    @org.junit.Test
    public void simpleInconcistency() {
        this.individuals(a, b, c);
        this.objectProperties(p, q);
        this.kb.addDisjointProperty(p, q);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(q, a, b);
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void subPropertyInconcistency() {
        this.individuals(a, b, c);
        this.objectProperties(p, q);
        this.kb.addDisjointProperty(p, q);
        ATermAppl subP = TermFactory.term((String)"subP");
        this.kb.addObjectProperty((ATerm)subP);
        this.kb.addSubProperty((ATerm)subP, p);
        this.kb.addPropertyValue(subP, a, b);
        this.kb.addPropertyValue(q, a, b);
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void superPropertyConcistency() {
        this.individuals(a, b, c);
        this.objectProperties(p, q);
        this.kb.addDisjointProperty(p, q);
        ATermAppl supP = TermFactory.term((String)"supP");
        this.kb.addObjectProperty((ATerm)supP);
        this.kb.addSubProperty((ATerm)p, supP);
        this.kb.addPropertyValue(supP, a, b);
        this.kb.addPropertyValue(q, b, b);
        Assert.assertTrue((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void invPropertyInconcistency() {
        this.individuals(a, b, c);
        this.objectProperties(p, q);
        this.kb.addDisjointProperty(p, q);
        ATermAppl invP = TermFactory.term((String)"invP");
        this.kb.addObjectProperty((ATerm)invP);
        this.kb.addInverseProperty(invP, p);
        this.kb.addPropertyValue(invP, b, a);
        this.kb.addPropertyValue(q, a, b);
        Assert.assertFalse((boolean)this.kb.isConsistent());
    }

    @org.junit.Test
    public void differentFromSubjects() {
        this.individuals(a, b, c);
        this.objectProperties(p, q);
        this.kb.addDisjointProperty(p, q);
        this.kb.addPropertyValue(p, a, c);
        this.kb.addPropertyValue(q, b, c);
        Assert.assertTrue((boolean)this.kb.isDifferentFrom(a, b));
    }

    @org.junit.Test
    public void differentFromObjects() {
        this.individuals(a, b, c);
        this.objectProperties(p, q);
        this.kb.addDisjointProperty(p, q);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(q, a, c);
        Assert.assertTrue((boolean)this.kb.isDifferentFrom(b, c));
    }

    @org.junit.Test
    public void test547a() {
        this.objectProperties(p, q, r);
        this.kb.addDisjointProperty(p, q);
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.TOP), TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.TOP));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isDisjointProperty(p, q));
        Assert.assertFalse((boolean)this.kb.isDisjointProperty(p, r));
        Assert.assertFalse((boolean)this.kb.isDisjointProperty(q, r));
    }

    @org.junit.Test
    public void test547b() {
        this.dataProperties(p, q, r);
        this.kb.addDisjointProperty(p, q);
        this.kb.addSubClass(TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.TOP_LIT), TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.TOP_LIT));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isDisjointProperty(p, q));
        Assert.assertFalse((boolean)this.kb.isDisjointProperty(p, r));
        Assert.assertFalse((boolean)this.kb.isDisjointProperty(q, r));
    }
}

