/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.rbox;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import com.hp.hpl.jena.ontology.ObjectProperty;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Arrays;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.test.AbstractKBTests;
import org.mindswap.pellet.test.PelletTestCase;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.utils.ATermUtils;

public class PropertyChainTests
extends AbstractKBTests {
    public static String base = "file:" + PelletTestSuite.base + "misc/";

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(PropertyChainTests.class);
    }

    @Test
    public void testInversesInPropertyChain() {
        ATermAppl hasMother = TermFactory.term((String)"hasMother");
        ATermAppl hasParent = TermFactory.term((String)"hasParent");
        ATermAppl hasSibling = TermFactory.term((String)"hasSibling");
        ATermAppl hasChild = TermFactory.term((String)"hasChild");
        this.individuals(a, b, c);
        this.objectProperties(hasMother, hasParent, hasSibling, hasChild);
        this.kb.addSubProperty((ATerm)hasMother, hasParent);
        this.kb.addInverseProperty(hasChild, hasParent);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{hasParent, hasChild}), hasSibling);
        this.kb.addPropertyValue(hasMother, a, c);
        this.kb.addPropertyValue(hasMother, b, c);
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, hasSibling, b));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(b, hasSibling, a));
        PelletTestCase.assertIteratorValues(this.kb.getPropertyValues(hasSibling, a).iterator(), a, b);
        PelletTestCase.assertIteratorValues(this.kb.getPropertyValues(hasSibling, b).iterator(), a, b);
    }

    @Test
    public void testAnonymousInversesInPropertyChain() {
        ATermAppl hasMother = TermFactory.term((String)"hasMother");
        ATermAppl hasParent = TermFactory.term((String)"hasParent");
        ATermAppl hasSibling = TermFactory.term((String)"hasSibling");
        this.individuals(a, b, c);
        this.objectProperties(hasMother, hasParent, hasSibling);
        this.kb.addSubProperty((ATerm)hasMother, hasParent);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{hasParent, TermFactory.inv((ATermAppl)hasParent)}), hasSibling);
        this.kb.addIndividual(a);
        this.kb.addIndividual(b);
        this.kb.addIndividual(c);
        this.kb.addPropertyValue(hasMother, a, c);
        this.kb.addPropertyValue(hasMother, b, c);
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, hasSibling, b));
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(b, hasSibling, a));
        PelletTestCase.assertIteratorValues(this.kb.getPropertyValues(hasSibling, a).iterator(), a, b);
        PelletTestCase.assertIteratorValues(this.kb.getPropertyValues(hasSibling, b).iterator(), a, b);
    }

    @Test
    public void testRoleAbsorptionWithPropertyChain() {
        this.classes(A, B, C, D);
        this.objectProperties(p, q, r);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        this.kb.addSubClass(C, B);
        this.kb.addEquivalentClass(C, TermFactory.some((ATermAppl)r, (ATermAppl)D));
        this.kb.addSubClass(A, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)D)));
        Assert.assertTrue((boolean)this.kb.isSubClassOf(A, C));
        this.kb.classify();
        Assert.assertTrue((boolean)this.kb.isSubClassOf(A, C));
    }

    @Ignore(value="See ticket #294")
    @Test
    public void testNestedPropertyChains() throws Exception {
        this.individuals(a, b, c, d);
        this.objectProperties(p, q, r, s, f);
        this.kb.addTransitiveProperty(r);
        this.kb.addTransitiveProperty(s);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{r, s}), f);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(q, b, c);
        this.kb.addPropertyValue(s, c, d);
        Assert.assertTrue((boolean)this.kb.hasPropertyValue(a, f, d));
        Assert.assertTrue((boolean)this.kb.isType(a, TermFactory.hasValue((ATermAppl)f, (ATermAppl)d)));
    }

    @Ignore(value="See ticket #294")
    @Test
    public void testTransitivePropertyChain() throws Exception {
        this.classes(C, D);
        this.objectProperties(p, q, r);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        this.kb.addTransitiveProperty(p);
        this.kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)D)))));
        this.kb.addSubClass(C, TermFactory.all((ATermAppl)r, (ATermAppl)TermFactory.not((ATermAppl)D)));
        Assert.assertFalse((boolean)this.kb.isSatisfiable(C));
    }

    @Test
    public void testSimplePropertyChain() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addObjectProperty((ATerm)r);
        kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q}), r);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)D))));
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addPropertyValue(p, a, b);
        kb.addPropertyValue(q, b, c);
        Assert.assertTrue((boolean)kb.isSubClassOf(C, D));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, r, c));
        Assert.assertEquals(Arrays.asList(c), (Object)kb.getPropertyValues(r, a));
    }

    @Test
    public void invalidCycle1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addObjectProperty((ATerm)r);
        kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q, r}), q);
        kb.addClass(B);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(B, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)D))));
        kb.addSubClass(C, TermFactory.some((ATermAppl)q, (ATermAppl)D));
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(d);
        kb.addPropertyValue(p, a, b);
        kb.addPropertyValue(q, b, c);
        kb.addPropertyValue(r, c, d);
        kb.prepare();
        Assert.assertTrue((boolean)kb.getRole((ATerm)q).isSimple());
        Assert.assertFalse((boolean)kb.isSubClassOf(B, C));
        Assert.assertFalse((boolean)kb.hasPropertyValue(a, q, c));
        Assert.assertTrue((boolean)kb.getPropertyValues(q, a).isEmpty());
    }

    @Test
    public void validCycle1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addObjectProperty((ATerm)r);
        kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q, r}), p);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)p), (ATermAppl)D)))));
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(d);
        kb.addPropertyValue(p, a, b);
        kb.addPropertyValue(q, b, c);
        kb.addPropertyValue(r, c, d);
        kb.prepare();
        Assert.assertFalse((boolean)kb.getRole((ATerm)p).isSimple());
        Assert.assertTrue((boolean)kb.isSubClassOf(C, D));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, p, d));
        PelletTestCase.assertIteratorValues(kb.getPropertyValues(p, a).iterator(), b, d);
    }

    @Test
    public void validCycle3() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl r2 = TermFactory.term((String)"r2");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addObjectProperty((ATerm)r);
        kb.addObjectProperty((ATerm)r2);
        kb.addEquivalentProperty(r, r2);
        kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q, r2}), r);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)D)))));
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(d);
        kb.addPropertyValue(p, a, b);
        kb.addPropertyValue(q, b, c);
        kb.addPropertyValue(r, c, d);
        kb.prepare();
        Assert.assertFalse((boolean)kb.getRole((ATerm)r).isSimple());
        Assert.assertTrue((boolean)kb.isSubClassOf(C, D));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, r, d));
        Assert.assertEquals(Arrays.asList(d), (Object)kb.getPropertyValues(r, a));
    }

    @Test
    public void testPropertyChain() {
        this.testPropertyChainBase("propertyChain.owl");
    }

    public void testPropertyChainBase(String filename) {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + filename);
        OntClass C = model.getOntClass(ns + "C");
        OntClass S0 = model.getOntClass(ns + "S0");
        OntClass R0 = model.getOntClass(ns + "R0");
        OntClass R1 = model.getOntClass(ns + "R1");
        ObjectProperty r = model.getObjectProperty(ns + "r");
        ObjectProperty s = model.getObjectProperty(ns + "s");
        int n = 17;
        Resource[] a = new Resource[n];
        for (int i = 0; i < n; ++i) {
            a[i] = model.getResource(ns + "a" + i);
        }
        Resource[] theList = new Resource[]{a[1], a[2], a[3], a[4], a[5], a[6], a[8], a[10], a[12], a[14], a[16]};
        Assert.assertTrue((boolean)r.isTransitiveProperty());
        Assert.assertFalse((boolean)s.isTransitiveProperty());
        PelletTestCase.assertIteratorValues(C.listInstances(), theList);
        PelletTestCase.assertIteratorValues(S0.listInstances(), theList);
        PelletTestCase.assertIteratorValues(R0.listInstances(), new Resource[]{a[7], a[9]});
        PelletTestCase.assertIteratorValues(R1.listInstances(), new Resource[]{a[2], a[3], a[4], a[5], a[6]});
        Model rValues = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(rValues, a[0], (Property)r, new RDFNode[]{a[7], a[9]});
        PelletTestCase.addStatements(rValues, a[1], (Property)r, new RDFNode[]{a[2], a[3], a[4], a[5], a[6]});
        PelletTestCase.addStatements(rValues, a[2], (Property)r, new RDFNode[]{a[4], a[5], a[6]});
        PelletTestCase.addStatements(rValues, a[4], (Property)r, new RDFNode[]{a[5], a[6]});
        PelletTestCase.addStatements(rValues, a[7], (Property)r, new RDFNode[]{a[9]});
        PelletTestCase.addStatements(rValues, a[8], (Property)r, new RDFNode[]{a[10]});
        PelletTestCase.assertPropertyValues((Model)model, (Property)r, rValues);
        Model sValues = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(sValues, a[0], (Property)s, new RDFNode[]{a[1], a[2], a[3], a[4], a[5], a[6], a[8], a[10], a[12], a[14], a[16]});
        PelletTestCase.addStatements(sValues, a[7], (Property)s, new RDFNode[]{a[8], a[10], a[12]});
        PelletTestCase.addStatements(sValues, a[8], (Property)s, new RDFNode[]{a[11]});
        PelletTestCase.addStatements(sValues, a[9], (Property)s, new RDFNode[]{a[12]});
        PelletTestCase.addStatements(sValues, a[10], (Property)s, new RDFNode[]{a[11]});
        PelletTestCase.addStatements(sValues, a[13], (Property)s, new RDFNode[]{a[14]});
        PelletTestCase.addStatements(sValues, a[15], (Property)s, new RDFNode[]{a[16]});
        PelletTestCase.assertPropertyValues((Model)model, (Property)s, sValues);
    }

    @Test
    public void testPropertyChainDeprecated() {
        this.testPropertyChainBase("propertyChainDeprecated.owl");
    }

    @Test
    public void testPropertyChainInvalid() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "propertyChainInvalid.owl");
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        for (Role r : kb.getRBox().getRoles()) {
            if (ATermUtils.isBuiltinProperty((ATermAppl)r.getName())) continue;
            Assert.assertTrue((String)(r + " is not simple"), (boolean)r.isSimple());
            Assert.assertFalse((String)(r + " is transitive"), (boolean)r.isTransitive());
            Assert.assertFalse((String)(r + " has complex sub roles"), (boolean)r.hasComplexSubRole());
        }
    }

    @Test
    public void testPropertyChainInverses() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "propertyChainInverses.owl");
        ObjectProperty p = model.getObjectProperty(ns + "p");
        ObjectProperty q = model.getObjectProperty(ns + "q");
        int n = 8;
        Resource[] a = new Resource[n];
        for (int i = 0; i < n; ++i) {
            a[i] = model.getResource(ns + "a" + i);
        }
        Model pValues = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(pValues, a[0], (Property)p, new RDFNode[]{a[1], a[3], a[4]});
        PelletTestCase.addStatements(pValues, a[3], (Property)p, new RDFNode[]{a[4]});
        PelletTestCase.addStatements(pValues, a[6], (Property)p, new RDFNode[]{a[0], a[1], a[3], a[4]});
        PelletTestCase.addStatements(pValues, a[7], (Property)p, new RDFNode[]{a[6], a[0], a[1], a[3], a[4]});
        PelletTestCase.assertPropertyValues((Model)model, (Property)p, pValues);
        Model qValues = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(qValues, a[0], (Property)q, new RDFNode[]{a[2], a[5]});
        PelletTestCase.addStatements(qValues, a[3], (Property)q, new RDFNode[]{a[5]});
        PelletTestCase.addStatements(qValues, a[6], (Property)q, new RDFNode[]{a[2], a[5]});
        PelletTestCase.addStatements(qValues, a[7], (Property)q, new RDFNode[]{a[2], a[5]});
        PelletTestCase.assertPropertyValues((Model)model, (Property)q, qValues);
    }

    @Test
    public void testPropertyChainValid() {
        String ns = "http://www.example.org/test#";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(base + "propertyChainValid.owl");
        ObjectProperty r = model.getObjectProperty(ns + "r");
        int n = 6;
        Resource[] a = new Resource[n];
        for (int i = 0; i < n; ++i) {
            a[i] = model.getResource(ns + "a" + i);
        }
        Model rValues = ModelFactory.createDefaultModel();
        PelletTestCase.addStatements(rValues, a[0], (Property)r, new RDFNode[]{a[3], a[5]});
        PelletTestCase.addStatements(rValues, a[1], (Property)r, new RDFNode[]{a[3], a[5]});
        PelletTestCase.addStatements(rValues, a[2], (Property)r, new RDFNode[]{a[3]});
        PelletTestCase.addStatements(rValues, a[4], (Property)r, new RDFNode[]{a[5]});
        PelletTestCase.assertPropertyValues((Model)model, (Property)r, rValues);
    }

    @Test
    public void invalidCycle2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl B = TermFactory.term((String)"B");
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q2 = TermFactory.term((String)"q2");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q2);
        kb.addObjectProperty((ATerm)q);
        kb.addObjectProperty((ATerm)r);
        kb.addEquivalentProperty(q, q2);
        kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q2, r}), q);
        kb.addClass(B);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(B, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)D))));
        kb.addSubClass(C, TermFactory.some((ATermAppl)q, (ATermAppl)D));
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(d);
        kb.addPropertyValue(p, a, b);
        kb.addPropertyValue(q, b, c);
        kb.addPropertyValue(r, c, d);
        kb.prepare();
        Assert.assertTrue((boolean)kb.getRole((ATerm)q).isSimple());
        Assert.assertFalse((boolean)kb.isSubClassOf(B, C));
        Assert.assertFalse((boolean)kb.hasPropertyValue(a, q, c));
        Assert.assertTrue((boolean)kb.getPropertyValues(q, a).isEmpty());
    }

    @Test
    public void validCycle2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl C = TermFactory.term((String)"C");
        ATermAppl D = TermFactory.term((String)"D");
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl q = TermFactory.term((String)"q");
        ATermAppl r = TermFactory.term((String)"r");
        ATermAppl a = TermFactory.term((String)"a");
        ATermAppl b = TermFactory.term((String)"b");
        ATermAppl c = TermFactory.term((String)"c");
        ATermAppl d = TermFactory.term((String)"d");
        kb.addObjectProperty((ATerm)p);
        kb.addObjectProperty((ATerm)q);
        kb.addObjectProperty((ATerm)r);
        kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q, r}), r);
        kb.addClass(C);
        kb.addClass(D);
        kb.addSubClass(C, TermFactory.some((ATermAppl)p, (ATermAppl)TermFactory.some((ATermAppl)q, (ATermAppl)TermFactory.some((ATermAppl)r, (ATermAppl)TermFactory.all((ATermAppl)TermFactory.inv((ATermAppl)r), (ATermAppl)D)))));
        kb.addIndividual(a);
        kb.addIndividual(b);
        kb.addIndividual(c);
        kb.addIndividual(d);
        kb.addPropertyValue(p, a, b);
        kb.addPropertyValue(q, b, c);
        kb.addPropertyValue(r, c, d);
        kb.prepare();
        Assert.assertFalse((boolean)kb.getRole((ATerm)r).isSimple());
        Assert.assertTrue((boolean)kb.isSubClassOf(C, D));
        Assert.assertTrue((boolean)kb.hasPropertyValue(a, r, d));
        Assert.assertEquals(Arrays.asList(d), (Object)kb.getPropertyValues(r, a));
    }

    @Test
    public void updateAfterConsistency() {
        this.classes(C, D);
        this.objectProperties(p, q, r, s);
        this.individuals(a, b, c, d);
        this.kb.addSubProperty((ATerm)TermFactory.list((ATermAppl[])new ATermAppl[]{p, q, r}), s);
        this.kb.addSubClass(C, TermFactory.all((ATermAppl)s, (ATermAppl)D));
        this.kb.addType(a, C);
        this.kb.addPropertyValue(p, a, b);
        this.kb.addPropertyValue(q, b, c);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isType(d, D));
        this.kb.addPropertyValue(r, c, d);
        Assert.assertTrue((boolean)this.kb.isType(d, D));
    }
}

