/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.rbox;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.utils.TermFactory;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.mindswap.pellet.test.AbstractKBTests;

public class PropertyCharacteristicsTests
extends AbstractKBTests {
    public static Test suite() {
        return new JUnit4TestAdapter(PropertyCharacteristicsTests.class);
    }

    @org.junit.Test
    public void reflexivePropertyCausingMerge1() {
        this.classes(A, B);
        this.individuals(a, b);
        this.objectProperties(p);
        this.kb.addReflexiveProperty(p);
        this.kb.addSymmetricProperty(p);
        this.kb.addFunctionalProperty(p);
        this.kb.addSubClass(A, B);
        this.kb.addType(a, A);
        this.kb.addType(b, A);
        this.kb.addPropertyValue(p, a, b);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSameAs(a, b));
    }

    @org.junit.Test
    public void reflexivePropertyCausingMerge2() {
        this.classes(A);
        this.individuals(a, b);
        this.objectProperties(p);
        this.kb.addReflexiveProperty(p);
        this.kb.addSymmetricProperty(p);
        this.kb.addFunctionalProperty(p);
        this.kb.addDomain((ATerm)TermFactory.TOP_OBJECT_PROPERTY, A);
        this.kb.addPropertyValue(p, a, b);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isSameAs(a, b));
    }

    @org.junit.Test
    public void irreflexiveSH() {
        this.objectProperties(p);
        this.kb.addIrreflexiveProperty(TermFactory.inv((ATermAppl)p));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isIrreflexiveProperty(p));
    }

    @org.junit.Test
    public void test376() {
        this.annotationProperties(p);
        Assert.assertFalse((boolean)this.kb.isFunctionalProperty(p));
    }

    @org.junit.Test
    public void testReflexiveDisjoint() {
        this.classes(C);
        this.objectProperties(p, q);
        this.kb.addReflexiveProperty(p);
        this.kb.addDomain((ATerm)q, C);
        this.kb.addRange((ATerm)q, TermFactory.not((ATermAppl)C));
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertFalse((boolean)this.kb.isDisjointProperty(p, q));
    }

    @org.junit.Test
    public void testAsymmetricEquivalent() {
        this.objectProperties(q, r);
        this.kb.addAsymmetricProperty(q);
        this.kb.addEquivalentProperty(q, r);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isAsymmetricProperty(q));
        Assert.assertTrue((boolean)this.kb.isAsymmetricProperty(r));
    }

    @org.junit.Test
    public void testAsymmetricInverseDisjoint() {
        this.objectProperties(p, q, r);
        this.kb.addInverseProperty(p, q);
        this.kb.addAsymmetricProperty(q);
        this.kb.addEquivalentProperty(q, r);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isDisjointProperty(p, q));
        Assert.assertTrue((boolean)this.kb.isDisjointProperty(p, r));
    }

    @org.junit.Test
    public void testReflexiveSubPropertyExplicit() {
        this.objectProperties(p, q);
        this.kb.addReflexiveProperty(p);
        this.kb.addSubProperty((ATerm)p, q);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isReflexiveProperty(p));
        Assert.assertTrue((boolean)this.kb.isReflexiveProperty(q));
    }

    @org.junit.Test
    public void testReflexiveSubPropertyImplicit() {
        this.classes(C);
        this.objectProperties(p, q);
        this.kb.addSubClass(TermFactory.TOP, TermFactory.self((ATermAppl)p));
        this.kb.addSubProperty((ATerm)p, q);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isReflexiveProperty(p));
        Assert.assertTrue((boolean)this.kb.isReflexiveProperty(q));
    }

    @org.junit.Test
    public void testIrreflexive() {
        this.objectProperties(p, q);
        this.kb.addIrreflexiveProperty(p);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isIrreflexiveProperty(p));
    }

    @org.junit.Test
    public void testIrreflexiveAsymetric() {
        this.objectProperties(p, q);
        this.kb.addAsymmetricProperty(p);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isIrreflexiveProperty(p));
        Assert.assertFalse((boolean)this.kb.isReflexiveProperty(p));
    }

    @org.junit.Test
    public void testNotIrreflexive() {
        this.objectProperties(p, q);
        this.kb.addIrreflexiveProperty(p);
        this.kb.addSubProperty((ATerm)p, q);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isIrreflexiveProperty(p));
        Assert.assertFalse((boolean)this.kb.isIrreflexiveProperty(q));
    }

    @org.junit.Test
    public void irreflexivePropertyCausingDifferentFrom() {
        this.individuals(a, b);
        this.objectProperties(p);
        this.kb.addIrreflexiveProperty(p);
        this.kb.addPropertyValue(p, a, b);
        Assert.assertTrue((boolean)this.kb.isConsistent());
        Assert.assertTrue((boolean)this.kb.isDifferentFrom(a, b));
    }
}

