/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.test.rbox;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.XSD;
import com.clarkparsia.pellet.test.owlapi.AbstractOWLAPITests;
import com.clarkparsia.pellet.utils.PropertiesBuilder;
import java.util.Properties;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.mindswap.pellet.PelletOptions;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class RBoxUpdateTests
extends AbstractOWLAPITests {
    private static Properties oldOptions;

    public static Test suite() {
        return new JUnit4TestAdapter(RBoxUpdateTests.class);
    }

    @BeforeClass
    public static void enableTracing() {
        Properties newOptions = PropertiesBuilder.singleton((String)"USE_TRACING", (String)"true");
        oldOptions = PelletOptions.setOptions((Properties)newOptions);
    }

    @AfterClass
    public static void resetTracing() {
        PelletOptions.setOptions((Properties)oldOptions);
    }

    @org.junit.Test
    public void removeDataPropertyDomainAxiom() {
        this.createReasoner(new OWLAxiom[]{OWL.declaration((OWLEntity)dp), OWL.declaration((OWLEntity)C), OWL.domain((OWLDataPropertyExpression)dp, (OWLClassExpression)C), OWL.propertyAssertion((OWLIndividual)a, (OWLDataPropertyExpression)dp, (OWLLiteral)lit)});
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)C)));
        boolean changeApplied = this.processRemove((OWLAxiom)OWL.domain((OWLDataPropertyExpression)dp, (OWLClassExpression)C));
        Assert.assertTrue((String)"Unable to remove data property domain axiom", (boolean)changeApplied);
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)C)));
    }

    @org.junit.Test
    public void removeDataPropertyDomainAxiomExpression() {
        this.createReasoner(new OWLAxiom[]{OWL.declaration((OWLEntity)dp), OWL.declaration((OWLEntity)C), OWL.declaration((OWLEntity)D), OWL.domain((OWLDataPropertyExpression)dp, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{C, D})), OWL.propertyAssertion((OWLIndividual)a, (OWLDataPropertyExpression)dp, (OWLLiteral)lit)});
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{C, D}))));
        boolean changeApplied = this.processRemove((OWLAxiom)OWL.domain((OWLDataPropertyExpression)dp, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{C, D})));
        Assert.assertTrue((String)"Unable to remove data property domain axiom", (boolean)changeApplied);
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{C, D}))));
    }

    @org.junit.Test
    public void removeDataPropertyRangeAxiom() {
        this.createReasoner(new OWLAxiom[]{OWL.declaration((OWLEntity)dp), OWL.declaration((OWLEntity)C), OWL.range((OWLDataPropertyExpression)dp, (OWLDataRange)XSD.INTEGER), OWL.propertyAssertion((OWLIndividual)a, (OWLDataPropertyExpression)dp, (OWLLiteral)OWL.constant((String)"foo"))});
        Assert.assertFalse((boolean)this.reasoner.isConsistent());
        boolean changeApplied = this.processRemove((OWLAxiom)OWL.range((OWLDataPropertyExpression)dp, (OWLDataRange)XSD.INTEGER));
        Assert.assertTrue((String)"Unable to remove data property range axiom", (boolean)changeApplied);
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
    }

    @org.junit.Test
    public void removeObjectPropertyDomainAxiom() {
        this.createReasoner(new OWLAxiom[]{OWL.declaration((OWLEntity)p), OWL.declaration((OWLEntity)C), OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)C), OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)b)});
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)C)));
        boolean changeApplied = this.processRemove((OWLAxiom)OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)C));
        Assert.assertTrue((String)"Unable to remove object property domain axiom", (boolean)changeApplied);
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)C)));
    }

    @org.junit.Test
    public void removeObjectPropertyDomainAxiomExpression() {
        this.createReasoner(new OWLAxiom[]{OWL.declaration((OWLEntity)p), OWL.declaration((OWLEntity)C), OWL.declaration((OWLEntity)D), OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{C, D})), OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)b)});
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{C, D}))));
        boolean changeApplied = this.processRemove((OWLAxiom)OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{C, D})));
        Assert.assertTrue((String)"Unable to remove object property domain axiom", (boolean)changeApplied);
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{C, D}))));
    }

    @org.junit.Test
    public void removeObjectPropertyRangeAxiom() {
        this.createReasoner(new OWLAxiom[]{OWL.declaration((OWLEntity)p), OWL.declaration((OWLEntity)C), OWL.range((OWLObjectPropertyExpression)p, (OWLClassExpression)C), OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)b)});
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)b, (OWLClassExpression)C)));
        boolean changeApplied = this.processRemove((OWLAxiom)OWL.range((OWLObjectPropertyExpression)p, (OWLClassExpression)C));
        Assert.assertTrue((String)"Unable to remove object property range axiom", (boolean)changeApplied);
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)b, (OWLClassExpression)C)));
    }

    @org.junit.Test
    public void removeObjectPropertyRangeAxiomExpression() {
        this.createReasoner(new OWLAxiom[]{OWL.declaration((OWLEntity)p), OWL.declaration((OWLEntity)C), OWL.declaration((OWLEntity)D), OWL.range((OWLObjectPropertyExpression)p, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{C, D})), OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)b)});
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)b, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{C, D}))));
        boolean changeApplied = this.processRemove((OWLAxiom)OWL.range((OWLObjectPropertyExpression)p, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{C, D})));
        Assert.assertTrue((String)"Unable to remove object property range axiom", (boolean)changeApplied);
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertFalse((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)b, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{C, D}))));
    }

    @org.junit.Test
    public void removeAndAddObjectPropertyDomainAxiom() {
        this.createReasoner(new OWLAxiom[]{OWL.declaration((OWLEntity)p), OWL.declaration((OWLEntity)C), OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)C), OWL.propertyAssertion((OWLIndividual)a, (OWLObjectPropertyExpression)p, (OWLIndividual)b)});
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)C)));
        boolean removeApplied = this.processRemove((OWLAxiom)OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)C));
        Assert.assertTrue((String)"Unable to remove object property domain axiom", (boolean)removeApplied);
        boolean addApplied = this.processAdd((OWLAxiom)OWL.domain((OWLObjectPropertyExpression)p, (OWLClassExpression)C));
        Assert.assertTrue((String)"Unable to add object property domain axiom", (boolean)addApplied);
        Assert.assertTrue((boolean)this.reasoner.isConsistent());
        Assert.assertTrue((boolean)this.reasoner.isEntailed((OWLAxiom)OWL.classAssertion((OWLIndividual)a, (OWLClassExpression)C)));
    }
}

