/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.lintpattern.ontology;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.pellint.lintpattern.ontology.TooManyDifferentIndividualsPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.test.PellintTestCase;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class TooManyDifferentIndividualsPatternTest
extends PellintTestCase {
    private TooManyDifferentIndividualsPattern m_Pattern;

    @Override
    @Before
    public void setUp() throws OWLOntologyCreationException {
        super.setUp();
        this.m_Pattern = new TooManyDifferentIndividualsPattern();
    }

    @Test
    public void testNone() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.differentFrom((OWLIndividual)this.m_Ind[0], (OWLIndividual)this.m_Ind[1]));
        this.addAxiom((OWLAxiom)OWL.differentFrom((OWLIndividual)this.m_Ind[2], (OWLIndividual)this.m_Ind[3]));
        this.m_Pattern.setMaxAllowed(3);
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)0L, (long)lints.size());
        Assert.assertFalse((boolean)this.m_Pattern.isFixable());
    }

    @Test
    public void testOne() throws OWLException {
        this.addAxiom((OWLAxiom)OWL.differentFrom((Set)CollectionUtil.asSet((Object[])new OWLIndividual[]{this.m_Ind[0], this.m_Ind[1], this.m_Ind[2]})));
        this.m_Pattern.setMaxAllowed(3);
        List lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)0L, (long)lints.size());
        this.addAxiom((OWLAxiom)OWL.differentFrom((OWLIndividual)this.m_Ind[3], (OWLIndividual)this.m_Ind[4]));
        lints = this.m_Pattern.match(this.m_Ontology);
        Assert.assertEquals((long)1L, (long)lints.size());
        Lint lint = (Lint)lints.get(0);
        Assert.assertNull((Object)lint.getLintFixer());
        Assert.assertEquals((double)8.0, (double)lint.getSeverity().doubleValue(), (double)1.0E-6);
        Assert.assertSame((Object)this.m_Ontology, (Object)lint.getParticipatingOntology());
    }
}

