/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.test.rdfxml;

import com.clarkparsia.pellint.rdfxml.DoubtfulSet;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Collections;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DoubtfulSetTest {
    private DoubtfulSet<String> m_Set;
    private String[] m_Str;

    @Before
    public void setUp() {
        this.m_Set = new DoubtfulSet();
        this.m_Str = new String[5];
        for (int i = 0; i < this.m_Str.length; ++i) {
            this.m_Str[i] = "A" + i;
        }
    }

    @Test
    public void testAdd() {
        Assert.assertTrue((boolean)this.m_Set.isEmpty());
        this.m_Set.add((Object)this.m_Str[0]);
        Assert.assertEquals((long)1L, (long)this.m_Set.size());
        Assert.assertTrue((boolean)this.m_Set.contains((Object)this.m_Str[0]));
        Assert.assertFalse((boolean)this.m_Set.containsDefinite((Object)this.m_Str[0]));
        Assert.assertFalse((boolean)this.m_Set.contains((Object)this.m_Str[1]));
        Assert.assertFalse((boolean)this.m_Set.containsDefinite((Object)this.m_Str[1]));
        Assert.assertEquals(Collections.singleton(this.m_Str[0]), (Object)this.m_Set.getDoubtfulElements());
        Assert.assertTrue((boolean)this.m_Set.getDefiniteElements().isEmpty());
        this.m_Set.add((Object)this.m_Str[0]);
        Assert.assertEquals((long)1L, (long)this.m_Set.size());
    }

    @Test
    public void testAddDefinite() {
        this.m_Set.add((Object)this.m_Str[0]);
        this.m_Set.addDefinite((Object)this.m_Str[1]);
        this.m_Set.add((Object)this.m_Str[2]);
        this.m_Set.addDefinite((Object)this.m_Str[2]);
        this.m_Set.addDefinite((Object)this.m_Str[3]);
        this.m_Set.add((Object)this.m_Str[3]);
        Assert.assertEquals((long)4L, (long)this.m_Set.size());
        Assert.assertFalse((boolean)this.m_Set.containsDefinite((Object)this.m_Str[0]));
        Assert.assertTrue((boolean)this.m_Set.containsDefinite((Object)this.m_Str[1]));
        Assert.assertTrue((boolean)this.m_Set.containsDefinite((Object)this.m_Str[2]));
        Assert.assertTrue((boolean)this.m_Set.containsDefinite((Object)this.m_Str[3]));
        Assert.assertEquals(Collections.singleton(this.m_Str[0]), (Object)this.m_Set.getDoubtfulElements());
        Assert.assertEquals((Object)CollectionUtil.asSet((Object[])new String[]{this.m_Str[1], this.m_Str[2], this.m_Str[3]}), (Object)this.m_Set.getDefiniteElements());
    }

    @Test
    public void testRemove() {
        this.m_Set.add((Object)this.m_Str[0]);
        this.m_Set.add((Object)this.m_Str[1]);
        this.m_Set.addDefinite((Object)this.m_Str[2]);
        this.m_Set.addDefinite((Object)this.m_Str[3]);
        this.m_Set.remove((Object)this.m_Str[0]);
        this.m_Set.remove((Object)this.m_Str[2]);
        this.m_Set.remove((Object)this.m_Str[4]);
        Assert.assertEquals(Collections.singleton(this.m_Str[1]), (Object)this.m_Set.getDoubtfulElements());
        Assert.assertEquals(Collections.singleton(this.m_Str[3]), (Object)this.m_Set.getDefiniteElements());
        this.m_Set.clear();
        Assert.assertTrue((boolean)this.m_Set.getDoubtfulElements().isEmpty());
        Assert.assertTrue((boolean)this.m_Set.getDefiniteElements().isEmpty());
    }

    @Test
    public void testIteration() {
        this.m_Set.add((Object)this.m_Str[0]);
        this.m_Set.add((Object)this.m_Str[1]);
        this.m_Set.addDefinite((Object)this.m_Str[2]);
        this.m_Set.addDefinite((Object)this.m_Str[3]);
        Set set = CollectionUtil.makeSet();
        for (int i = 0; i <= 3; ++i) {
            set.add(this.m_Str[i]);
        }
        Assert.assertTrue((boolean)set.equals(this.m_Set));
        Assert.assertTrue((boolean)this.m_Set.equals((Object)set));
    }
}

