/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import aterm.ATerm;
import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import com.clarkparsia.pellet.utils.TermFactory;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Test;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class TestIsClass {
    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(TestIsClass.class);
    }

    @Test
    public void testIsClass1() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl p = TermFactory.term((String)"p");
        ATermAppl l = ATermUtils.makeTermAppl((String)"l");
        ATermAppl v = ATermUtils.makeValue((ATerm)ATermUtils.makeLiteral((ATermAppl)l));
        ATermAppl c = ATermUtils.makeSomeValues((ATerm)p, (ATerm)v);
        kb.addProperty(p);
        Assert.assertTrue((boolean)kb.isClass((ATerm)c));
    }

    @Test
    public void testIsClass2() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl l = ATermUtils.makeTermAppl((String)"l");
        ATermAppl v = ATermUtils.makeValue((ATerm)ATermUtils.makeLiteral((ATermAppl)l));
        Assert.assertFalse((boolean)kb.isClass((ATerm)v));
    }

    @Test
    public void testIsClass3() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl l1 = ATermUtils.makeTermAppl((String)"l1");
        ATermAppl l2 = ATermUtils.makeTermAppl((String)"l2");
        ATermAppl v1 = ATermUtils.makeValue((ATerm)ATermUtils.makeLiteral((ATermAppl)l1));
        ATermAppl v2 = ATermUtils.makeValue((ATerm)ATermUtils.makeLiteral((ATermAppl)l2));
        ATermAppl t = ATermUtils.makeOr((ATermAppl)v1, (ATermAppl)v2);
        Assert.assertFalse((boolean)kb.isClass((ATerm)t));
    }

    @Test
    public void testIsClass4() {
        KnowledgeBase kb = new KnowledgeBase();
        ATermAppl l = ATermUtils.makeTermAppl((String)"l");
        ATermAppl v = ATermUtils.makeValue((ATerm)ATermUtils.makeLiteral((ATermAppl)l));
        ATermAppl n = ATermUtils.makeNot((ATerm)v);
        Assert.assertFalse((boolean)kb.isClass((ATerm)n));
    }

    @Test
    public void testIsClass5() throws OWLOntologyCreationException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ontology = manager.createOntology(IRI.create((String)"http://example.org"));
        OWLDatatype dataRange = factory.getOWLDatatype(OWL2Datatype.XSD_INTEGER.getIRI());
        OWLFacetRestriction dataRangeFacetRestriction = factory.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, 1);
        OWLDatatypeRestriction dataRangeRestriction = factory.getOWLDatatypeRestriction(dataRange, new OWLFacetRestriction[]{dataRangeFacetRestriction});
        OWLDataProperty p = factory.getOWLDataProperty(IRI.create((String)"http://example#p"));
        OWLDataSomeValuesFrom dataSomeRestriction = factory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)p, (OWLDataRange)dataRangeRestriction);
        OWLClass c = factory.getOWLClass(IRI.create((String)"http://example#c"));
        OWLSubClassOfAxiom sc = factory.getOWLSubClassOfAxiom((OWLClassExpression)c, (OWLClassExpression)dataSomeRestriction);
        manager.addAxiom(ontology, (OWLAxiom)sc);
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ontology);
        Assert.assertTrue((boolean)reasoner.isConsistent());
        KnowledgeBase kb = reasoner.getKB();
        Assert.assertTrue((boolean)kb.isClass((ATerm)TermFactory.term((String)"http://example#c")));
        ATermAppl term = reasoner.term((OWLObject)dataSomeRestriction);
        term = ATermUtils.normalize((ATermAppl)term);
        Assert.assertTrue((boolean)kb.isClass((ATerm)term));
    }
}

