/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.test.WebOntTest;
import org.mindswap.pellet.test.WebOntTestCase;
import org.mindswap.pellet.utils.AlphaNumericComparator;
import org.mindswap.pellet.utils.Comparators;

@RunWith(value=Parameterized.class)
public class WebOntTestSuite {
    public static String base = PelletTestSuite.base + "owl-test/";
    private final WebOntTestCase test;

    @Parameterized.Parameters(name="{index}: {0}")
    public static List<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        WebOntTest test = new WebOntTest();
        test.setAvoidFailTests(true);
        test.setBase("file:" + base);
        test.setShowStats(0);
        File testDir = new File(base);
        File[] dirs = testDir.listFiles();
        Arrays.sort(dirs, Comparators.stringComparator);
        for (int i = 0; i < dirs.length; ++i) {
            if (dirs[i].isFile()) continue;
            File[] files = dirs[i].listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().indexOf("Manifest") != -1;
                }
            });
            Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
            for (int j = 0; j < files.length; ++j) {
                parameters.add(new Object[]{new WebOntTestCase(test, files[j], dirs[i].getName() + "-" + files[j].getName())});
            }
        }
        return parameters;
    }

    public WebOntTestSuite(WebOntTestCase test) {
        this.test = test;
    }

    @Test
    public void run() throws IOException {
        this.test.runTest();
    }
}

