/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.test.rules;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mindswap.pellet.test.PelletTestSuite;
import org.mindswap.pellet.test.WebOntTest;
import org.mindswap.pellet.test.WebOntTestCase;
import org.mindswap.pellet.utils.AlphaNumericComparator;
import org.mindswap.pellet.utils.Comparators;

@RunWith(value=Parameterized.class)
public class SWRLTestSuite {
    public static final String base = PelletTestSuite.base + "swrl-test/";
    private static List<File> IGNORE = Arrays.asList(new File(base + "equalities/Manifest002.rdf"));
    private final WebOntTestCase test;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        WebOntTest test = new WebOntTest();
        test.setAvoidFailTests(true);
        test.setBase("http://owldl.com/ontologies/swrl/tests/", "file:" + base);
        test.setShowStats(0);
        File testDir = new File(base);
        Object[] dirs = testDir.listFiles();
        Arrays.sort(dirs, Comparators.stringComparator);
        System.out.println(Arrays.toString(dirs));
        for (int i = 0; i < dirs.length; ++i) {
            System.out.println(((File)dirs[i]).getAbsolutePath());
            if (((File)dirs[i]).isFile()) continue;
            File[] files = ((File)dirs[i]).listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().indexOf("Manifest") != -1;
                }
            });
            Arrays.sort(files, AlphaNumericComparator.CASE_INSENSITIVE);
            for (int j = 0; j < files.length; ++j) {
                if (IGNORE.contains(files[j])) continue;
                parameters.add(new Object[]{new WebOntTestCase(test, files[j], "swrl-" + ((File)dirs[i]).getName() + "-" + files[j].getName())});
            }
        }
        return parameters;
    }

    public SWRLTestSuite(WebOntTestCase test) {
        this.test = test;
    }

    @Test
    public void run() throws IOException {
        this.test.runTest();
    }
}

