/*
 * Decompiled with CFR 0.152.
 */
package pellet.test;

import com.clarkparsia.owlapiv3.OWL;
import java.io.File;
import java.io.FilenameFilter;
import junit.framework.JUnit4TestAdapter;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLOntology;
import pellet.PelletClassify;
import pellet.PelletCmdApp;
import pellet.PelletConsistency;
import pellet.PelletEntailment;
import pellet.PelletExplain;
import pellet.PelletExtractInferences;
import pellet.PelletInfo;
import pellet.PelletModularity;
import pellet.PelletQuery;
import pellet.PelletRealize;
import pellet.PelletTransTree;
import pellet.PelletUnsatisfiable;
import pellet.Pellint;

public class CLITests {
    private static String[] copyOf(String[] arr, int len) {
        String[] ret = new String[len];
        for (int i = 0; i < len && i < arr.length; ++i) {
            ret[i] = arr[i];
        }
        return ret;
    }

    private static String[] prepend(String[] strs, String ... prefix) {
        String[] value = CLITests.copyOf(prefix, strs.length + prefix.length);
        for (int i = prefix.length; i < value.length; ++i) {
            value[i] = strs[i - prefix.length];
        }
        return value;
    }

    private static void runAppSimple(CLIMaker app, String ... args) {
        app.run(args);
    }

    private static void runAppVerbose(CLIMaker app, String ... args) {
        app.run(args);
        app.run(CLITests.prepend(args, "-v"));
        app.run(CLITests.prepend(args, "--verbose"));
    }

    private static void runWithLoaders(CLIMaker app, String ... args) {
        CLITests.runAppVerbose(app, args);
        app.run(CLITests.prepend(args, "-l", "OWLAPI"));
        app.run(CLITests.prepend(args, "-l", "OWLAPIv3"));
        app.run(CLITests.prepend(args, "-l", "Jena"));
    }

    private static void runWithIgnore(CLIMaker app, String ... args) {
        CLITests.runWithLoaders(app, args);
        CLITests.runWithLoaders(app, CLITests.prepend(args, "--ignore-imports"));
    }

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(CLITests.class);
    }

    @Test
    public void classify() {
        CLITests.runWithIgnore(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletClassify();
            }
        }, this.fileIRI("test/data/misc/family.owl"));
    }

    private String fileIRI(String s) {
        return this.getClass().getResource("/" + s).toString();
    }

    @Test
    public void classifyWithPersist() {
        CLITests.runWithIgnore(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletClassify();
            }
        }, "--persist", this.fileIRI("test/data/misc/family.owl"));
        File folder = new File(System.getProperty("user.dir"));
        File[] persistenceFiles = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("persisted-state-");
            }
        });
        Assert.assertTrue((persistenceFiles.length > 0 ? 1 : 0) != 0);
        CLITests.runWithIgnore(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletClassify();
            }
        }, "--persist", this.fileIRI("test/data/misc/family.owl"));
        for (File file : persistenceFiles) {
            file.delete();
        }
    }

    @Test
    public void consistency() {
        CLITests.runWithIgnore(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletConsistency();
            }
        }, this.fileIRI("test/data/misc/family.owl"));
    }

    @Test
    public void entailment() {
        CLITests.runAppVerbose(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletEntailment();
            }
        }, "-e", this.fileIRI("test/data/modularity/koala-conclusions.owl"), this.fileIRI("test/data/modularity/koala.owl"));
    }

    @Test
    public void explain() {
        CLITests.runAppVerbose(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletExplain();
            }
        }, this.fileIRI("test/data/modularity/koala.owl"));
    }

    @Test
    public void extract() {
        CLITests.runWithIgnore(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletExtractInferences();
            }
        }, this.fileIRI("test/data/misc/family.owl"));
    }

    @Test
    public void info() {
        CLITests.runAppSimple(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletInfo();
            }
        }, this.fileIRI("test/data/modularity/koala.owl"), this.fileIRI("test/data/modularity/galen.owl"), this.fileIRI("test/data/modularity/miniTambis.owl"), this.fileIRI("test/data/modularity/SUMO.owl"), this.fileIRI("test/data/modularity/SWEET.owl"), this.fileIRI("test/data/modularity/wine.owl"));
    }

    @Test
    public void modularity() {
        CLITests.runAppVerbose(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletModularity();
            }
        }, "-s", "Koala", this.fileIRI("test/data/modularity/koala.owl"));
    }

    @Test
    public void pellint() {
        CLITests.runAppVerbose(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new Pellint();
            }
        }, this.fileIRI("test/data/misc/family.owl"));
    }

    @Test
    public void query() {
        CLITests.runAppVerbose(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletQuery();
            }
        }, "-q", this.fileIRI("test/data/query/sameAs/sameAs-01.rq"), this.fileIRI("test/data/query/sameAs/data-01.ttl"));
    }

    @Test
    public void realize() {
        CLITests.runWithIgnore(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletRealize();
            }
        }, this.fileIRI("test/data/misc/family.owl"));
    }

    @Test
    public void transTree() {
        CLITests.runAppVerbose(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletTransTree();
            }
        }, "-p", "http://www.co-ode.org/ontologies/test/pellet/transitive.owl#p", this.fileIRI("test/data/misc/transitiveSub.owl"));
    }

    @Test
    public void transTree2() {
        CLITests.runAppVerbose(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletTransTree();
            }
        }, "-p", "http://www.co-ode.org/ontologies/test/pellet/transitive.owl#p", "-f", "http://www.co-ode.org/ontologies/test/pellet/transitive.owl#A", "--individuals", this.fileIRI("test/data/misc/transitiveSub.owl"));
    }

    @Test
    public void unsatisfiable() {
        CLITests.runWithLoaders(new CLIMaker(){

            @Override
            protected PelletCmdApp create() {
                return new PelletUnsatisfiable();
            }
        }, this.fileIRI("test/data/modularity/koala.owl"));
    }

    private abstract class CLIMaker {
        private CLIMaker() {
        }

        protected abstract PelletCmdApp create();

        public void run(String ... args) {
            for (OWLOntology ont : OWL.manager.getOntologies()) {
                OWL.manager.removeOntology(ont);
            }
            PelletCmdApp app = this.create();
            app.parseArgs(CLITests.prepend(args, new String[]{app.getAppCmd()}));
            app.run();
        }
    }
}

