/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.explanation.test;

import com.clarkparsia.explanation.test.JenaExplanationTest;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.SWRL;
import com.clarkparsia.owlapiv3.XSD;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mindswap.pellet.utils.SetUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;

public abstract class AbstractExplanationTest {
    static final String BASEPATH = "file:data/";
    static final OWLOntologyManager manager = OWL.manager;
    static final URI ontologyURI = URI.create("http://www.example.org/test#");
    protected boolean classify;
    private OWLClass A;
    private OWLClass B;
    private OWLClass C;
    private OWLClass D;
    private OWLClass E;
    private OWLClass F;
    private OWLObjectProperty p;
    private OWLObjectProperty q;
    private OWLObjectProperty r;
    private OWLDataProperty dp;
    private OWLDataProperty dq;
    private OWLDataProperty dr;
    private OWLIndividual a;
    private OWLIndividual b;
    private OWLIndividual c;
    private OWLIndividual d;
    private OWLIndividual anon1;
    private OWLDatatype dt;
    private SWRLVariable x;
    private SWRLVariable y;
    private SWRLVariable dx;

    public AbstractExplanationTest(boolean classify) {
        this.classify = classify;
    }

    @Before
    public void createEntities() {
        this.A = OWL.Class((String)(ontologyURI + "A"));
        this.B = OWL.Class((String)(ontologyURI + "B"));
        this.C = OWL.Class((String)(ontologyURI + "C"));
        this.D = OWL.Class((String)(ontologyURI + "D"));
        this.E = OWL.Class((String)(ontologyURI + "E"));
        this.F = OWL.Class((String)(ontologyURI + "F"));
        this.p = OWL.ObjectProperty((String)(ontologyURI + "p"));
        this.q = OWL.ObjectProperty((String)(ontologyURI + "q"));
        this.r = OWL.ObjectProperty((String)(ontologyURI + "r"));
        this.dp = OWL.DataProperty((String)(ontologyURI + "dp"));
        this.dq = OWL.DataProperty((String)(ontologyURI + "dq"));
        this.dr = OWL.DataProperty((String)(ontologyURI + "dr"));
        this.a = OWL.Individual((String)(ontologyURI + "a"));
        this.b = OWL.Individual((String)(ontologyURI + "b"));
        this.c = OWL.Individual((String)(ontologyURI + "c"));
        this.d = OWL.Individual((String)(ontologyURI + "d"));
        this.dt = OWL.Datatype((String)(ontologyURI + "dt"));
        this.anon1 = OWL.AnonymousIndividual((String)"anon1");
        this.x = SWRL.variable((String)(ontologyURI + "x"));
        this.y = SWRL.variable((String)(ontologyURI + "y"));
        this.dx = SWRL.variable((String)(ontologyURI + "dx"));
    }

    public void testInconsistencyExplanations(int max, OWLAxiom ... explanations) throws Exception {
        this.testInconsistencyExplanations(max, new OWLAxiom[][]{explanations});
    }

    public void testInconsistencyExplanations(int max, OWLAxiom[] ... explanations) throws Exception {
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.Thing, (OWLClassExpression)OWL.Nothing), max, explanations);
    }

    public void testExplanations(OWLAxiom axiom, int max, OWLAxiom ... explanations) throws Exception {
        this.testExplanations(axiom, max, new OWLAxiom[][]{explanations});
    }

    public void testExplanations(OWLAxiom axiom, int max, OWLAxiom[] ... explanations) throws Exception {
        HashSet<Set<OWLAxiom>> explanationSet = new HashSet<Set<OWLAxiom>>();
        for (Object[] objectArray : explanations) {
            explanationSet.add(SetUtils.create((Object[])objectArray));
        }
        this.testExplanations(axiom, max, explanationSet);
    }

    public abstract void testExplanations(OWLAxiom var1, int var2, Set<Set<OWLAxiom>> var3) throws Exception;

    public abstract void setupGenerators(Collection<OWLAxiom> var1) throws Exception;

    @After
    public void after() {
        for (OWLOntology ont : manager.getOntologies()) {
            manager.removeOntology(ont);
        }
    }

    @Ignore(value="This test is not valid anymore since annotation subjects do not carry type information")
    @Test
    public void annotationOnlyEntity() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.Thing), OWL.comment((OWLEntity)this.B, (String)"Annotation only class")};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.A), 0, axioms[0]);
    }

    @Test
    public void annotationOnlyDuringMUPSEntity() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.Thing), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.A), OWL.comment((OWLEntity)this.B, (String)"Annotation only class")};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.A), 0, axioms[1]);
    }

    @Test
    public void anonymousIndividualPropertyAssertion() throws Exception {
        Assume.assumeTrue((!(this instanceof JenaExplanationTest) ? 1 : 0) != 0);
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.anon1), OWL.classAssertion((OWLIndividual)this.anon1, (OWLClassExpression)this.A), OWL.subClassOf((OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.A), (OWLClassExpression)this.B)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.B), 0, axioms);
    }

    @Test
    public void declarationOnlyEntity() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.Thing), OWL.declaration((OWLEntity)this.B)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.A), 0, axioms[0]);
    }

    @Test
    public void declarationOnlyIrrelevantEntity() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.A), OWL.declaration((OWLEntity)this.p)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLClassExpression)OWL.and((OWLClassExpression[])new OWLClassExpression[]{this.B, OWL.some((OWLObjectPropertyExpression)this.p, (OWLClassExpression)OWL.Thing)}), (OWLClassExpression)this.A), 0, axioms[0]);
    }

    @Test
    public void disjointRange() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B)), OWL.range((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.C), OWL.disjointClasses((OWLClassExpression)this.B, (OWLClassExpression)this.C)};
        OWLEquivalentClassesAxiom axiom = OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.Nothing);
        OWLAxiom[] explanation = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B)), OWL.range((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.C), OWL.disjointClasses((OWLClassExpression)this.B, (OWLClassExpression)this.C)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)axiom, 0, explanation);
    }

    @Test
    public void disjointRangeSuper() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B)), OWL.range((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.C), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.D), OWL.disjointClasses((OWLClassExpression)this.D, (OWLClassExpression)this.C), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.E), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.F)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.disjointClasses((OWLClassExpression)this.B, (OWLClassExpression)this.C), 0, axioms[2], axioms[3]);
        this.testExplanations((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.Nothing), 0, axioms[0], axioms[1], axioms[2], axioms[3]);
    }

    @Test
    public void disjointSupers() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.C), OWL.disjointClasses((OWLClassExpression)this.B, (OWLClassExpression)this.C)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.Nothing), 0, axioms);
    }

    @Test
    public void koalaHardWorkingDomain() throws Exception {
        String ns = "http://protege.stanford.edu/plugins/owl/owl-library/koala.owl#";
        OWLOntology ontology = manager.loadOntology(IRI.create((String)"file:test/data/modularity/koala.owl"));
        OWLClass animal = OWL.Class((String)(ns + "Animal"));
        OWLClass person = OWL.Class((String)(ns + "Person"));
        OWLDataProperty hardWorking = OWL.DataProperty((String)(ns + "isHardWorking"));
        this.setupGenerators(ontology.getAxioms());
        this.testExplanations((OWLAxiom)OWL.domain((OWLDataPropertyExpression)hardWorking, (OWLClassExpression)animal), 0, new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)person, (OWLClassExpression)animal), OWL.domain((OWLDataPropertyExpression)hardWorking, (OWLClassExpression)person)});
    }

    @Test
    public void multipleEquivalentClasses() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)this.C), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.D), OWL.subClassOf((OWLClassExpression)this.D, (OWLClassExpression)this.E), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.E), OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.A))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)this.D), 0, axioms[0], axioms[1]);
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.D), 0, axioms[1]);
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.D), 0, axioms[1], axioms[4]);
    }

    @Test
    public void ruleTest1() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), OWL.classAssertion((OWLIndividual)this.b, (OWLClassExpression)this.B), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.A, (SWRLIArgument)this.x)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.B, (SWRLIArgument)this.x)})), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.B, (SWRLIArgument)this.x), SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLIArgument)this.x, (SWRLIArgument)this.y), SWRL.classAtom((OWLClassExpression)this.B, (SWRLIArgument)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.C, (SWRLIArgument)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), 0, axioms[0]);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.B), 0, axioms[0], axioms[3]);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.C), 1, axioms);
    }

    @Test
    public void ruleTest1b() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), OWL.classAssertion((OWLIndividual)this.b, (OWLClassExpression)this.B), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.A, (SWRLIArgument)this.x)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.B, (SWRLIArgument)this.x)})), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.B, (SWRLIArgument)this.x), SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLIArgument)this.x, (SWRLIArgument)this.y), SWRL.classAtom((OWLClassExpression)this.B, (SWRLIArgument)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.C, (SWRLIArgument)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), 0, axioms[0]);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.B), 0, axioms[0], axioms[3]);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.C), 1, axioms);
    }

    @Test
    public void ruleTest2() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subPropertyOf((OWLObjectPropertyExpression)this.q, (OWLObjectPropertyExpression)this.p), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.b), OWL.classAssertion((OWLIndividual)this.b, (OWLClassExpression)this.B), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLIArgument)this.x, (SWRLIArgument)this.y), SWRL.classAtom((OWLClassExpression)this.B, (SWRLIArgument)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.A, (SWRLIArgument)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), 1, axioms);
    }

    @Test
    public void ruleTest3() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.inverseProperties((OWLObjectPropertyExpression)this.q, (OWLObjectPropertyExpression)this.p), OWL.propertyAssertion((OWLIndividual)this.b, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.a), OWL.classAssertion((OWLIndividual)this.b, (OWLClassExpression)this.B), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLIArgument)this.x, (SWRLIArgument)this.y), SWRL.classAtom((OWLClassExpression)this.B, (SWRLIArgument)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.A, (SWRLIArgument)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), 1, axioms);
    }

    @Test
    public void ruleTest4() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.A, (SWRLIArgument)this.x)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.B, (SWRLIArgument)this.x), SWRL.classAtom((OWLClassExpression)this.C, (SWRLIArgument)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.B), 1, axioms);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.C), 1, axioms);
    }

    @Test
    public void ruleTest5() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.propertyAtom((OWLObjectPropertyExpression)this.p, (SWRLIArgument)this.x, (SWRLIArgument)this.y)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.A, (SWRLIArgument)this.x), SWRL.classAtom((OWLClassExpression)this.B, (SWRLIArgument)this.y)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), 1, axioms);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.b, (OWLClassExpression)this.B), 1, axioms);
    }

    @Test
    public void ruleTest6() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), OWL.classAssertion((OWLIndividual)this.b, (OWLClassExpression)this.B), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B), (SWRLIArgument)this.x)}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.C, (SWRLIArgument)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.C), 1, axioms);
    }

    @Test
    public void ruleBuiltinTest1() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLLiteral)OWL.constant((int)9)), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.A, (SWRLIArgument)this.x), SWRL.propertyAtom((OWLDataPropertyExpression)this.dp, (SWRLIArgument)this.x, (SWRLDArgument)this.dx), SWRL.lessThan((SWRLDArgument)this.dx, (SWRLDArgument)SWRL.constant((int)10))}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.B, (SWRLIArgument)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.B), 0, axioms);
    }

    @Test
    public void ruleBuiltinTest2() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLLiteral)OWL.constant((int)9)), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.A, (SWRLIArgument)this.x), SWRL.propertyAtom((OWLDataPropertyExpression)this.dp, (SWRLIArgument)this.x, (SWRLDArgument)this.dx), SWRL.greaterThan((SWRLDArgument)this.dx, (SWRLDArgument)SWRL.constant((int)5)), SWRL.lessThan((SWRLDArgument)this.dx, (SWRLDArgument)SWRL.constant((int)10))}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.classAtom((OWLClassExpression)this.B, (SWRLIArgument)this.x)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.B), 0, axioms);
    }

    @Test
    public void ruleBuiltinTest3() throws Exception {
        SWRLVariable y = SWRL.variable((String)(ontologyURI + "year"));
        SWRLVariable m = SWRL.variable((String)(ontologyURI + "month"));
        SWRLVariable d = SWRL.variable((String)(ontologyURI + "day"));
        OWLDataProperty year = OWL.DataProperty((String)(ontologyURI + "year"));
        OWLDataProperty month = OWL.DataProperty((String)(ontologyURI + "month"));
        OWLDataProperty day = OWL.DataProperty((String)(ontologyURI + "day"));
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLLiteral)OWL.constant((String)"2009-01-02", (OWLDatatype)XSD.DATE)), SWRL.rule((Set)SWRL.antecedent((SWRLAtom[])new SWRLAtom[]{SWRL.propertyAtom((OWLDataPropertyExpression)this.dp, (SWRLIArgument)this.x, (SWRLDArgument)this.dx), SWRL.builtIn((SWRLBuiltInsVocabulary)SWRLBuiltInsVocabulary.DATE, (SWRLDArgument[])new SWRLDArgument[]{this.dx, y, m, d})}), (Set)SWRL.consequent((SWRLAtom[])new SWRLAtom[]{SWRL.propertyAtom((OWLDataPropertyExpression)year, (SWRLIArgument)this.x, (SWRLDArgument)y), SWRL.propertyAtom((OWLDataPropertyExpression)month, (SWRLIArgument)this.x, (SWRLDArgument)m), SWRL.propertyAtom((OWLDataPropertyExpression)day, (SWRLIArgument)this.x, (SWRLDArgument)d)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)year, (OWLLiteral)OWL.constant((int)2009)), 1, axioms[0], axioms[1]);
    }

    @Test
    public void userDefinedDatatype1() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLLiteral)OWL.constant((int)9)), OWL.equivalentClasses((OWLClassExpression)this.B, (OWLClassExpression)OWL.and((OWLClassExpression[])new OWLClassExpression[]{this.A, OWL.some((OWLDataPropertyExpression)this.dp, (OWLDataRange)OWL.restrict((OWLDatatype)XSD.INTEGER, (OWLFacetRestriction[])new OWLFacetRestriction[]{OWL.maxExclusive((int)10)}))}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.B), 0, axioms);
    }

    @Test
    public void userDefinedDatatype2() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.and((OWLClassExpression[])new OWLClassExpression[]{OWL.max((OWLDataPropertyExpression)this.dp, (int)1), OWL.some((OWLDataPropertyExpression)this.dp, (OWLDataRange)OWL.restrict((OWLDatatype)XSD.INTEGER, (OWLFacetRestriction[])new OWLFacetRestriction[]{OWL.minExclusive((int)10)}))})), OWL.equivalentClasses((OWLClassExpression)this.B, (OWLClassExpression)OWL.and((OWLClassExpression[])new OWLClassExpression[]{OWL.min((OWLDataPropertyExpression)this.dp, (int)1), OWL.all((OWLDataPropertyExpression)this.dp, (OWLDataRange)OWL.restrict((OWLDatatype)XSD.INTEGER, (OWLFacetRestriction[])new OWLFacetRestriction[]{OWL.minExclusive((int)5)}))}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.B), 0, axioms);
    }

    @Test
    public void userDefinedDatatype3() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLLiteral)OWL.constant((int)9)), OWL.equivalentClasses((OWLClassExpression)this.B, (OWLClassExpression)OWL.and((OWLClassExpression[])new OWLClassExpression[]{this.A, OWL.some((OWLDataPropertyExpression)this.dp, (OWLDataRange)this.dt)})), OWL.datatypeDefinition((OWLDatatype)this.dt, (OWLDataRange)OWL.restrict((OWLDatatype)XSD.INTEGER, (OWLFacetRestriction[])new OWLFacetRestriction[]{OWL.maxExclusive((int)10)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.B), 0, axioms);
    }

    @Test
    public void datatypeEnumeration() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLLiteral)OWL.constant((int)1)), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLLiteral)OWL.constant((int)2)), OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.some((OWLDataPropertyExpression)this.dp, (OWLDataRange)this.dt)), OWL.datatypeDefinition((OWLDatatype)this.dt, (OWLDataRange)OWL.oneOf((OWLLiteral[])new OWLLiteral[]{OWL.constant((int)1), OWL.constant((int)2), OWL.constant((int)3)}))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), 0, new OWLAxiom[][]{{axioms[0], axioms[2], axioms[3]}, {axioms[1], axioms[2], axioms[3]}});
    }

    @Test
    public void transitiveProperty() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.transitive((OWLObjectPropertyExpression)this.p), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), OWL.propertyAssertion((OWLIndividual)this.b, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.c), OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.value((OWLObjectPropertyExpression)this.p, (OWLIndividual)this.c))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.b, (OWLClassExpression)this.A), 0, axioms[2], axioms[3]);
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), 0, axioms);
    }

    @Test
    public void propertyChain1() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subPropertyOf((OWLObjectPropertyExpression[])new OWLObjectProperty[]{this.p, this.q}, (OWLObjectPropertyExpression)this.r), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), OWL.propertyAssertion((OWLIndividual)this.b, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.c)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), 0, axioms[1]);
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.r, (OWLIndividual)this.c), 0, axioms);
    }

    @Test
    public void propertyChain2() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subPropertyOf((OWLObjectPropertyExpression[])new OWLObjectProperty[]{this.p, this.q}, (OWLObjectPropertyExpression)this.r), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), OWL.propertyAssertion((OWLIndividual)this.b, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.c), OWL.equivalentClasses((OWLClassExpression)this.A, (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.r, (OWLClassExpression)OWL.Thing))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), 0, axioms);
    }

    @Test
    public void inferredSubProperty() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subPropertyOf((OWLObjectPropertyExpression)this.p, (OWLObjectPropertyExpression)this.r), OWL.subPropertyOf((OWLObjectPropertyExpression)this.r, (OWLObjectPropertyExpression)this.q), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.r, (OWLIndividual)this.b), 0, axioms[0], axioms[2]);
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.b), 0, axioms);
    }

    @Test
    public void multipleDatatypeRange() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.range((OWLDataPropertyExpression)this.dp, (OWLDataRange)XSD.BYTE), OWL.range((OWLDataPropertyExpression)this.dp, (OWLDataRange)XSD.NON_POSITIVE_INTEGER), OWL.range((OWLDataPropertyExpression)this.dp, (OWLDataRange)XSD.NON_NEGATIVE_INTEGER), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.min((OWLDataPropertyExpression)this.dp, (int)1)), OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLLiteral)OWL.constant((int)0)), 0, axioms[1], axioms[2], axioms[3], axioms[4]);
    }

    @Test
    public void subPropertiesOfFunctionalDataProperty() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.functional((OWLDataPropertyExpression)this.dp), OWL.subPropertyOf((OWLDataPropertyExpression)this.dq, (OWLDataPropertyExpression)this.dp), OWL.subPropertyOf((OWLDataPropertyExpression)this.dr, (OWLDataPropertyExpression)this.dp), OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dq, (OWLLiteral)OWL.constant((int)1)), OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)OWL.some((OWLDataPropertyExpression)this.dr, (OWLDataRange)XSD.INTEGER))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dp, (OWLLiteral)OWL.constant((int)1)), 0, axioms[1], axioms[3]);
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLDataPropertyExpression)this.dr, (OWLLiteral)OWL.constant((int)1)), 0, axioms);
    }

    @Test
    public void simpleSubClass() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.B, (OWLClassExpression)this.C), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.C), 0, axioms[0], axioms[1]);
    }

    @Test
    public void simpleType() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.A), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.B), OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.all((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.classAssertion((OWLIndividual)this.a, (OWLClassExpression)this.B), 0, axioms[0], axioms[1]);
    }

    @Test
    public void simplePropertyAssertion() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), 0, axioms);
    }

    @Test
    public void subPropertyAssertion() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), OWL.subPropertyOf((OWLObjectPropertyExpression)this.p, (OWLObjectPropertyExpression)this.q)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.q, (OWLIndividual)this.b), 0, axioms);
    }

    @Test
    public void functionalPropertyInMaxCardinality() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.functional((OWLObjectPropertyExpression)this.p), OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)OWL.min((OWLObjectPropertyExpression)this.p, (int)2))};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.C, (OWLClassExpression)OWL.Nothing), 0, axioms);
    }

    @Test
    public void expressionInDomain() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B)), OWL.domain((OWLObjectPropertyExpression)this.p, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{this.C, this.D})), OWL.disjointClasses((OWLClassExpression)this.A, (OWLClassExpression)this.C)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)this.D), 0, axioms);
    }

    @Test
    public void expressionInRange() throws Exception {
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.some((OWLObjectPropertyExpression)this.p, (OWLClassExpression)this.B)), OWL.range((OWLObjectPropertyExpression)this.p, (OWLClassExpression)OWL.or((OWLClassExpression[])new OWLClassExpression[]{this.C, this.D})), OWL.disjointClasses((OWLClassExpression)this.B, (OWLClassExpression)this.C), OWL.disjointClasses((OWLClassExpression)this.B, (OWLClassExpression)this.D)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testExplanations((OWLAxiom)OWL.subClassOf((OWLClassExpression)this.A, (OWLClassExpression)OWL.Nothing), 0, axioms);
    }

    @Test
    public void differentFromAndFunctionality() throws Exception {
        Assume.assumeTrue((!this.classify ? 1 : 0) != 0);
        OWLAxiom[] axioms = new OWLAxiom[]{OWL.functional((OWLObjectPropertyExpression)this.p), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.b), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.c), OWL.propertyAssertion((OWLIndividual)this.a, (OWLObjectPropertyExpression)this.p, (OWLIndividual)this.d), OWL.differentFrom((OWLIndividual)this.b, (OWLIndividual)this.c), OWL.differentFrom((OWLIndividual)this.c, (OWLIndividual)this.d)};
        this.setupGenerators(Arrays.asList(axioms));
        this.testInconsistencyExplanations(0, new OWLAxiom[][]{{axioms[0], axioms[1], axioms[2], axioms[4]}, {axioms[0], axioms[2], axioms[3], axioms[5]}});
    }
}

