/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity.test;

import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.reachability.EntityNode;
import com.clarkparsia.reachability.Node;
import com.clarkparsia.reachability.ReachabilityGraph;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.semanticweb.owlapi.model.OWLEntity;

public class GraphSimplifyTests {
    private ReachabilityGraph graph;
    private OWLEntity[] entities;
    private EntityNode[] nodes;

    private void addEdge(int in, int out) {
        this.nodes[in].addOutput((Node)this.nodes[out]);
    }

    private void createGraph(int n) {
        this.graph = new ReachabilityGraph();
        this.entities = new OWLEntity[n];
        this.nodes = new EntityNode[n];
        for (int i = 0; i < n; ++i) {
            this.entities[i] = OWL.Class((String)("entity" + i));
            this.nodes[i] = this.graph.createEntityNode((Object)this.entities[i]);
        }
    }

    private void simplify() {
        this.graph.simplify();
        for (int i = 0; i < this.nodes.length; ++i) {
            this.nodes[i] = this.graph.getNode((Object)this.entities[i]);
        }
    }

    private void testOutputs(int n, int ... outputs) {
        Set computed = this.nodes[n].getOutputs();
        HashSet<EntityNode> expected = new HashSet<EntityNode>();
        for (int i : outputs) {
            expected.add(this.nodes[i]);
        }
        Assert.assertEquals(expected, (Object)computed);
    }

    @Test
    public void simpleTest1() {
        this.createGraph(8);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(1, 4);
        this.addEdge(1, 5);
        this.addEdge(2, 3);
        this.addEdge(2, 6);
        this.addEdge(3, 2);
        this.addEdge(3, 7);
        this.addEdge(4, 0);
        this.addEdge(4, 5);
        this.addEdge(5, 6);
        this.addEdge(6, 5);
        this.addEdge(7, 3);
        this.addEdge(7, 6);
        this.simplify();
        this.testOutputs(0, 2, 5);
        this.testOutputs(2, 5);
        this.testOutputs(5, new int[0]);
    }

    @Test
    public void simpleTest2() {
        this.createGraph(11);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(1, 3);
        this.addEdge(1, 4);
        this.addEdge(2, 5);
        this.addEdge(4, 1);
        this.addEdge(4, 6);
        this.addEdge(5, 2);
        this.addEdge(5, 7);
        this.addEdge(6, 7);
        this.addEdge(6, 8);
        this.addEdge(7, 10);
        this.addEdge(8, 9);
        this.addEdge(9, 6);
        this.addEdge(10, 8);
        this.simplify();
        this.testOutputs(0, 1);
        this.testOutputs(1, 2, 3, 6);
        this.testOutputs(2, 6);
        this.testOutputs(3, new int[0]);
    }

    @Test
    public void disconnectedTest() {
        this.createGraph(7);
        this.addEdge(0, 1);
        this.addEdge(1, 2);
        this.addEdge(2, 3);
        this.addEdge(3, 2);
        this.addEdge(4, 5);
        this.addEdge(5, 6);
        this.addEdge(6, 4);
        this.simplify();
        this.testOutputs(0, 1);
        this.testOutputs(1, 2);
        this.testOutputs(2, new int[0]);
        this.testOutputs(4, new int[0]);
    }
}

